/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PaPdatModule;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolAA55;
import promauto.utils.CRC;

public class PaMPTModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaPdatModule.class);
    protected ProtocolAA55 protocol = new ProtocolAA55(this);
    protected TagRW tagReqPos;
    protected TagRW tagReqZdv;
    protected Tag tagError;
    protected Tag tagAlarm;
    protected Tag tagCurPos;
    protected Tag tagLastPos;
    protected Tag tagSost;
    protected Tag tagSensors;
    protected Tag tagCurZdv;
    private TagRW tagFirmware;
    protected int cmdPos;
    protected int cmdZdv;
    private int[] buffout = new int[5];
    private int[] buffin = new int[10];

    public PaMPTModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagReqPos = this.tagtable.createRWInt("ReqPos", 0, 8);
        this.tagReqZdv = this.tagtable.createRWInt("ReqZdv", 0, 8);
        this.tagError = this.tagtable.createInt("Error", 0, 8);
        this.tagAlarm = this.tagtable.createInt("Alarm", 0, 8);
        this.tagCurPos = this.tagtable.createInt("CurPos", 0, 8);
        this.tagLastPos = this.tagtable.createInt("LastPos", 0, 8);
        this.tagSost = this.tagtable.createInt("Sost", 0, 8);
        this.tagSensors = this.tagtable.createInt("Sensors", 0, 8);
        this.tagCurZdv = this.tagtable.createInt("CurZdv", 0, 8);
        this.tagFirmware = this.tagtable.createRWString("firmware", "");
        this.cmdPos = 0;
        this.cmdZdv = 0;
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            if (this.tagReqPos.hasWriteValue()) {
                this.cmdPos = this.tagReqPos.getWriteValInt();
            }
            if (this.tagReqZdv.hasWriteValue()) {
                this.cmdZdv = this.tagReqZdv.getWriteValInt();
            }
            this.buffout[0] = 85;
            this.buffout[1] = 32 + this.netaddr;
            this.buffout[2] = this.cmdPos;
            this.buffout[3] = this.cmdZdv;
            this.buffout[4] = CRC.getCrc8(this.buffout, 1, 3);
            result = this.protocol.request(this.buffout, 5, this.buffin, 10, 1);
            if (result) {
                this.tagReqPos.setReadValInt(this.buffin[4]);
                this.tagReqZdv.setReadValInt(this.buffin[8]);
                this.tagError.setInt(this.buffin[0]);
                this.tagAlarm.setInt(this.buffin[1]);
                this.tagCurPos.setInt(this.buffin[3]);
                this.tagLastPos.setInt(this.buffin[2]);
                this.tagSost.setInt(this.buffin[5]);
                this.tagSensors.setInt(this.buffin[6]);
                this.tagCurZdv.setInt(this.buffin[7]);
            }
            if (this.cmdPos == this.tagReqPos.getInt()) {
                this.cmdPos = 0;
            }
            if (this.cmdZdv == this.tagReqZdv.getInt()) {
                this.cmdZdv = 0;
            }
            if (result && (this.firstPass || this.tagError.getBool())) {
                result = this.protocol.requestFirmware(this.tagFirmware);
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

