/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.plugin.raduga.DataService;
import promauto.jroboplc.plugin.raduga.Periods;
import promauto.jroboplc.plugin.raduga.Task;

public class DataServiceImpl
implements DataService {
    private static final String TABLE_LINE = "RD_LINE";
    private static final String TABLE_LINE_DOSER = "RD_LINE_DOSER";
    private static final String TABLE_LINE_PARAM = "RD_LINE_PARAM";
    private static final String TABLE_DOSER = "RD_DOSER";
    private static final String TABLE_FEEDER = "RD_FEEDER";
    private static final String TABLE_BUNKER = "RD_BUNKER";
    private static final String TABLE_PARAM = "RD_PARAM";
    private static final String TABLE_RECIPE = "RD_RECIPE";
    private static final String TABLE_TASK = "RD_TASK";
    private static final String TABLE_TASK_PRODUCT = "RD_TASK_PRODUCT";
    private static final String TABLE_TASK_PARAM = "RD_TASK_PARAM";
    private static final String TABLE_TASK_EXEC = "RD_TASK_EXEC";
    private static final String TABLE_TASK_CTL = "RD_TASK_CTL";
    private static final String TABLE_PRODUCT = "RD_PRODUCT";
    private static final String TABLE_PLACE = "RD_PLACE";
    private static final String TABLE_STATSH = "RD_STATSH";
    private static final String TABLE_STATHR = "RD_STATHR";
    private static final String TABLE_USER = "RD_USER";
    private static final String SEQ_CYCLE_ID = "SQ_RD_CYCLE_ID";
    private static final long INTERVAL_DELETE_OLD_RECORDS = 3600000L;
    Database db;
    private Statement st;
    private String sql;
    private Map<SyncType, Set<Integer>> sync;
    int shortRecs = 0;
    int shortDays = 0;
    int longRecs = 0;
    int longDays = 0;
    private long lastTimeDeleteOldRecords = 0L;

    @Override
    public void setDb(Database db) {
        this.db = db;
    }

    @Override
    public Database getDb() {
        return this.db;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.db == null) {
            throw new RuntimeException("Database is not set!");
        }
        this.st = this.db.getConnection().createStatement();
        return this.st;
    }

    @Override
    public void commit() throws SQLException {
        if (this.st != null) {
            this.st.close();
        }
        this.st = null;
        if (this.db != null) {
            this.db.commit();
        }
    }

    @Override
    public void rollback() {
        try {
            if (this.st != null) {
                this.st.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.st = null;
        if (this.db != null) {
            this.db.rollback();
        }
    }

    private void delete(String table, String field, int id) throws SQLException {
        this.sql = String.format("delete from %s where %s=%d", table, field, id);
        this.st.executeUpdate(this.sql);
    }

    @Override
    public String getLastSql() {
        return this.sql;
    }

    private int executeAndGetId(String sql) throws SQLException {
        this.sql = sql;
        this.st.executeUpdate(sql, new String[]{"id"});
        try (ResultSet keys = this.st.getGeneratedKeys();){
            if (keys.next()) {
                int n = keys.getInt(1);
                return n;
            }
        }
        return 0;
    }

    @Override
    public void startSync() {
        this.sync = new HashMap<SyncType, Set<Integer>>();
    }

    private void addSyncId(SyncType syncType, int id) {
        if (this.sync == null) {
            return;
        }
        this.sync.computeIfAbsent(syncType, k -> new HashSet()).add(id);
    }

    @Override
    public void finishSync(boolean deleteOtherStuff) throws SQLException {
        if (deleteOtherStuff) {
            this.deleteNotSynced(SyncType.PARAM, TABLE_PARAM);
            this.deleteNotSynced(SyncType.BUNKER, TABLE_BUNKER);
            this.deleteNotSynced(SyncType.DOSER, TABLE_DOSER);
            this.deleteNotSynced(SyncType.FEEDER, TABLE_FEEDER);
            this.deleteNotSynced(SyncType.LINE, TABLE_LINE);
        }
        this.sync = null;
    }

    private void deleteNotSynced(SyncType syncType, String table) throws SQLException {
        if (this.sync == null || !this.sync.containsKey((Object)syncType)) {
            return;
        }
        this.sql = String.format("update %s set deleted=1 where id not in (%s)", table, this.sync.get((Object)syncType).stream().map(String::valueOf).collect(Collectors.joining(",")));
        this.st.executeUpdate(this.sql);
    }

    @Override
    public int syncLine(String name, String descr, boolean hidden) throws SQLException {
        String sql = String.format("update or insert into %s (name, descr, hidden, deleted) values ('%s', '%s', %d, 0) matching (name)", TABLE_LINE, name, descr, hidden ? 1 : 0);
        int id = this.executeAndGetId(sql);
        this.addSyncId(SyncType.LINE, id);
        return id;
    }

    @Override
    public int syncDoser(String name) throws SQLException {
        String sql = String.format("update or insert into %s (name, deleted) values ('%s', 0) matching (name)", TABLE_DOSER, name);
        int id = this.executeAndGetId(sql);
        this.addSyncId(SyncType.DOSER, id);
        return id;
    }

    @Override
    public int syncBunker(String name) throws SQLException {
        String sql = String.format("update or insert into %s (name, deleted) values ('%s', 0) matching (name)", TABLE_BUNKER, name);
        int id = this.executeAndGetId(sql);
        this.addSyncId(SyncType.BUNKER, id);
        return id;
    }

    @Override
    public int syncFeeder(int doserId, int feederNum) throws SQLException {
        String sql = String.format("update or insert into %s (doser_id, feeder_num, deleted) values (%d, %d, 0) matching (doser_id, feeder_num)", TABLE_FEEDER, doserId, feederNum);
        int id = this.executeAndGetId(sql);
        this.addSyncId(SyncType.FEEDER, id);
        return id;
    }

    @Override
    public int syncFeederBunker(int feederId, String bunkerName) throws SQLException {
        int bunkerId = this.syncBunker(bunkerName);
        this.sql = String.format("update %s set bunker_id=%d where id=%d", TABLE_FEEDER, bunkerId, feederId);
        this.st.executeUpdate(this.sql);
        return bunkerId;
    }

    @Override
    public int syncParam(String name, String descr, String valtype) throws SQLException {
        String sql = String.format("update or insert into %s (name, descr, valtype, deleted) values ('%s', '%s', '%s', 0) matching (name)", TABLE_PARAM, name, descr, valtype);
        int id = this.executeAndGetId(sql);
        this.addSyncId(SyncType.PARAM, id);
        return id;
    }

    @Override
    public void syncLineDosers(int lineId, List<Integer> doserIds) throws SQLException {
        if (doserIds.isEmpty()) {
            this.delete(TABLE_LINE_DOSER, "line_id", lineId);
            return;
        }
        for (Integer doserId : doserIds) {
            this.sql = String.format("update or insert into %s (line_id, doser_id) values (%d, %d) matching (line_id, doser_id)", TABLE_LINE_DOSER, lineId, doserId);
            this.st.executeUpdate(this.sql);
        }
        this.sql = String.format("delete from %s where line_id=%d and doser_id not in (%s)", TABLE_LINE_DOSER, lineId, doserIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        this.st.executeUpdate(this.sql);
    }

    @Override
    public void syncLineParams(int lineId, List<Integer> paramIds) throws SQLException {
        if (paramIds.isEmpty()) {
            this.delete(TABLE_LINE_PARAM, "line_id", lineId);
            return;
        }
        for (Integer paramId : paramIds) {
            this.sql = String.format("update or insert into %s (line_id, param_id) values (%d, %d) matching (line_id, param_id)", TABLE_LINE_PARAM, lineId, paramId);
            this.st.executeUpdate(this.sql);
        }
        this.sql = String.format("delete from %s where line_id=%d and param_id not in (%s)", TABLE_LINE_PARAM, lineId, paramIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        this.st.executeUpdate(this.sql);
    }

    @Override
    public Task getTask(int taskId) throws SQLException {
        Object tp2;
        Task task = new Task();
        this.sql = String.format("select l.id, l.name, r.id, r.name, cast(t.set_weight_tot * 1000 as bigint), t.status, t.product_id from %s t join %s l on l.id=t.line_id join %s r on r.id=t.recipe_id where t.id=%d", TABLE_TASK, TABLE_LINE, TABLE_RECIPE, taskId);
        try (ResultSet rs = this.st.executeQuery(this.sql);){
            if (rs.next()) {
                task.id = taskId;
                task.lineId = rs.getInt(1);
                task.lineName = rs.getString(2);
                task.recipeId = rs.getInt(3);
                task.recipeName = rs.getString(4);
                task.status = rs.getInt(6);
                task.productId = rs.getInt(7);
                task.presented = true;
            }
        }
        this.sql = String.format("select cast(sum(weight) * 1000 as bigint) from %s te where te.task_id=%d", TABLE_TASK_EXEC, taskId);
        rs = this.st.executeQuery(this.sql);
        var4_4 = null;
        try {
            if (rs.next()) {
                task.totalExeWeight = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var4_4 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        this.sql = String.format("select tp.product_id, p.name, d.name, f.feeder_num, cast(tp.weight * 1000 as bigint) from %s tp join %s f on f.bunker_id=tp.bunker_id join %s d on d.id=f.doser_id join %s p on p.id=tp.product_id where tp.task_id=%d", TABLE_TASK_PRODUCT, TABLE_FEEDER, TABLE_DOSER, TABLE_PRODUCT, taskId);
        rs = this.st.executeQuery(this.sql);
        var4_4 = null;
        try {
            while (rs.next()) {
                tp2 = new Task.Product();
                ((Task.Product)tp2).productId = rs.getInt(1);
                ((Task.Product)tp2).productName = rs.getString(2);
                ((Task.Product)tp2).doserName = rs.getString(3);
                ((Task.Product)tp2).feederNum = rs.getInt(4);
                ((Task.Product)tp2).weight = rs.getLong(5);
                task.products.add((Task.Product)tp2);
            }
        }
        catch (Throwable tp2) {
            var4_4 = tp2;
            throw tp2;
        }
        finally {
            if (rs != null) {
                if (var4_4 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable tp2) {
                        var4_4.addSuppressed(tp2);
                    }
                } else {
                    rs.close();
                }
            }
        }
        this.sql = String.format("select p.name, tp.val from %s tp join %s p on p.id=tp.param_id where tp.task_id=%d", TABLE_TASK_PARAM, TABLE_PARAM, taskId);
        rs = this.st.executeQuery(this.sql);
        var4_4 = null;
        try {
            while (rs.next()) {
                tp2 = new Task.Param();
                ((Task.Param)tp2).paramName = rs.getString(1);
                ((Task.Param)tp2).val = rs.getString(2);
                task.params.add((Task.Param)tp2);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var4_4 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        return task;
    }

    @Override
    public int generateCycleId() throws SQLException {
        this.sql = String.format("select next value for %s from rdb$database", SEQ_CYCLE_ID);
        try (ResultSet rs = this.st.executeQuery(this.sql);){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return 0;
    }

    @Override
    public Optional<Long> getTaskExecLastSumWeightEnd(int feederId) throws SQLException {
        this.sql = String.format("select first 1 cast(te.sum_weight_end * 1000 as bigint) from %s te where te.feeder_id=%d order by id desc", TABLE_TASK_EXEC, feederId);
        try (ResultSet rs = this.st.executeQuery(this.sql);){
            if (rs.next()) {
                Optional<Long> optional = Optional.of(rs.getLong(1));
                return optional;
            }
        }
        return Optional.empty();
    }

    @Override
    public void saveTaskExec(Task.Exec te) throws SQLException {
        String sdt = this.db.formatDatetime(te.dt);
        this.sql = String.format(Locale.ROOT, "insert into %s (feeder_id, task_id, product_id, cycle_id, dt, weight, sum_weight_beg, sum_weight_end) values (%d, %s, %s, %s, '%s', %.3f, %.3f, %.3f)", TABLE_TASK_EXEC, te.feederId, this.toStringNullable(te.taskId), this.toStringNullable(te.inputProductId), this.toStringNullable(te.cycleId), sdt, (double)te.weight / 1000.0, (double)te.sumWeightBeg / 1000.0, (double)te.sumWeightEnd / 1000.0);
        this.st.executeUpdate(this.sql);
        this.updateStatWeight(TABLE_STATSH, te.periodShift, te.lineId, te.recipeId, te.inputProductId, -te.weight);
        this.updateStatWeight(TABLE_STATSH, te.periodShift, te.lineId, te.recipeId, te.outputProductId, te.weight);
        this.updateStatWeight(TABLE_STATHR, te.periodHour, te.lineId, te.recipeId, te.inputProductId, -te.weight);
        this.updateStatWeight(TABLE_STATHR, te.periodHour, te.lineId, te.recipeId, te.outputProductId, te.weight);
        this.updateBunkerWeight(te.inputBunkerId, -te.weight);
        this.updateBunkerWeight(te.outputBunkerId, te.weight);
        this.deleteOldRecords();
    }

    private void updateBunkerWeight(int bunkerId, long weight) throws SQLException {
        String sqlUpdate = "update %s set weight = weight + %.3f where id=%d";
        if (bunkerId > 0) {
            this.sql = String.format(Locale.ROOT, "update %s set weight = weight + %.3f where id=%d", TABLE_BUNKER, (double)weight / 1000.0, bunkerId);
            this.st.executeUpdate(this.sql);
        }
    }

    private void updateStatWeight(String table, int period, int lineId, int recipeId, int productId, long weight) throws SQLException {
        String sqlSelect = "select id, cast(weight * 1000 as bigint) from %s where period=%d and line_id=%d and recipe_id=%d and product_id=%d";
        String sqlInsert = "insert into %s (id, period, line_id, recipe_id, product_id, weight) values (%s, %d, %d, %d, %s, %.3f)";
        if (productId > 0) {
            this.sql = String.format("select id, cast(weight * 1000 as bigint) from %s where period=%d and line_id=%d and recipe_id=%d and product_id=%d", table, period, lineId, recipeId, productId);
            int id = 0;
            try (ResultSet rs = this.st.executeQuery(this.sql);){
                if (rs.next()) {
                    id = rs.getInt(1);
                    weight += rs.getLong(2);
                }
            }
            if (id > 0) {
                this.delete(table, "id", id);
            }
            this.sql = String.format(Locale.ROOT, "insert into %s (id, period, line_id, recipe_id, product_id, weight) values (%s, %d, %d, %d, %s, %.3f)", table, this.toStringNullable(id), period, lineId, recipeId, productId, (double)weight / 1000.0);
            this.st.executeUpdate(this.sql);
        }
    }

    @Override
    public void saveTaskCtl(int taskId, int cycleId, LocalDateTime dt, long weight) throws SQLException {
        this.sql = String.format(Locale.ROOT, "insert into %s (task_id, cycle_id, dt, weight) values (%d, %d, '%s', %.3f)", TABLE_TASK_CTL, taskId, cycleId, this.db.formatDatetime(dt), (double)weight / 1000.0);
        this.st.executeUpdate(this.sql);
        this.deleteOldRecords();
    }

    private String toStringNullable(int value) {
        return value == 0 ? "null" : String.valueOf(value);
    }

    @Override
    public void setArcSize(int shortRecs, int shortDays, int longRecs, int longDays) {
        this.shortRecs = shortRecs;
        this.shortDays = shortDays;
        this.longRecs = longRecs;
        this.longDays = longDays;
    }

    private void deleteOldRecords() throws SQLException {
        if (System.currentTimeMillis() - this.lastTimeDeleteOldRecords < 3600000L) {
            return;
        }
        this.lastTimeDeleteOldRecords = System.currentTimeMillis();
        HashSet<Integer> taskIds = new HashSet<Integer>();
        this.deleteOldRecordsShort(TABLE_TASK_EXEC, taskIds);
        this.deleteOldRecordsShort(TABLE_TASK_CTL, taskIds);
        if (taskIds.size() > 0) {
            String taskIdsStr = taskIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.sql = String.format("update %s set deleted=1 where id in (%s)", TABLE_TASK, taskIdsStr);
            this.st.executeUpdate(this.sql);
            String deleteSql = "delete from %s where %s in (%s)";
            this.sql = String.format(deleteSql, TABLE_TASK_PRODUCT, "task_id", taskIdsStr);
            this.st.executeUpdate(this.sql);
            this.sql = String.format(deleteSql, TABLE_TASK_PARAM, "task_id", taskIdsStr);
            this.st.executeUpdate(this.sql);
        }
        int period = Periods.calcPeriodHour(LocalDateTime.now().minusDays(this.longDays));
        this.sql = String.format("select max(id) from %s where id < ((select max(id) from %s) - %d) and period < %d", TABLE_STATHR, TABLE_STATHR, this.longRecs, period);
        int maxId = 0;
        try (ResultSet rs = this.st.executeQuery(this.sql);){
            if (rs.next()) {
                maxId = rs.getInt(1);
            }
        }
        if (maxId > 0) {
            this.sql = String.format("delete from %s where id <= %d", TABLE_STATHR, maxId);
            this.st.executeUpdate(this.sql);
        }
    }

    private void deleteOldRecordsShort(String table, Set<Integer> taskIds) throws SQLException {
        this.sql = String.format("select max(id) from %s where id < ((select max(id) from %s) - %d) and dt < '%s'", table, table, this.shortRecs, this.db.formatDatetimeWithOffset(LocalDateTime.now().minusDays(this.shortDays)));
        int maxId = 0;
        try (ResultSet rs = this.st.executeQuery(this.sql);){
            if (rs.next()) {
                maxId = rs.getInt(1);
            }
        }
        if (maxId == 0) {
            return;
        }
        this.sql = String.format("select task_id from %s where id <= %d and task_id is not null group by 1", table, maxId);
        rs = this.st.executeQuery(this.sql);
        var5_5 = null;
        try {
            while (rs.next()) {
                taskIds.add(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var5_5 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        this.sql = String.format("delete from %s where id <= %d", table, maxId);
        this.st.executeUpdate(this.sql);
    }

    static enum SyncType {
        LINE,
        DOSER,
        FEEDER,
        BUNKER,
        PARAM;

    }
}

