/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.raduga.Context;
import promauto.jroboplc.plugin.raduga.DataService;
import promauto.jroboplc.plugin.raduga.Doser;
import promauto.jroboplc.plugin.raduga.Line;
import promauto.jroboplc.plugin.raduga.Param;
import promauto.jroboplc.plugin.raduga.Task;

public class LineSimple
implements Line {
    private final Logger logger = LoggerFactory.getLogger(LineSimple.class);
    public static final String PARAMETER_IS_NOT_PRESENTED = "Parameter is not presented: ";
    protected static final int STATE_NONE = 0;
    protected static final int STATE_IDLE = 1;
    protected static final int STATE_PREPARING = 2;
    protected static final int STATE_SETTING = 3;
    protected static final int STATE_CAN_LOAD = 4;
    protected static final int STATE_LOADING = 5;
    protected static final int STATE_UNLOADING = 6;
    protected static final int STATE_ERROR = 99;
    protected static final int STATE_CYCLE_FINISHED = 100;
    protected static final Map<Integer, String> STATES = new HashMap<Integer, String>();
    protected static final String ERROR_TASK_NOT_FOUND = "\u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
    protected static final String ERROR_TASK_HAS_WRONG_LINE = "\u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0435 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0430 \u0434\u043b\u044f \u044d\u0442\u043e\u0439 \u043b\u0438\u043d\u0438\u0438";
    protected static final String ERROR_TASK_HAS_WRONG_STATUS = "\u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0435 \u0433\u043e\u0442\u043e\u0432\u0430 \u043a \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044e";
    protected static final String ERROR_TASK_HAS_WRONG_BUNKER = "\u0417\u0430\u0434\u0430\u0447\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0431\u0443\u043d\u043a\u0435\u0440, \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u044d\u0442\u043e\u0439 \u043b\u0438\u043d\u0438\u0438";
    protected static final String ERROR_TASK_HAS_WRONG_PARAM = "\u0417\u0430\u0434\u0430\u0447\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440, \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u044d\u0442\u043e\u0439 \u043b\u0438\u043d\u0438\u0438";
    protected static final String ERROR_DOSER_REJECTED_TASK = "\u0414\u043e\u0437\u0430\u0442\u043e\u0440 \u043d\u0435 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u0437\u0430\u0434\u0430\u0447\u0443";
    public final Context ctx;
    protected int id;
    protected String name;
    protected String dupLineName;
    protected boolean autostart;
    protected boolean hidden;
    protected TagRW tagName;
    protected TagRW tagDescr;
    protected TagRW tagTaskId;
    protected Tag tagTaskInstall;
    protected TagRW tagState;
    protected TagRW tagError;
    protected TagRW tagStateMsg;
    protected Tag tagStart;
    protected Tag tagCancel;
    protected Tag tagReset;
    protected Tag tagRestart;
    protected TagRW tagCycleId;
    protected TagRW tagRecipeId;
    protected TagRW tagRecipeName;
    protected TagRW tagRcpWeight;
    protected Tag tagSetWeight;
    protected TagRW tagExeWeight;
    protected TagRW tagExeWeightTot;
    protected Tag tagEnableLoad;
    protected Tag tagEnableUnload;
    protected Tag tagDisable;
    protected TagRW tagDstBunkerNum;
    protected TagRW tagDstBunkerName;
    protected TagRW tagDstProductId;
    protected final List<Doser> dosers;
    protected final List<Param> params;
    protected final List<Line.DstBunker> dstBunkers;

    protected LineSimple(Context ctx) {
        this.ctx = ctx;
        this.dosers = new ArrayList<Doser>();
        this.params = new ArrayList<Param>();
        this.dstBunkers = new ArrayList<Line.DstBunker>();
    }

    @Override
    public boolean load(Object conf) {
        boolean res = true;
        Configuration cm = this.ctx.env.getConfiguration();
        this.name = cm.get(conf, "name", "");
        String descr = cm.get(conf, "descr", "");
        this.hidden = cm.get(conf, "hidden", false);
        this.dstBunkers.addAll(cm.getStringList(conf, "dstBunkers").stream().map(Line.DstBunker::new).collect(Collectors.toList()));
        Map<String, Object> confParams = cm.toMap(cm.get(conf, "params"));
        for (String paramName : confParams.keySet()) {
            Param param = new Param(this.ctx, this, paramName);
            param.load(confParams.get(paramName));
            this.params.add(param);
        }
        this.dupLineName = cm.get(conf, "duplicate", "");
        this.autostart = cm.get(conf, "autostart", false);
        for (Object confDoser : cm.toList(cm.get(conf, "dosers"))) {
            Doser doser = new Doser(this.ctx, this, this.dosers.size() + 1);
            res &= doser.load(confDoser);
            this.dosers.add(doser);
        }
        if (!this.validatePresented("name", this.name)) {
            return false;
        }
        TagTable tt = this.ctx.tagtable;
        Tag[] tagArray = new Tag[13];
        this.tagTaskId = tt.createRWInt(this.makeTagName("TaskId"), 0);
        tagArray[0] = this.tagTaskId;
        tagArray[1] = this.tagTaskInstall = tt.createInt(this.makeTagName("TaskInstall"), 0);
        this.tagState = tt.createRWInt(this.makeTagName("State"), 0);
        tagArray[2] = this.tagState;
        this.tagStateMsg = tt.createRWString(this.makeTagName("StateMsg"), STATES.get(0));
        tagArray[3] = this.tagStateMsg;
        this.tagError = tt.createRWString(this.makeTagName("Error"), "");
        tagArray[4] = this.tagError;
        this.tagRecipeId = tt.createRWInt(this.makeTagName("RecipeId"), 0);
        tagArray[5] = this.tagRecipeId;
        this.tagRecipeName = tt.createRWString(this.makeTagName("RecipeName"), "");
        tagArray[6] = this.tagRecipeName;
        this.tagCycleId = tt.createRWInt(this.makeTagName("CycleId"), 0);
        tagArray[7] = this.tagCycleId;
        tagArray[8] = this.tagSetWeight = tt.createLong(this.makeTagName("SetWeight"), 0L);
        this.tagDstBunkerNum = tt.createRWInt(this.makeTagName("DstBunkerNum"), -1);
        tagArray[9] = this.tagDstBunkerNum;
        this.tagDstBunkerName = tt.createRWString(this.makeTagName("DstBunkerName"), "");
        tagArray[10] = this.tagDstBunkerName;
        this.tagDstProductId = tt.createRWInt(this.makeTagName("DstProductId"), 0);
        tagArray[11] = this.tagDstProductId;
        tagArray[12] = this.tagStart = tt.createBool(this.makeTagName("Start"), false);
        this.ctx.addRepoTags(tagArray);
        this.tagName = tt.createRWString(this.makeTagName("Name"), this.name);
        this.tagDescr = tt.createRWString(this.makeTagName("Descr"), descr);
        this.tagCancel = tt.createBool(this.makeTagName("Cancel"), false);
        this.tagRestart = tt.createBool(this.makeTagName("Restart"), false);
        this.tagReset = tt.createBool(this.makeTagName("Reset"), false);
        this.tagRcpWeight = tt.createRWLong(this.makeTagName("RcpWeight"), 0L);
        this.tagExeWeight = tt.createRWLong(this.makeTagName("ExeWeight"), 0L);
        this.tagExeWeightTot = tt.createRWLong(this.makeTagName("ExeWeightTot"), 0L);
        this.tagEnableLoad = tt.createBool(this.makeTagName("EnableLoad"), true);
        this.tagEnableUnload = tt.createBool(this.makeTagName("EnableUnload"), true);
        this.tagDisable = tt.createBool(this.makeTagName("Disable"), false);
        return res;
    }

    @Override
    public String makeTagName(String tagname) {
        return this.name + '_' + tagname;
    }

    protected boolean validatePresented(String paramName, String paramValue) {
        if (!paramValue.isEmpty()) {
            return true;
        }
        this.ctx.env.printError(this.logger, this.ctx.moduleName, this.name, PARAMETER_IS_NOT_PRESENTED + paramName);
        return false;
    }

    @Override
    public boolean prepare() {
        this.dosers.forEach(Doser::prepare);
        if (!this.dupLineName.isEmpty()) {
            Line dupLine = this.ctx.getLine(this.dupLineName);
            if (dupLine == null) {
                this.ctx.env.printError(this.logger, this.ctx.moduleName, this.name, "Duplicate line is not found");
                return false;
            }
            boolean res = this.dosers.size() == dupLine.getDosers().size();
            for (int i = 0; res && i < this.dosers.size(); ++i) {
                Doser doser = this.dosers.get(i);
                Doser dupDoser = dupLine.getDosers().get(i);
                doser.setDupName(dupDoser.getName());
                res = doser.feeders.size() == dupDoser.feeders.size();
            }
            if (!res) {
                this.ctx.env.printError(this.logger, this.ctx.moduleName, this.name, "Duplicate line must have the same number of dosers and feeders");
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean init() throws SQLException {
        DataService svc = this.ctx.service;
        this.id = svc.syncLine(this.tagName.getString(), this.tagDescr.getString(), this.hidden);
        for (Doser doser : this.dosers) {
            doser.init();
        }
        svc.syncLineDosers(this.id, this.dosers.stream().map(Doser::getId).collect(Collectors.toList()));
        for (Param param : this.params) {
            param.init();
        }
        svc.syncLineParams(this.id, this.params.stream().map(Param::getId).collect(Collectors.toList()));
        for (Line.DstBunker bunker : this.dstBunkers) {
            bunker.id = svc.syncBunker(bunker.name);
        }
        return true;
    }

    @Override
    public void execute() throws SQLException {
        this.updateDstBunker();
        this.executeDosers();
        this.updateTags();
        this.updateButtons();
        this.updateTaskInstall();
        int state = this.tagState.getInt();
        if (state == 0 && this.hasTask()) {
            state = 1;
        }
        if (state == 1) {
            if (this.hasTask()) {
                this.updateSetWeight();
                if (this.tagStart.getBool() && this.tagSetWeight.getLong() > 0L) {
                    this.generateCycleId();
                    this.beginCycle();
                    state = 2;
                }
            } else {
                state = 0;
            }
        }
        if (state == 2) {
            LineSimple.prepareTaskSend(this.dosers);
            if (LineSimple.isTaskSendReady(this.dosers)) {
                LineSimple.sendTask(this.dosers);
                state = 3;
            }
        }
        if (state == 3) {
            if (LineSimple.isTaskAccepted(this.dosers)) {
                state = 4;
            } else if (LineSimple.isTaskRejected(this.dosers)) {
                state = 99;
                this.setError(ERROR_DOSER_REJECTED_TASK);
            }
        }
        if (state == 4 && this.canLoad()) {
            state = 5;
        }
        if (state == 5) {
            if (LineSimple.isUnloadReady(this.dosers)) {
                state = 6;
            } else {
                LineSimple.startLoad(this.dosers);
            }
        }
        if (state == 6) {
            if (LineSimple.isUnloaded(this.dosers)) {
                LineSimple.incrementPassCnt(this.dosers);
                state = LineSimple.needMorePasses(this.dosers) ? 2 : 100;
            } else if (this.canUnload()) {
                LineSimple.startUnload(this.dosers);
            }
        } else if (state == 100) {
            state = 1;
            this.resetExeWeight();
            if (!this.autostart) {
                this.tagStart.setOff();
            }
        }
        this.setState(state);
    }

    protected void updateDstBunker() {
        if (this.dstBunkers.size() == 0) {
            if (this.tagDstBunkerNum.getInt() != -1) {
                this.tagDstBunkerNum.setReadValInt(-1);
                this.tagDstBunkerName.setReadValString("");
            }
        } else {
            int num = this.tagDstBunkerNum.hasWriteValue() ? this.tagDstBunkerNum.getWriteValInt() : this.tagDstBunkerNum.getInt();
            if (num < 0 || num >= this.dstBunkers.size()) {
                num = 0;
            }
            if (num != this.tagDstBunkerNum.getInt()) {
                this.tagDstBunkerNum.setReadValInt(num);
                this.tagDstBunkerName.setReadValString(this.dstBunkers.get((int)num).name);
            }
        }
    }

    @Override
    public int getDstBunkerId() {
        int num = this.tagDstBunkerNum.getInt();
        return num < 0 || num >= this.dstBunkers.size() ? 0 : this.dstBunkers.get((int)num).id;
    }

    protected void updateButtons() {
        if (this.tagReset.getBool()) {
            this.tagReset.setOff();
            this.reset();
            this.setState(0);
        }
        if (this.tagCancel.getBool() && this.canCancel()) {
            this.tagCancel.setOff();
            this.reset();
            this.setState(0);
        }
        if (this.tagRestart.getBool()) {
            this.tagRestart.setOff();
            if (this.canRestart()) {
                this.setState(1);
                this.tagStart.setOff();
            }
        }
    }

    private boolean canRestart() {
        return !this.isStateError() && this.hasTask();
    }

    protected boolean canCancel() {
        return this.tagState.getInt() < 5;
    }

    protected boolean canInstall() {
        return this.tagState.getInt() <= 1;
    }

    protected boolean isStateError() {
        return this.tagState.getInt() == 99;
    }

    protected boolean hasTask() {
        return this.tagTaskId.getInt() > 0;
    }

    protected void reset() {
        this.tagError.setReadValString("");
        this.tagTaskId.setReadValInt(0);
        this.tagCycleId.setReadValInt(0);
        this.tagRecipeId.setReadValInt(0);
        this.tagRecipeName.setReadValString("");
        this.tagRcpWeight.setReadValLong(0L);
        this.tagSetWeight.setLong(0L);
        this.tagExeWeight.setReadValLong(0L);
        this.tagExeWeightTot.setReadValLong(0L);
        this.dosers.forEach(Doser::reset);
        this.params.forEach(Param::reset);
    }

    protected static void updateSumTags(List<Doser> dosers, TagRW tagRcpWeight, TagRW tagExeWeight) {
        long rcp = 0L;
        long exe = 0L;
        for (Doser doser : dosers) {
            rcp += doser.tagRcpWeight.getLong();
            exe += doser.tagExeWeight.getLong();
        }
        tagRcpWeight.setReadValLong(rcp);
        tagExeWeight.setReadValLong(exe);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void updateTags() throws SQLException {
        LineSimple.updateSumTags(this.dosers, this.tagRcpWeight, this.tagExeWeight);
        if (!this.isStateError() && this.hasTask()) {
            Task task = this.ctx.taskrepo.get(this.tagTaskId);
            if (task.presented) {
                this.tagExeWeightTot.setReadValLong(task.totalExeWeight);
                return;
            }
        }
        this.tagExeWeightTot.setReadValLong(0L);
    }

    protected static void updateSetWeight(List<Doser> dosers, long newSetWeight) {
        long oldSetWeight;
        if (newSetWeight < 0L) {
            newSetWeight = 0L;
        }
        if (newSetWeight != (oldSetWeight = dosers.stream().mapToLong(Doser::getSetWeight).sum())) {
            long rcpweight = dosers.stream().mapToLong(Doser::getRcpWeight).sum();
            if (rcpweight <= 0L) {
                dosers.forEach(doser -> doser.setSetWeight(0L));
                return;
            }
            double ratio = (double)newSetWeight / (double)rcpweight;
            long sum = 0L;
            for (Doser doser2 : dosers) {
                long w = (rcpweight -= doser2.tagRcpWeight.getLong()) == 0L ? newSetWeight - sum : Math.round(doser2.tagRcpWeight.getDouble() * ratio);
                doser2.setSetWeight(w);
                sum += w;
            }
        }
    }

    private void updateSetWeight() {
        LineSimple.updateSetWeight(this.dosers, this.tagSetWeight.getLong());
    }

    protected void setState(int state) {
        if (this.tagState.getInt() == state) {
            return;
        }
        this.tagState.setReadValInt(state);
        this.tagStateMsg.setReadValString(STATES.getOrDefault(state, state + "?"));
    }

    protected void setError(String errmes) {
        this.tagError.setReadValString(errmes);
    }

    protected void generateCycleId() throws SQLException {
        this.tagCycleId.setReadValInt(this.ctx.service.generateCycleId());
    }

    protected boolean canLoad() {
        return this.tagEnableLoad.getBool() && !this.tagDisable.getBool();
    }

    protected boolean canUnload() {
        return this.tagEnableUnload.getBool() && !this.tagDisable.getBool();
    }

    protected void updateTaskInstall() throws SQLException {
        if (this.tagTaskInstall.getInt() > 0 && this.canInstall()) {
            if (this.installTask(this.tagTaskInstall.getInt())) {
                this.tagTaskId.setReadValInt(this.tagTaskInstall.getInt());
            } else {
                this.tagTaskId.setReadValInt(0);
                if (this.canCancel()) {
                    this.setState(0);
                }
            }
            this.tagTaskInstall.setInt(0);
        }
    }

    protected boolean installTask(int taskId) throws SQLException {
        this.reset();
        Task task = this.ctx.taskrepo.get(taskId);
        if (!task.presented) {
            this.setError(ERROR_TASK_NOT_FOUND);
            return false;
        }
        if (!task.lineName.equals(this.name) && !task.lineName.equals(this.dupLineName)) {
            this.setError(ERROR_TASK_HAS_WRONG_LINE);
            return false;
        }
        if (task.status != 1) {
            this.setError(ERROR_TASK_HAS_WRONG_STATUS);
            return false;
        }
        this.dosers.forEach(doser -> doser.installTask(task));
        int numberOfFeedersUsed = this.dosers.stream().mapToInt(Doser::getNumberOfFeedersUsed).sum();
        if (numberOfFeedersUsed < task.products.size()) {
            this.setError(ERROR_TASK_HAS_WRONG_BUNKER);
            return false;
        }
        this.tagRecipeId.setReadValInt(task.recipeId);
        this.tagRecipeName.setReadValString(task.recipeName);
        this.tagDstProductId.setReadValInt(task.productId);
        this.updateTags();
        this.tagSetWeight.setLong(this.tagRcpWeight.getLong());
        for (Task.Param tprm : task.params) {
            Param param = this.findParam(tprm.paramName);
            if (param == null) {
                this.setError(ERROR_TASK_HAS_WRONG_PARAM);
                return false;
            }
            param.setValue(tprm.val);
        }
        this.tagStart.setOff();
        return true;
    }

    private Param findParam(String paramName) {
        return this.params.stream().filter(param -> param.getName().equals(paramName)).findAny().orElse(null);
    }

    private void executeDosers() throws SQLException {
        for (Doser doser : this.dosers) {
            doser.execute();
        }
    }

    protected void beginCycle() {
        this.dosers.forEach(Doser::beginCycle);
    }

    protected void resetExeWeight() {
        this.tagExeWeight.setReadValInt(0);
        this.dosers.forEach(Doser::resetExeWeight);
    }

    protected static Stream<Doser> dosersInUse(List<Doser> dosers) {
        return dosers.stream().filter(Doser::isInUse);
    }

    protected static void prepareTaskSend(List<Doser> dosers) {
        LineSimple.dosersInUse(dosers).forEach(Doser::prepareTaskSend);
    }

    protected static boolean isTaskSendReady(List<Doser> dosers) {
        return LineSimple.dosersInUse(dosers).allMatch(Doser::isTaskSendReady);
    }

    protected static void sendTask(List<Doser> dosers) {
        LineSimple.dosersInUse(dosers).forEach(Doser::sendTask);
    }

    protected static boolean isTaskAccepted(List<Doser> dosers) {
        return LineSimple.dosersInUse(dosers).allMatch(Doser::isTaskAccepted);
    }

    protected static boolean isTaskRejected(List<Doser> dosers) {
        return LineSimple.dosersInUse(dosers).anyMatch(Doser::isTaskRejected);
    }

    protected static void startLoad(List<Doser> dosers) {
        LineSimple.dosersInUse(dosers).forEach(Doser::startLoad);
    }

    protected static boolean isUnloadReady(List<Doser> dosers) {
        return LineSimple.dosersInUse(dosers).allMatch(Doser::isUnloadReady);
    }

    protected static void startUnload(List<Doser> dosers) {
        LineSimple.dosersInUse(dosers).forEach(Doser::startUnload);
    }

    protected static boolean isUnloaded(List<Doser> dosers) {
        return LineSimple.dosersInUse(dosers).allMatch(Doser::isUnloaded);
    }

    protected static void incrementPassCnt(List<Doser> dosers) {
        LineSimple.dosersInUse(dosers).forEach(Doser::incrementPassCnt);
    }

    protected static boolean needMorePasses(List<Doser> dosers) {
        return LineSimple.dosersInUse(dosers).findAny().isPresent();
    }

    @Override
    public String check() {
        String res1 = this.dosers.stream().map(Doser::check).collect(Collectors.joining());
        return res1;
    }

    @Override
    public String getInfo() {
        return String.format("\r\n\r    %s, %s, id:%d, d:%d, f:%d %s%s", this.getLineType(), this.name + (this.dupLineName.isEmpty() ? "" : "/" + this.dupLineName), this.id, this.dosers.size(), this.dosers.stream().mapToInt(d -> d.feeders.size()).sum(), this.hidden ? ", hidden" : "", this.autostart ? ", autostart" : "");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getTaskId() {
        return this.tagTaskId.getInt();
    }

    @Override
    public int getRecipeId() {
        return this.tagRecipeId.getInt();
    }

    @Override
    public int getCycleId() {
        return this.tagCycleId.getInt();
    }

    @Override
    public List<Doser> getDosers() {
        return this.dosers;
    }

    protected String getLineType() {
        return "simple";
    }

    @Override
    public int getDstProductId() {
        return this.tagDstProductId.getInt();
    }

    static {
        STATES.put(0, "\u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
        STATES.put(1, "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f \u0446\u0438\u043a\u043b\u0430 \u0434\u043e\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        STATES.put(2, "\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u043a \u0441\u0442\u0430\u0440\u0442\u0443 \u0446\u0438\u043a\u043b\u0430");
        STATES.put(4, "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0432\u043d\u0435\u0448\u043d\u0435\u0433\u043e \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438");
        STATES.put(3, "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u0430\u043c");
        STATES.put(5, "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432");
        STATES.put(6, "\u0420\u0430\u0437\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432");
        STATES.put(99, "\u041e\u0448\u0438\u0431\u043a\u0430");
        STATES.put(100, "\u0426\u0438\u043a\u043b \u0434\u043e\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d");
    }
}

