/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceFRQA
extends Device {
    Input inpInput;
    Input inpEnable;
    Tag tagFreq;
    Tag tagLow;
    Tag tagNormal;
    Tag tagHigh;
    Tag tagPeriod;
    Tag tagMul;
    Tag tagDiv;
    Tag tagFreqLow;
    Tag tagFreqHigh;
    boolean lastInputValue;
    Deque<Long> values = new LinkedList<Long>();

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpInput = this.getInput("Input", res);
        this.inpEnable = this.getInput("Enable", res);
        this.tagFreq = this.getOutputTag("Freq", res);
        this.tagLow = this.getOutputTag("Low", res);
        this.tagNormal = this.getOutputTag("Normal", res);
        this.tagHigh = this.getOutputTag("High", res);
        this.tagPeriod = this.getOutputTag("Period", res);
        this.tagMul = this.getOutputTag("Mul", res);
        this.tagDiv = this.getOutputTag("Div", res);
        this.tagFreqLow = this.getOutputTag("FreqLow", res);
        this.tagFreqHigh = this.getOutputTag("FreqHigh", res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagFreq.setInt(0);
        this.lastInputValue = false;
    }

    @Override
    public boolean execute() {
        if (this.inpEnable.getInt() == 0) {
            this.tagFreq.setInt(0);
            this.tagLow.setInt(0);
            this.tagHigh.setInt(0);
            this.tagNormal.setInt(0);
            return true;
        }
        long timeend = this.getCurrentTime();
        long timebeg = timeend - (long)this.tagPeriod.getInt();
        int sizeold = this.values.size();
        while (this.values.size() > 0 && this.values.getFirst() <= timebeg) {
            this.values.removeFirst();
        }
        while (this.values.size() > 0 && this.values.getLast() >= timeend) {
            this.values.removeLast();
        }
        boolean inputValue = this.inpInput.tag.getBool();
        if (inputValue && !this.lastInputValue) {
            this.values.add(timeend);
        }
        this.lastInputValue = inputValue;
        int freq = this.tagFreq.getInt();
        if (this.values.size() == 0) {
            freq = 0;
        } else if (this.values.size() != sizeold) {
            freq = this.values.size();
            if (this.tagMul.getInt() > 0) {
                freq *= this.tagMul.getInt();
            }
            if (this.tagDiv.getInt() > 0) {
                freq = (int)Math.round((double)freq / this.tagDiv.getDouble());
            }
        }
        this.tagFreq.setInt(freq);
        boolean low = freq <= this.tagFreqLow.getInt();
        boolean high = freq >= this.tagFreqHigh.getInt();
        this.tagLow.setBool(low);
        this.tagHigh.setBool(high);
        this.tagNormal.setBool(!low && !high);
        return true;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("lastInputValue", this.lastInputValue);
        int size = this.values.size();
        state.saveVar("size", size);
        ArrayList<Long> a = new ArrayList<Long>(this.values);
        for (int i = 0; i < size; ++i) {
            state.saveVar("value" + i, (Long)a.get(i));
        }
    }

    @Override
    public void loadStateExtra(State state) {
        this.lastInputValue = state.loadVar("lastInputValue", this.lastInputValue);
        int size = state.loadVar("size", 0);
        this.values.clear();
        for (int i = 0; i < size; ++i) {
            long value = state.loadVar("value" + i, 0L);
            this.values.addLast(value);
        }
    }
}

