/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolAscii;

public class CentaUrzModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(CentaUrzModule.class);
    protected ProtocolAscii protocol = new ProtocolAscii(this);
    protected Tag tagSumWeight;
    protected TagRW tagOutput;
    protected TagRW tagSetOutput;
    protected TagRW tagStart;
    protected TagRW tagState;

    public CentaUrzModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagSumWeight = this.tagtable.createLong("SumWeight", 0L, 8);
        this.tagOutput = this.tagtable.createRWInt("Output", 0, 8);
        this.tagSetOutput = this.tagtable.createRWInt("SetOutput", 0, 8);
        this.tagStart = this.tagtable.createRWInt("Start", 0, 8);
        this.tagState = this.tagtable.createRWInt("State", 0, 8);
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        this.addChannelMapTag(chtags, this.tagOutput);
        this.addChannelMapTag(chtags, this.tagStart);
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagOutput.acceptWriteValue();
            this.tagSetOutput.acceptWriteValue();
            this.tagStart.acceptWriteValue();
            this.tagState.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            result = this.readLong(17, this.tagSumWeight) && this.writeAndReadInt(21, this.tagOutput) && this.writeAndReadInt(25, this.tagSetOutput) && this.writeAndReadInt(36, this.tagStart) && this.writeAndReadInt(37, this.tagState);
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    private boolean readLong(int addr, Tag tag) throws Exception {
        if (!this.protocol.requestCentaRead(addr)) {
            return false;
        }
        tag.setLong(this.protocol.getAnswerDWord(3));
        return true;
    }

    private boolean writeAndReadInt(int addr, TagRW tag) throws Exception {
        if (tag.hasWriteValue() && !this.protocol.requestCentaWrite(addr, tag.getWriteValLong())) {
            return false;
        }
        if (!this.protocol.requestCentaRead(addr)) {
            return false;
        }
        tag.setReadValInt((int)this.protocol.getAnswerDWord(3));
        return true;
    }
}

