/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolAA55;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class PaGeliosPassModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaGeliosPassModule.class);
    protected ProtocolAA55 protocol = new ProtocolAA55(this);
    protected Tag tagCrc;
    protected TagRW tagSumWeightHigh1;
    protected TagRW tagSumWeightLow1;
    protected TagRW tagSumNumHigh1;
    protected TagRW tagSumNumLow1;
    protected TagRW tagSumWeightHigh2;
    protected TagRW tagSumWeightLow2;
    protected TagRW tagSumNumHigh2;
    protected TagRW tagSumNumLow2;
    protected TagRW tagCurWeightHigh;
    protected TagRW tagCurWeightLow;
    protected TagRW tagLastWeightHigh;
    protected TagRW tagLastWeightLow;
    protected TagRW tagLastTimeHigh;
    protected TagRW tagLastTimeLow;
    protected Tag tagSumWeightKg1;
    protected Tag tagSumWeightKg2;
    protected Tag tagCurWeight;
    protected Tag tagCurWeightKg;
    protected Tag tagLastWeight;
    protected Tag tagLastWeightKg;
    protected Tag tagLastTime;
    protected Tag tagState;
    protected Tag tagErrorCode;
    protected TagRW tagSetCmd;
    protected Tag tagOutput;
    protected Tag tagOutputKg;
    protected TagRW tagWesSvrState;
    protected Tag tagSetCmdCtrl;
    private static final int cmdDisabled = 0;
    private static final int cmdExternal = 1;
    private static final int cmdStop = 2;
    private static final int cmdStart = 3;
    protected LinkedList<ExtraTag> extraTags = new LinkedList();
    protected Tag[] crcTags;
    protected List<EmuTag> emuTags = null;
    protected Tag tagReplacement;
    private TagRW tagFirmware;
    private final int[] buffin = new int[28];
    private final int[] buffout = new int[9];
    private boolean paired = false;
    private boolean emusync = false;
    private boolean packer;
    private boolean bitStateConv;
    protected boolean multireq = false;
    private long wesSvrStateTimer;
    private long outWeight;
    private long outTime;
    private boolean outFirstPass;
    private boolean skip20;

    public PaGeliosPassModule(Plugin plugin, String name) {
        super(plugin, name);
        this.useSN = true;
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.paired = cm.get(conf, "paired", false);
        this.multireq = cm.get(conf, "multireq", false);
        this.packer = cm.get(conf, "packer", true);
        this.bitStateConv = cm.get(conf, "bitStateConv", false);
        this.emusync = cm.get(conf, "emusync", false);
        this.skip20 = cm.get(conf, "skip20", false);
        this.tagCrc = this.tagtable.createInt("Crc", 0);
        this.tagSumWeightHigh1 = this.tagtable.createRWInt("SumWeightHigh1", 0, 8);
        this.tagSumWeightLow1 = this.tagtable.createRWInt("SumWeightLow1", 0, 8);
        this.tagSumNumHigh1 = this.tagtable.createRWInt("SumNumHigh1", 0, 8);
        this.tagSumNumLow1 = this.tagtable.createRWInt("SumNumLow1", 0, 8);
        this.tagSumWeightHigh2 = this.tagtable.createRWInt("SumWeightHigh2", 0, 8);
        this.tagSumWeightLow2 = this.tagtable.createRWInt("SumWeightLow2", 0, 8);
        this.tagSumNumHigh2 = this.tagtable.createRWInt("SumNumHigh2", 0, 8);
        this.tagSumNumLow2 = this.tagtable.createRWInt("SumNumLow2", 0, 8);
        this.tagCurWeightHigh = this.tagtable.createRWInt("CurWeightHigh", 0, 8);
        this.tagCurWeightLow = this.tagtable.createRWInt("CurWeightLow", 0, 8);
        this.tagLastWeightHigh = this.tagtable.createRWInt("LastWeightHigh", 0, 8);
        this.tagLastWeightLow = this.tagtable.createRWInt("LastWeightLow", 0, 8);
        this.tagLastTimeHigh = this.tagtable.createRWInt("LastTimeHigh", 0, 8);
        this.tagLastTimeLow = this.tagtable.createRWInt("LastTimeLow", 0, 8);
        this.tagSumWeightKg1 = this.tagtable.createInt("SumWeightKg1", 0, 8);
        this.tagSumWeightKg2 = this.tagtable.createInt("SumWeightKg2", 0, 8);
        this.tagCurWeight = this.tagtable.createInt("CurWeight", 0, 8);
        this.tagCurWeightKg = this.tagtable.createInt("CurWeightKg", 0, 8);
        this.tagLastWeight = this.tagtable.createInt("LastWeight", 0, 8);
        this.tagLastWeightKg = this.tagtable.createInt("LastWeightKg", 0, 8);
        this.tagLastTime = this.tagtable.createInt("LastTime", 0, 8);
        this.crcTags = new Tag[]{this.tagSumWeightHigh1, this.tagSumWeightLow1, this.tagSumNumHigh1, this.tagSumNumLow1, this.tagSumWeightHigh2, this.tagSumWeightLow2, this.tagSumNumHigh2, this.tagSumNumLow2, this.tagCurWeightHigh, this.tagCurWeightLow, this.tagLastWeightHigh, this.tagLastWeightLow, this.tagLastTimeHigh, this.tagLastTimeLow};
        this.initCrc16Tags();
        this.initEmuTags();
        this.tagState = this.tagtable.createInt("State", 0, 8);
        this.tagErrorCode = this.tagtable.createInt("ErrorCode", 0, 8);
        this.tagSetCmd = this.tagtable.createRWInt("SetCmd", 0);
        this.tagSetCmdCtrl = this.tagtable.createInt("SetCmdCtrl", 0, 1);
        this.tagOutput = this.tagtable.createInt("Output", 0, 8);
        this.tagOutputKg = this.tagtable.createInt("OutputKg", 0, 8);
        this.tagWesSvrState = this.tagtable.createRWInt("WesSvrState", 0);
        this.tagReplacement = this.tagtable.createBool("Replacement", false, 1);
        this.tagFirmware = this.tagtable.createRWString("firmware", "");
        Map<String, Object> confext = cm.toMap(cm.get(conf, "params"));
        for (String key : confext.keySet()) {
            this.addExtraTag(key, cm.get((Object)confext, key, 0));
        }
        return true;
    }

    @Override
    protected void initCrc16Tags() {
        super.initCrc16Tags();
        for (Tag tag : this.crcTags) {
            this.crc16Tags.add(tag);
        }
        this.crc16Tags.add(this.tagError);
    }

    private void initEmuTags() {
        if (this.emulated && this.emusync) {
            this.emuTags = new ArrayList<EmuTag>();
            for (Tag tag : this.crcTags) {
                this.emuTags.add(new EmuTag((TagRW)tag));
            }
        } else {
            this.emuTags = null;
        }
    }

    protected void addExtraTag(String name, int regaddr) {
        ExtraTag et = new ExtraTag();
        et.tag = this.tagtable.createRWInt(name, 0, 8);
        et.regAddr = regaddr;
        this.extraTags.add(et);
    }

    @Override
    public boolean preparePeripherialModule() {
        this.outWeight = 0L;
        this.outTime = 0L;
        this.outFirstPass = true;
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        if (!this.emulated) {
            try {
                this.buffout[0] = 85;
                if (this.tagSetCmdCtrl.getInt() == 0) {
                    if (this.tagSetCmd.hasWriteValue() || this.tagSetCmd.getInt() != 0) {
                        this.tagSetCmd.setReadValInt(0);
                    }
                } else {
                    int setcmd = -1;
                    switch (this.tagSetCmdCtrl.getInt()) {
                        case 1: {
                            if (!this.tagSetCmd.hasWriteValue()) break;
                            setcmd = this.tagSetCmd.getWriteValInt();
                            break;
                        }
                        case 3: {
                            if (this.tagState.getInt() != 0) break;
                            setcmd = 1;
                            break;
                        }
                        case 2: {
                            if (this.tagState.getInt() == 0) break;
                            setcmd = 2;
                        }
                    }
                    if (setcmd >= 0) {
                        this.tagSetCmd.setReadValInt(setcmd);
                        this.buffout[1] = this.netaddr;
                        this.buffout[2] = setcmd;
                        this.buffout[3] = CRC.getCrc8(this.buffout, 1, 2);
                        this.protocol.writeBytes(this.buffout, 4);
                        Thread.sleep(10L);
                    }
                }
                if (result) {
                    for (ExtraTag et : this.extraTags) {
                        int sizeout;
                        if (et.tag.hasWriteValue()) {
                            et.hasWrite = true;
                            et.writeCnt = 0;
                            et.writeVal = et.tag.getWriteValInt();
                        }
                        if (et.hasWrite) {
                            if (et.writeVal == et.tag.getInt()) {
                                et.hasWrite = false;
                            } else {
                                this.buffout[1] = 128 + this.netaddr;
                                if (this.packer) {
                                    this.buffout[2] = et.regAddr >> 8 & 0xFF;
                                    this.buffout[3] = et.regAddr & 0xFF;
                                    this.buffout[4] = et.writeVal >> 24 & 0xFF;
                                    this.buffout[5] = et.writeVal >> 16 & 0xFF;
                                    this.buffout[6] = et.writeVal >> 8 & 0xFF;
                                    this.buffout[7] = et.writeVal & 0xFF;
                                    this.buffout[8] = CRC.getCrc8(this.buffout, 1, 7);
                                    this.protocol.writeBytes(this.buffout, 9);
                                } else {
                                    this.buffout[2] = et.regAddr & 0xFF;
                                    this.buffout[3] = et.writeVal >> 24 & 0xFF;
                                    this.buffout[4] = et.writeVal >> 16 & 0xFF;
                                    this.buffout[5] = et.writeVal >> 8 & 0xFF;
                                    this.buffout[6] = et.writeVal & 0xFF;
                                    this.buffout[7] = CRC.getCrc8(this.buffout, 1, 6);
                                    this.protocol.writeBytes(this.buffout, 8);
                                }
                                Thread.sleep(10L);
                                short s = et.writeCnt;
                                et.writeCnt = (short)(s + 1);
                                if (s >= 10) {
                                    et.hasWrite = false;
                                }
                            }
                        }
                        this.buffout[1] = 96 + this.netaddr;
                        if (this.packer) {
                            this.buffout[2] = et.regAddr >> 8 & 0xFF;
                            this.buffout[3] = et.regAddr & 0xFF;
                            this.buffout[4] = CRC.getCrc8(this.buffout, 1, 3);
                            sizeout = 5;
                        } else {
                            this.buffout[2] = et.regAddr & 0xFF;
                            this.buffout[3] = CRC.getCrc8(this.buffout, 1, 2);
                            sizeout = 4;
                        }
                        if (!(result = !this.multireq ? this.protocol.request(this.buffout, sizeout, this.buffin, 5, 1) : this.protocol.multiRequest(this.buffout, sizeout, this.buffin, 5, 5, 1))) continue;
                        et.tag.setReadValInt(Numbers.bytesToInt(this.buffin, 0));
                    }
                }
                if (result && !this.skip20) {
                    this.buffout[1] = 32 + this.netaddr;
                    this.buffout[2] = CRC.getCrc8(this.buffout, 1, 1);
                    result = !this.multireq ? this.protocol.request(this.buffout, 3, this.buffin, 23, 1) : this.protocol.multiRequest(this.buffout, 3, this.buffin, 23, 8, 1);
                }
                if (result) {
                    this.tagSumNumHigh1.setReadValInt(Numbers.bytesToWord(this.buffin, 0));
                    this.tagSumNumLow1.setReadValInt(Numbers.bytesToWord(this.buffin, 2));
                    this.tagSumWeightHigh1.setReadValInt(Numbers.bytesToWord(this.buffin, 4));
                    this.tagSumWeightLow1.setReadValInt(Numbers.bytesToWord(this.buffin, 6));
                    this.tagCurWeightHigh.setReadValInt(Numbers.bytesToWord(this.buffin, 8));
                    this.tagCurWeightLow.setReadValInt(Numbers.bytesToWord(this.buffin, 10));
                    if (this.paired) {
                        this.tagSumNumHigh2.setReadValInt(Numbers.bytesToWord(this.buffin, 12));
                        this.tagSumNumLow2.setReadValInt(Numbers.bytesToWord(this.buffin, 14));
                        this.tagSumWeightHigh2.setReadValInt(Numbers.bytesToWord(this.buffin, 16));
                        this.tagSumWeightLow2.setReadValInt(Numbers.bytesToWord(this.buffin, 18));
                    } else {
                        this.tagLastWeightHigh.setReadValInt(Numbers.bytesToWord(this.buffin, 12));
                        this.tagLastWeightLow.setReadValInt(Numbers.bytesToWord(this.buffin, 14));
                        this.tagLastTimeHigh.setReadValInt(Numbers.bytesToWord(this.buffin, 16));
                        this.tagLastTimeLow.setReadValInt(Numbers.bytesToWord(this.buffin, 18));
                        this.calcWeightOutput();
                    }
                    int st = this.buffin[20];
                    if (this.bitStateConv) {
                        st = (st & 0x40) > 0 ? 2 : ((st & 0x2E) > 0 ? 1 : 0);
                    }
                    this.tagState.setInt(st);
                    this.tagErrorCode.setInt(this.buffin[21]);
                    this.calcTagCrc8(this.crcTags, this.tagCrc, this.buffin);
                    result = true;
                }
                if (result && (this.firstPass || this.tagError.getBool())) {
                    result = this.protocol.requestFirmware(this.tagFirmware);
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
            }
        } else {
            if (this.emusync && this.emuTags != null) {
                boolean fl = true;
                for (EmuTag emutag : this.emuTags) {
                    if (emutag.tag.hasWriteValue()) {
                        emutag.hasWrite = true;
                        emutag.writeVal = emutag.tag.getWriteValInt();
                        continue;
                    }
                    if (emutag.hasWrite) continue;
                    fl = false;
                    break;
                }
                if (fl) {
                    for (EmuTag emutag : this.emuTags) {
                        emutag.hasWrite = false;
                        emutag.tag.setReadValInt(emutag.writeVal);
                    }
                }
            } else {
                for (Tag tag : this.crcTags) {
                    ((TagRW)tag).acceptWriteValue();
                }
            }
            this.tagSetCmd.acceptWriteValue();
            for (ExtraTag et : this.extraTags) {
                et.tag.acceptWriteValue();
            }
            this.calcWeightOutput();
            this.calcTagCrc8(this.crcTags, this.tagCrc, this.buffin);
        }
        this.tagCurWeight.setLong((this.tagCurWeightHigh.getLong() << 16) + this.tagCurWeightLow.getLong());
        this.tagCurWeightKg.setInt(this.tagCurWeight.getInt() / 1000);
        this.tagLastWeight.setLong((this.tagLastWeightHigh.getLong() << 16) + this.tagLastWeightLow.getLong());
        this.tagLastWeightKg.setInt(this.tagLastWeight.getInt() / 1000);
        this.tagSumWeightKg1.setLong(((this.tagSumWeightHigh1.getLong() << 16) + (long)this.tagSumWeightLow1.getInt()) / 1000L);
        this.tagSumWeightKg2.setLong(((this.tagSumWeightHigh2.getLong() << 16) + (long)this.tagSumWeightLow2.getInt()) / 1000L);
        this.tagLastTime.setLong((this.tagLastTimeHigh.getLong() << 16) + (long)this.tagLastTimeLow.getInt());
        this.wesSvrStateTimer = PaGeliosPassModule.updateWesSvrState(this.tagWesSvrState, this.wesSvrStateTimer);
        return result;
    }

    private void calcWeightOutput() {
        int result = 0;
        long W = Numbers.wordsToLong(this.tagSumWeightHigh1.getInt(), this.tagSumWeightLow1.getInt());
        long L = Numbers.wordsToLong(this.tagLastWeightHigh.getInt(), this.tagLastWeightLow.getInt());
        long T = Numbers.wordsToLong(this.tagLastTimeHigh.getInt(), this.tagLastTimeLow.getInt());
        long ms = System.currentTimeMillis();
        if (this.outFirstPass) {
            this.outFirstPass = false;
            this.outWeight = W;
            this.outTime = ms - T * 3L;
        } else if (T == 0L || L == 0L) {
            this.outWeight = W;
            this.outTime = ms;
        } else {
            long tm = ms - this.outTime;
            if (this.outWeight != W || tm < T * 3L) {
                double d = (double)L / (double)T * 3600.0 * 1000.0;
                result = (int)Math.round(d);
                if (this.outWeight != W) {
                    this.outWeight = W;
                    this.outTime = ms;
                }
            } else if (tm > T * 3L) {
                this.outTime = ms - T * 3L;
            }
        }
        this.tagOutput.setInt(result);
        this.tagOutputKg.setInt(result / 1000);
    }

    @Override
    protected boolean reload() {
        PaGeliosPassModule tmp = new PaGeliosPassModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.multireq = tmp.multireq;
        this.paired = tmp.paired;
        this.packer = tmp.packer;
        this.bitStateConv = tmp.bitStateConv;
        this.emusync = tmp.emusync;
        this.initEmuTags();
        return true;
    }

    protected static class EmuTag {
        TagRW tag;
        boolean hasWrite = false;
        int writeVal;

        public EmuTag(TagRW tag) {
            this.tag = tag;
        }
    }

    protected static class ExtraTag {
        TagRW tag;
        int regAddr;
        boolean hasWrite = false;
        short writeCnt = 0;
        int writeVal;

        protected ExtraTag() {
        }
    }
}

