/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.LinkedList;
import java.util.List;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceMCHB
extends Device {
    private static final int FL_IGNORE_SUSPEND_ON_START = 512;
    private static final int FL_ALARM_ON_SUSPEND = 256;
    private static final int FL_MASTEROUT_BY_PLATA = 4;
    private static final int FL_INSTANT_STOP_DISABLED = 16;
    private static final int FL_PLATA_CTRL_LEVEL = 128;
    private static final int FL_EXTINPUT_DISABLED = 8;
    private static final int FL_MODE = 3;
    List<Input> inpTrigres = new LinkedList<Input>();
    List<Input> inpSuspend = new LinkedList<Input>();
    List<List<Input>> inpInput = new LinkedList<List<Input>>();
    Input inputZ;
    Tag tagMasterOut;
    Tag tagSost;
    Tag tagAlarm;
    Tag tagPlata;
    Tag tagCnt;
    Tag tagTrigRes;
    Tag tagControl;
    Tag tagBlok;
    Tag tagTimeStart;
    Tag tagTimeStop;
    Channel channelOut;
    Channel channelIn;
    Tag tagFlags;
    Tag tagInput;
    Tag tagInputExt;
    Tag tagCtrlBeep;
    int oldControl;
    int cntManAlarm;
    int sost;
    int cnt;
    int ctrlDlyCnt;
    int ctrlValue;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.createTagDescr();
        this.tagMasterOut = this.getOutputTag("MasterOut", res);
        this.tagSost = this.getOutputTag("Sost", res);
        this.tagAlarm = this.getOutputTag("Alarm", res);
        this.tagPlata = this.getOutputTag("Plata", res);
        this.tagCnt = this.getOutputTag("Cnt", res);
        this.tagTrigRes = this.getOutputTag("TrigRes", res);
        this.tagControl = this.getOutputTag("Control", res);
        this.tagBlok = this.getOutputTag("Blok", res);
        this.tagTimeStart = this.getOutputTag("TimeStart", res);
        this.tagTimeStop = this.getOutputTag("TimeStop", res);
        this.channelOut = this.createChannel("Channel1", Channel.Type.Out, res);
        this.channelIn = this.createChannel("Channel2", Channel.Type.In, res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.tagInput = this.getOutputTag("Input", res);
        this.tagInputExt = this.getOutputTag("InputExt", res);
        this.tagCtrlBeep = this.getOutputTagOrFake("CtrlBeep");
        this.prepareInputArrays();
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagMasterOut.setInt(0);
        this.tagSost.setInt(0);
        this.tagAlarm.setInt(0);
        this.tagPlata.setInt(0);
        this.tagCnt.setInt(0);
        this.tagTrigRes.setInt(0);
        this.tagInput.setInt(0);
        this.tagInputExt.setInt(0);
        this.sost = 0;
        this.cnt = 0;
        this.oldControl = 0;
    }

    protected void prepareInputArrays() {
        this.inpTrigres.clear();
        this.inpSuspend.clear();
        this.inpInput.clear();
        this.inputZ = null;
        String curInpName = "";
        LinkedList<Input> curList = null;
        block10: for (Input inp : this.inputs) {
            switch (inp.name) {
                case "TrigRes": {
                    this.inpTrigres.add(inp);
                    continue block10;
                }
                case "Suspend": {
                    this.inpSuspend.add(inp);
                    continue block10;
                }
                case "InputZ": {
                    this.inputZ = inp;
                    continue block10;
                }
            }
            if (!inp.name.startsWith("Input")) continue;
            if (!inp.name.equals(curInpName)) {
                curList = null;
                curInpName = inp.name;
            }
            if (curList == null) {
                curList = new LinkedList<Input>();
                this.inpInput.add(curList);
            }
            curList.add(inp);
        }
    }

    public boolean getValueAnd(List<Input> list) {
        for (Input inp : list) {
            if (inp.getInt() != 0) continue;
            return false;
        }
        return list.size() > 0;
    }

    public boolean getValueOr(List<Input> list) {
        for (Input inp : list) {
            if (inp.getInt() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean execute() {
        boolean masterOut;
        boolean mstin;
        boolean pTrig = false;
        boolean pSusp = false;
        boolean pSuspInput = false;
        boolean pInput = false;
        int sostNew = 0;
        boolean hand_stop = false;
        boolean plataIn = false;
        boolean plataOut = false;
        int flags = this.tagFlags.getInt();
        int control = this.tagControl.getInt();
        int ctrlDlyTime = control >> 8 & 0xFF;
        if (ctrlDlyTime == 0) {
            this.ctrlDlyCnt = 0;
            this.ctrlValue = control;
        } else if (this.ctrlDlyCnt == ctrlDlyTime) {
            this.ctrlDlyCnt = 0;
            ctrlDlyTime = 0;
            this.tagControl.setInt(control &= 0xFF);
        } else {
            ++this.ctrlDlyCnt;
            control = this.ctrlValue;
        }
        this.tagCtrlBeep.setBool(ctrlDlyTime > 0);
        int flags_mode = flags & 3;
        this.tagAlarm.setBool(this.sost == 4);
        if (!this.linkChannels(flags_mode)) {
            return true;
        }
        pTrig = this.getValueOr(this.inpTrigres);
        if ((control & 4) > 0) {
            pTrig = true;
            this.tagControl.setInt(control &= 0xFFFB);
        }
        if (control != this.oldControl) {
            if ((control & 3) == 3 && ((control ^ this.oldControl) & 3) > 0) {
                pTrig = true;
            }
            this.oldControl = control;
        }
        pSusp = (pSuspInput = this.getValueOr(this.inpSuspend)) && (this.sost == 0 || this.sost == 2) && (flags & 0x200) > 0 ? false : pSuspInput;
        boolean inputOutExt = (control & 0x10) > 0;
        for (List<Input> list : this.inpInput) {
            if (!this.getValueAnd(list)) continue;
            pInput = true;
            break;
        }
        if (inputOutExt && (flags & 8) == 0) {
            pInput = true;
        }
        if ((control & 3) > 0) {
            mstin = (control & 2) > 0;
            hand_stop = !mstin;
        } else {
            mstin = pInput;
        }
        boolean mstin_nosusp = mstin;
        if (pSusp) {
            mstin = false;
        } else if (this.sost == 5) {
            this.sost = 0;
        }
        plataIn = this.inputZ != null ? this.inputZ.getInt() > 0 : (flags_mode == 3 ? mstin : ((flags & 0x80) > 0 ? this.channelIn.tagValue.getInt() > 0 : this.channelIn.tagValue.getInt() == 0));
        boolean pin = this.tagBlok.getInt() > 0 ? mstin : plataIn;
        switch (this.sost) {
            case 0: {
                if (mstin) {
                    sostNew = 2;
                    plataOut = true;
                    this.cnt = 1;
                    break;
                }
                if (pin) {
                    sostNew = 7;
                    plataOut = false;
                    break;
                }
                sostNew = 0;
                plataOut = false;
                break;
            }
            case 1: {
                if (mstin) {
                    if (pin) {
                        sostNew = 1;
                        plataOut = true;
                        this.cnt = 0;
                        break;
                    }
                    if ((flags & 0x10) == 0 || this.cnt >= this.tagTimeStart.getInt()) {
                        sostNew = 4;
                        plataOut = false;
                        this.cnt = 0;
                        break;
                    }
                    sostNew = 1;
                    plataOut = true;
                    ++this.cnt;
                    break;
                }
                sostNew = 3;
                plataOut = this.tagTimeStop.getInt() > 0;
                this.cnt = 1;
                break;
            }
            case 2: {
                if (mstin) {
                    if (pin) {
                        if (this.cnt >= this.tagTimeStart.getInt() || (flags & 4) > 0) {
                            sostNew = 1;
                            plataOut = true;
                            this.cnt = 0;
                            break;
                        }
                        sostNew = 2;
                        plataOut = true;
                        ++this.cnt;
                        break;
                    }
                    if (this.cnt >= this.tagTimeStart.getInt()) {
                        sostNew = 4;
                        plataOut = false;
                        this.cnt = 0;
                        break;
                    }
                    sostNew = 2;
                    plataOut = true;
                    ++this.cnt;
                    break;
                }
                sostNew = 0;
                plataOut = false;
                this.cnt = 0;
                break;
            }
            case 3: {
                if (mstin) {
                    sostNew = 2;
                    plataOut = true;
                    this.cnt = 1;
                    break;
                }
                if (this.cnt >= this.tagTimeStop.getInt() || hand_stop) {
                    if (pin) {
                        sostNew = 7;
                        plataOut = false;
                        this.cnt = 0;
                        break;
                    }
                    sostNew = 0;
                    plataOut = false;
                    this.cnt = 0;
                    break;
                }
                sostNew = 3;
                plataOut = true;
                ++this.cnt;
                break;
            }
            case 4: {
                if (pTrig) {
                    sostNew = 0;
                    plataOut = false;
                    break;
                }
                sostNew = 4;
                plataOut = false;
                break;
            }
            case 5: {
                plataOut = false;
                this.cnt = 0;
                break;
            }
            case 7: {
                if (mstin) {
                    sostNew = 2;
                    plataOut = true;
                    this.cnt = 1;
                    break;
                }
                if (pin) {
                    sostNew = 7;
                    plataOut = false;
                    this.cnt = 0;
                    break;
                }
                sostNew = 0;
                plataOut = false;
            }
        }
        if (pSuspInput && sostNew == 1 || pSusp && this.sost != 4 && mstin_nosusp) {
            sostNew = 5;
            this.cnt = 0;
            plataOut = false;
        }
        if (flags_mode == 2) {
            sostNew = plataIn ? 1 : 0;
            this.cnt = 0;
        } else if ((control & 8) > 0) {
            sostNew = 4;
            plataOut = false;
            this.tagControl.setInt(control &= 0xFFF7);
            ++this.cntManAlarm;
        }
        this.sost = sostNew;
        boolean bl = masterOut = this.sost == 1 && pInput;
        if (((control & 3) == 1 || (control & 3) == 3) && pInput) {
            masterOut = true;
        }
        if (flags_mode < 2) {
            this.channelOut.tagValue.setBool(plataOut);
        }
        this.tagTrigRes.setBool(pTrig);
        this.tagAlarm.setBool(this.sost == 4 || this.sost == 5 && (flags & 0x100) > 0);
        this.tagSost.setInt(this.sost);
        this.tagPlata.setBool(plataIn);
        this.tagCnt.setInt(this.cnt);
        this.tagMasterOut.setBool(masterOut);
        this.tagInput.setBool(pInput);
        this.tagInputExt.setBool(inputOutExt);
        return true;
    }

    protected boolean linkChannels(int flags_mode) {
        if ((flags_mode == 1 || flags_mode == 2) && this.channelIn.classic && this.channelOut.classic && this.channelIn.tagAddrNum.getInt() != this.channelOut.tagAddrNum.getInt()) {
            this.channelOut.tagAddrNum.copyValueTo(this.channelIn.tagAddrNum);
        }
        boolean chnl_ok = true;
        if (flags_mode != 3) {
            boolean bl = chnl_ok = chnl_ok && this.channelIn.isOk();
        }
        if (flags_mode < 2) {
            boolean bl = chnl_ok = chnl_ok && this.channelOut.isOk();
        }
        if (!chnl_ok) {
            this.tagSost.setInt(8);
            return false;
        }
        return chnl_ok;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("oldControl", this.oldControl);
        state.saveVar("cntManAlarm", this.cntManAlarm);
        state.saveVar("sost", this.sost);
        state.saveVar("cnt", this.cnt);
        state.saveVar("ctrlDlyCnt", this.ctrlDlyCnt);
        state.saveVar("ctrlValue", this.ctrlValue);
    }

    @Override
    public void loadStateExtra(State state) {
        this.oldControl = state.loadVar("oldControl", this.oldControl);
        this.cntManAlarm = state.loadVar("cntManAlarm", this.cntManAlarm);
        this.sost = state.loadVar("sost", this.sost);
        this.cnt = state.loadVar("cnt", this.cnt);
        this.ctrlDlyCnt = state.loadVar("ctrlDlyCnt", this.ctrlDlyCnt);
        this.ctrlValue = state.loadVar("ctrlValue", this.ctrlValue);
    }
}

