/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;
import promauto.utils.Numbers;

public class EasyDriveED3100Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(EasyDriveED3100Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Tag tagFreqSet;
    protected Tag tagFreqReq;
    protected Tag tagFreqOut;

    public EasyDriveED3100Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagFreqSet = this.tagtable.createInt("FreqSet", 0, 8);
        this.tagFreqReq = this.tagtable.createInt("FreqReq", 0, 8);
        this.tagFreqOut = this.tagtable.createInt("FreqOut", 0, 8);
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            if (this.tagFreqReq.getInt() != this.tagFreqSet.getInt()) {
                this.protocol.requestEasyDriveCmd10(8193, this.tagFreqSet.getInt());
            }
            if (result && (result = this.protocol.requestEasyDriveCmd3(3329))) {
                this.tagFreqReq.setInt(Numbers.bytesToWord(this.protocol.buffin, 4));
            }
            if (result && (result = this.protocol.requestEasyDriveCmd3(3328))) {
                this.tagFreqOut.setInt(Numbers.bytesToWord(this.protocol.buffin, 4));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

