/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import promauto.jroboplc.plugin.peripherial.PeripherialModule;

public class ProtocolTenzom {
    private final PeripherialModule module;
    public int[] buffout = new int[16];
    public int[] buffin = new int[128];
    public int error;

    public ProtocolTenzom(PeripherialModule module) {
        this.module = module;
    }

    public int getCrc(int[] buff, int beg, int end) {
        int tmp = buff[++end];
        buff[end] = 0;
        int crc = 0;
        for (int i = beg; i <= end; ++i) {
            int b = buff[i];
            for (int j = 0; j < 8; ++j) {
                boolean flag1 = (b & 0x80) > 0;
                b <<= 1;
                boolean flag2 = (crc & 0x80) > 0;
                crc = crc << 1 & 0xFF;
                if (flag1) {
                    ++crc;
                }
                if (!flag2) continue;
                crc ^= 0x69;
            }
        }
        buff[end] = tmp;
        return crc;
    }

    public long getBCDValue(int beg, int len) {
        long val = 0L;
        for (int i = beg + len - 1; i >= beg; --i) {
            val = val * 100L + (long)((this.buffin[i] >> 4) * 10) + (long)(this.buffin[i] & 0xF);
        }
        return val;
    }

    @Deprecated
    public boolean requestA(int cmd, int data1) throws Exception {
        this.buffout[3] = data1;
        return this.requestA1(cmd, 1);
    }

    @Deprecated
    private boolean requestA1(int cmd, int datasize) throws Exception {
        this.buffout[0] = 255;
        this.buffout[1] = this.module.netaddr;
        this.buffout[2] = cmd;
        this.buffout[datasize + 3] = this.getCrc(this.buffout, 1, datasize + 2);
        this.buffout[datasize + 4] = 255;
        this.buffout[datasize + 5] = 255;
        int sizeout = datasize + 6;
        for (int i = datasize + 3; i > 2; --i) {
            if (this.buffout[i] != 255) continue;
            for (int j = sizeout - 1; j > i; --j) {
                this.buffout[j + 1] = this.buffout[j];
            }
            this.buffout[i + 1] = 254;
            ++sizeout;
        }
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            boolean badcrc = false;
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.module.port.writeBytes(this.buffout, sizeout);
            int b = 0;
            int i = -1;
            while (i < this.buffin.length && (b = this.module.port.readByte()) >= 0) {
                if (b == 255) {
                    if (i == -1) {
                        i = 0;
                    }
                    if (i < 2) continue;
                    b = this.module.port.readByte();
                    if (b < 0) break;
                    if (b == 255) {
                        if (this.getCrc(this.buffin, 0, i - 1) != 0) {
                            badcrc = true;
                            break;
                        }
                        if (this.buffin[0] != this.module.netaddr) break;
                        return true;
                    }
                    if (b != 254) break;
                    b = 255;
                }
                if (i >= this.buffin.length) break;
                this.buffin[i++] = b;
            }
            if (this.module.canLogError()) {
                this.module.logError(trynum, badcrc, this.buffout, datasize, this.buffin, i, "last byte = " + b);
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return false;
    }

    public boolean requestCounters(int size) throws Exception {
        this.buffout[0] = 255;
        this.buffout[1] = this.module.netaddr;
        this.buffout[2] = 200;
        this.buffout[3] = size + 129;
        int sizeout = this.prepareBuffout(4);
        return this.request(sizeout, (size + 1) * 5 + 4);
    }

    public boolean requestValue(int cop, int len) throws Exception {
        this.buffout[0] = 255;
        this.buffout[1] = this.module.netaddr;
        this.buffout[2] = cop;
        int sizeout = this.prepareBuffout(3);
        return this.request(sizeout, 3 + len);
    }

    private int prepareBuffout(int pos) {
        this.buffout[pos] = this.getCrc(this.buffout, 1, pos - 1);
        this.buffout[pos + 1] = 255;
        this.buffout[pos + 2] = 255;
        int sizeout = pos + 3;
        if (this.buffout[pos] == 255) {
            this.buffout[pos + 1] = 254;
            this.buffout[pos + 3] = 255;
            sizeout = pos + 4;
        }
        return sizeout;
    }

    private boolean request(int sizeout, int sizein) throws Exception {
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            int b;
            this.error = 0;
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.module.port.writeBytes(this.buffout, sizeout);
            int i = 0;
            boolean gotStartMarker = false;
            while (true) {
                if ((b = this.module.port.readByte()) < 0) {
                    gotStartMarker = false;
                    break;
                }
                if (b == 255) {
                    gotStartMarker = true;
                    continue;
                }
                if (gotStartMarker && b == this.module.netaddr) break;
                gotStartMarker = false;
            }
            if (!gotStartMarker) {
                this.error = 1;
            } else {
                i = 1;
                this.buffin[0] = this.module.netaddr;
                do {
                    if ((b = this.module.port.readByte()) == 255) {
                        b = this.module.port.readByte();
                        if (b == 255) {
                            if (this.getCrc(this.buffin, 0, i - 1) != 0) {
                                this.error = 2;
                                break;
                            }
                            if (i < sizein) {
                                this.error = 3;
                                break;
                            }
                            return true;
                        }
                        if (b == 254) {
                            b = 255;
                        } else {
                            this.error = 4;
                            break;
                        }
                    }
                    this.buffin[i++] = b;
                } while (b >= 0 && i < this.buffin.length);
            }
            if (this.module.canLogError()) {
                this.module.logError(trynum, this.error == 1, this.buffout, sizeout, this.buffin, i, "error = " + this.error + ", lastbyte" + b);
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return false;
    }
}

