/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.raduga.Context;
import promauto.jroboplc.plugin.raduga.Task;

public class TaskRepo {
    private final Context ctx;
    private final Map<Integer, Task> tasks;

    public TaskRepo(Context ctx) {
        this.ctx = ctx;
        this.tasks = new HashMap<Integer, Task>();
    }

    public void clear() {
        this.tasks.clear();
    }

    public void beforeUsing() throws SQLException {
        this.tasks.values().forEach(task -> {
            task.used = false;
        });
    }

    public void removeUnused() {
        this.tasks.values().removeIf(task -> !task.used);
    }

    public Task get(Tag tagTaskId) throws SQLException {
        return this.get(tagTaskId.getInt());
    }

    public Task get(int taskId) throws SQLException {
        Task task = this.tasks.get(taskId);
        if (task == null) {
            task = this.ctx.service.getTask(taskId);
            this.tasks.put(taskId, task);
        }
        task.used = true;
        return task;
    }

    public boolean addTotalExeWeight(int taskId, long weight) throws SQLException {
        if (!this.tasks.containsKey(taskId)) {
            return false;
        }
        this.get((int)taskId).totalExeWeight += weight;
        return true;
    }

    public int size() {
        return this.tasks.size();
    }
}

