/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.rpclient;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagBase;
import promauto.jroboplc.core.tags.TagInt;
import promauto.jroboplc.core.tags.TagRWInt;
import promauto.jroboplc.plugin.rpclient.CmdDebugInfoWrite;
import promauto.utils.CRC;
import promauto.utils.Numbers;
import promauto.utils.Strings;

public class RpClientModule
extends AbstractModule {
    private static final int BUFF_SIZE = 32768;
    private final Logger logger = LoggerFactory.getLogger(RpClientModule.class);
    private static final Charset charset = Charset.forName("UTF-8");
    private Socket socket = null;
    protected InputStream streamReader;
    protected BufferedWriter socketWriter;
    protected TagRWInt[] tags = new TagRWInt[0];
    protected Map<Tag, Integer> irrtags = new HashMap<Tag, Integer>();
    protected String tagfilter;
    protected int reconnectTimeSec;
    protected int timeoutMs;
    protected Tag tagHost;
    protected Tag tagPort;
    protected Tag tagConnected;
    protected Tag tagReconnectCounter;
    protected Tag tagDisconnectCounter;
    private Map<String, String> alarmValues = new HashMap<String, String>();
    protected boolean connected = false;
    private long cooldownTime = 0L;
    protected byte[] buffin = new byte[32768];
    protected int buffinBeg;
    protected int buffinEnd;
    private boolean hasMore;
    private StringBuilder sb = new StringBuilder();
    private int indexRead;
    private boolean answerNotSupported;
    private boolean needToGetAll;
    private boolean useCrcTagValues;
    private boolean useMessages;
    private long crcTheirs;
    private int[] buffCrcTagValuesH;
    private int[] buffCrcTagValuesL;
    protected Console debugConsole = null;
    protected boolean debugInfoWrite = false;
    private boolean hasFetchChanges;

    public RpClientModule(Plugin plugin, String name) {
        super(plugin, name);
        this.env.getCmdDispatcher().addCommand(this, CmdDebugInfoWrite.class);
    }

    @Override
    public boolean canHaveExternalTags() {
        return true;
    }

    @Override
    public boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.tagfilter = cm.get(conf, "filter", "*");
        this.reconnectTimeSec = cm.get(conf, "recon_s", 60);
        this.timeoutMs = cm.get(conf, "timeout_ms", 3000);
        this.tagHost = this.tagtable.createString("host.addr", cm.get(conf, "host", "localhost"));
        this.tagPort = this.tagtable.createInt("host.port", cm.get(conf, "port", 3033));
        this.tagConnected = this.tagtable.createBool("connected", false);
        this.tagReconnectCounter = this.tagtable.createInt("reconnect.cnt", 0);
        this.tagDisconnectCounter = this.tagtable.createInt("disconnect.cnt", 0);
        this.alarmValues.clear();
        for (Object obj : cm.toList(cm.get(conf, "alarm.values"))) {
            this.alarmValues.put(cm.get(obj, "tag", ""), cm.get(obj, "value", ""));
        }
        return true;
    }

    @Override
    public boolean prepareModule() {
        this.tagReconnectCounter.setInt(0);
        this.tagDisconnectCounter.setInt(0);
        this.connect();
        if (!this.connected) {
            this.env.printInfo(this.logger, this.name, "No connection");
        }
        return true;
    }

    @Override
    public boolean closedownModule() {
        if (!this.enable) {
            return true;
        }
        this.disconnect();
        return true;
    }

    @Override
    public boolean executeModule() {
        block9: {
            try {
                if (this.cooldownTime > 0L) {
                    if (this.isCooldownOver()) {
                        this.resetCooldown();
                        if (this.connect()) {
                            // empty if block
                        }
                    }
                    break block9;
                }
                boolean ok = this.isConnected();
                if (ok) {
                    try {
                        ok = this.writeValues() && this.writeIrrFlags() && this.readValues(this.needToGetAll);
                        this.readMessages();
                    }
                    catch (Exception e) {
                        ok = false;
                    }
                }
                if (!ok) {
                    this.disconnect();
                    this.setupCooldown();
                    int cnt = this.tagDisconnectCounter.getInt() + 1;
                    this.tagDisconnectCounter.setInt(cnt);
                    this.env.printInfo(this.logger, this.name, "Connection lost, cnt:", "" + cnt);
                    this.applyAlarmValues();
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
            }
        }
        return true;
    }

    private void applyAlarmValues() {
        for (String tagexpr : this.alarmValues.keySet()) {
            Pattern p = Pattern.compile(tagexpr);
            String value = this.alarmValues.get(tagexpr);
            for (TagRWInt tag : this.tags) {
                if (!p.matcher(tag.getName()).matches()) continue;
                tag.setReadValString(value);
            }
        }
    }

    private boolean connect() {
        if (this.connected || !this.enable) {
            return true;
        }
        try {
            int reconnectCnt = this.tagReconnectCounter.getInt();
            this.tagReconnectCounter.setInt(reconnectCnt + 1);
            this.connectSocket();
            this.connected = this.isConnected();
            if (this.connected) {
                this.postSignal(Signal.SignalType.CONNECTED);
                if (this.handshake() && this.fetchTags()) {
                    this.tagConnected.setBool(true);
                    if (reconnectCnt > 0) {
                        this.env.printInfo(this.logger, this.name, "Connection restored");
                    }
                    this.resetCooldown();
                    return true;
                }
            }
        }
        catch (IOException reconnectCnt) {
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        this.disconnect();
        this.setupCooldown();
        return false;
    }

    protected void connectSocket() throws SocketException, IOException {
        this.socket = new Socket();
        this.socket.setSoTimeout(this.timeoutMs);
        this.socket.connect(new InetSocketAddress(this.tagHost.toString(), this.tagPort.getInt()), this.timeoutMs);
        this.streamReader = this.socket.getInputStream();
        this.socketWriter = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), charset), 32768);
    }

    private void disconnect() {
        if (!this.connected) {
            return;
        }
        for (TagRWInt tag : this.tags) {
            if (tag == null || tag.getStatus() != Tag.Status.Good) continue;
            tag.setStatus(Tag.Status.Bad);
        }
        if (this.socket != null) {
            try {
                this.disconnectSocket();
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
            }
            this.socket = null;
        }
        this.connected = false;
        this.tagConnected.setBool(false);
        this.postSignal(Signal.SignalType.DISCONNECTED);
    }

    protected void disconnectSocket() throws IOException {
        this.socket.close();
    }

    private boolean handshake() throws IOException {
        return this.getAnswer("", false) && this.buffinStartsWith("100-Roboplant OPC Server (TCP)");
    }

    protected boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && this.socket.isBound() && !this.socket.isClosed();
    }

    private boolean fetchTags() throws IOException {
        this.hasFetchChanges = false;
        HashSet<String> tagnames = new HashSet<String>();
        if (!this.request("SETFILTER " + this.tagfilter, "101", false)) {
            return false;
        }
        if (!this.request("CREATETAGLIST", "103", false)) {
            return false;
        }
        int total = Numbers.hexToInt(this.buffin, this.buffinBeg, this.buffinEnd - this.buffinBeg);
        TagRWInt[] tmptags = new TagRWInt[total];
        if (total > 0) {
            int index = 0;
            do {
                if (!this.request("GETTAGLIST " + Numbers.toHexString(index), "104", true)) {
                    return false;
                }
                LinkedList<String> list = new LinkedList<String>();
                if (!this.parseListAnswer(list, index)) {
                    return false;
                }
                for (String tagname : list) {
                    if (index >= tmptags.length) break;
                    Tag tag = this.tagtable.get(tagname);
                    TagBase tagrw = null;
                    if (tag != null && tag instanceof TagRWInt) {
                        tagrw = (TagRWInt)tag;
                    }
                    if (tagrw == null) {
                        tagrw = this.tagtable.add(new TagRWInt(tagname, 0, 4));
                        tagrw.setStatus(Tag.Status.Uninitiated);
                        this.hasFetchChanges = true;
                    } else if (tagrw.getStatus() == Tag.Status.Deleted) {
                        tagrw.setStatus(Tag.Status.Uninitiated);
                        this.hasFetchChanges = true;
                    }
                    tmptags[index++] = tagrw;
                }
                tagnames.addAll(list);
            } while (this.hasMore);
            if (index != total) {
                this.env.printError(this.logger, this.name, "Fetch tags error, index:" + index + " != total" + total);
                return false;
            }
        }
        this.tags = tmptags;
        LinkedList<Tag> deltags = new LinkedList<Tag>();
        for (Tag tag : this.tagtable.values()) {
            if (!tag.hasFlags(4) || tagnames.contains(tag.getName())) continue;
            deltags.add(tag);
        }
        for (Tag tag : deltags) {
            this.tagtable.remove(tag);
            this.hasFetchChanges = true;
        }
        this.useCrcTagValues = true;
        this.useMessages = true;
        if (total > 0) {
            if (!this.readValues(true)) {
                return false;
            }
            if (!this.readIrrTags()) {
                return false;
            }
        }
        if (this.hasFetchChanges) {
            this.postSignal(Signal.SignalType.RELOADED);
        }
        return true;
    }

    private boolean isCooldownOver() {
        return this.cooldownTime < System.currentTimeMillis();
    }

    private void setupCooldown() {
        this.cooldownTime = System.currentTimeMillis() + (long)(this.reconnectTimeSec * 1000);
    }

    private void resetCooldown() {
        this.cooldownTime = 0L;
    }

    private boolean readMessages() throws IOException {
        if (!this.useMessages) {
            return true;
        }
        if (!this.request("GETMSG", "119", false)) {
            if (this.answerNotSupported) {
                this.useMessages = false;
            }
            return false;
        }
        if (this.buffinBeg < this.buffinEnd) {
            String msg = new String(this.buffin, this.buffinBeg, this.buffinEnd - this.buffinBeg);
            if (msg.startsWith("RELOAD")) {
                this.onMessageReload();
            } else {
                this.env.printInfo(this.logger, this.name, "received unknown message:", msg);
            }
        }
        return true;
    }

    private void onMessageReload() throws IOException {
        this.env.printInfo(this.logger, this.name, "received message RELOAD from server");
        this.fetchTags();
    }

    private boolean writeValues() throws IOException {
        int i = 0;
        for (TagRWInt tag : this.tags) {
            if (tag.hasWriteValue()) {
                int value;
                if (this.debugInfoWrite && this.debugConsole != null) {
                    this.debugConsole.print(this.name + " write: " + tag.getName() + " = " + tag.getInt() + " -> " + tag.getWriteValInt() + "\r\n");
                }
                if (!this.writeValue("WNM", "109", i, value = tag.getWriteValInt())) {
                    this.env.printError(this.logger, this.name, "Write error:", tag.getName(), "= " + value);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean writeIrrFlags() throws IOException {
        if (this.irrtags.isEmpty()) {
            return true;
        }
        for (Map.Entry<Tag, Integer> ent : this.irrtags.entrySet()) {
            Tag auxtag = (Tag)ent.getKey().getObject();
            int idx = ent.getValue();
            if (auxtag == null || auxtag.getInt() <= 0) continue;
            if (!this.writeValue("SETFLAG", "117", idx, auxtag.getInt())) {
                this.env.printError(this.logger, this.name, "Set flag error:", ent.getKey().getName(), auxtag.getName(), "= " + auxtag.getInt());
                continue;
            }
            auxtag.setInt(0);
        }
        return true;
    }

    public boolean writeValue(String cmd, String prefix, int index, int value) throws IOException {
        this.sb.setLength(0);
        this.sb.append(Numbers.toHexChars(index));
        if (value < 0) {
            this.sb.append(" -");
        } else {
            this.sb.append(' ');
        }
        this.sb.append(Numbers.toHexChars(Math.abs(value)));
        int crc = CRC.getCrc16(this.sb.toString().getBytes(charset));
        this.sb.insert(0, ' ');
        this.sb.insert(0, cmd);
        this.sb.append(' ');
        this.sb.append(Numbers.toHexChars(crc));
        if (!this.request(this.sb.toString(), prefix, false)) {
            return false;
        }
        return this.buffin[this.buffinBeg] == 33;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readValues(boolean _get_all) throws IOException {
        long crcL;
        if (!this.request("FIXALL", "105", false)) {
            return false;
        }
        int changed_val_count = Numbers.hexToInt(this.buffin, this.buffinBeg, this.buffinEnd - this.buffinBeg);
        if (changed_val_count == 0 && !_get_all) {
            return true;
        }
        if (this.useCrcTagValues) {
            if (!this.request("GETCRC", "118", false)) {
                if (!this.answerNotSupported) return false;
                this.useCrcTagValues = false;
            } else {
                this.crcTheirs = Numbers.hexToLong(this.buffin, this.buffinBeg, this.buffinEnd - this.buffinBeg);
            }
        }
        this.indexRead = 0;
        do {
            this.sb.setLength(0);
            if (_get_all ? !this.request(this.sb.append("GETALL ").append(Numbers.toHexChars(this.indexRead)).toString(), "106", true) : !this.request(this.sb.append("GETCHG ").append(Numbers.toHexChars(this.indexRead)).toString(), "107", true)) {
                return false;
            }
            if (this.parseValues()) continue;
            return false;
        } while (this.hasMore);
        if (_get_all) {
            this.needToGetAll = false;
        }
        if (!this.useCrcTagValues) return true;
        if (this.buffCrcTagValuesH == null || this.buffCrcTagValuesH.length != this.tags.length) {
            this.buffCrcTagValuesH = new int[this.tags.length];
            this.buffCrcTagValuesL = new int[this.tags.length];
        }
        int n = this.tags.length;
        for (int i = 0; i < n; ++i) {
            int value = this.tags[i].getInt();
            this.buffCrcTagValuesH[i] = value >> 8 & 0xFF;
            this.buffCrcTagValuesL[i] = value & 0xFF;
        }
        long crcH = CRC.getCrc16(this.buffCrcTagValuesH, n);
        long crcOurs = (crcH << 16) + (crcL = (long)CRC.getCrc16(this.buffCrcTagValuesL, n));
        this.needToGetAll = crcOurs != this.crcTheirs;
        return true;
    }

    private boolean readIrrTags() throws IOException {
        this.irrtags.clear();
        this.indexRead = 0;
        do {
            this.sb.setLength(0);
            if (!this.request(this.sb.append("GETPROPS ").append(Numbers.toHexChars(this.indexRead)).toString(), "116", true)) {
                return this.answerNotSupported;
            }
            if (this.parseProps()) continue;
            return false;
        } while (this.hasMore);
        return true;
    }

    private boolean request(String _command, String _answer, boolean _use_crc) throws IOException {
        this.clearSockerReader();
        this.socketWriter.write(_command);
        this.socketWriter.write("\r\n");
        this.socketWriter.flush();
        return this.getAnswer(_answer, _use_crc);
    }

    protected void clearSockerReader() throws IOException {
        int n;
        while ((n = this.streamReader.available()) > 0) {
            this.streamReader.skip(n);
        }
    }

    private boolean getAnswer(String prefix, boolean use_crc) throws IOException {
        this.hasMore = false;
        if (!this.readBuffin()) {
            return false;
        }
        if (!prefix.isEmpty()) {
            if (!this.buffinStartsWith(prefix)) {
                this.answerNotSupported = this.buffinStartsWith("400");
                return false;
            }
            this.buffinBeg = prefix.length() + 1;
        }
        if (use_crc) {
            boolean has_more = false;
            int k = this.buffinGetPosReverse(61);
            if (k == -1) {
                k = this.buffinGetPosReverse(126);
                has_more = true;
            }
            if (k == -1) {
                return false;
            }
            int crc_their = Numbers.hexToInt(this.buffin, k + 1, this.buffinEnd - k - 1);
            this.buffinEnd = k;
            int crc_mine = CRC.getCrc16(this.buffin, this.buffinBeg, this.buffinEnd - 1);
            if (crc_mine != crc_their) {
                return false;
            }
            this.hasMore = has_more;
        }
        return true;
    }

    protected boolean readBuffin() throws IOException {
        int i = 0;
        block0: while (true) {
            int n;
            if (i + (n = Math.max(1, this.streamReader.available())) > 32768) {
                return false;
            }
            if ((n = this.streamReader.read(this.buffin, i, n)) == -1) {
                return false;
            }
            n = i + n;
            while (true) {
                if (i >= n) continue block0;
                if (this.buffin[i] == 13 || this.buffin[i] == 10) break block0;
                ++i;
            }
            break;
        }
        this.buffinBeg = 0;
        this.buffinEnd = i;
        return true;
    }

    private boolean buffinStartsWith(String substr) {
        return Strings.bytesStartsWith(substr, this.buffin, this.buffinBeg, this.buffinEnd);
    }

    private int buffinGetPosReverse(int ch) {
        return Strings.getPosReverse(ch, this.buffin, this.buffinBeg, this.buffinEnd);
    }

    private int buffinGetPos(int ch) {
        return Strings.getPos(ch, this.buffin, this.buffinBeg, this.buffinEnd);
    }

    private boolean parseListAnswer(List<String> list, int index) {
        int p1 = this.buffinGetPos(35);
        int p2 = this.buffinGetPos(33);
        int size = Numbers.hexToInt(this.buffin, this.buffinBeg, p1 - this.buffinBeg);
        if (size == 0) {
            return true;
        }
        int index_their = Numbers.hexToInt(this.buffin, p1 + 1, p2 - p1 - 1);
        if (index != index_their) {
            return false;
        }
        this.buffinBeg = p2 + 1;
        int k = 0;
        for (int i = 0; i < size; ++i) {
            k = this.buffinGetPos(59);
            if (k == -1) {
                list.add(new String(this.buffin, this.buffinBeg, this.buffinEnd - this.buffinBeg));
                break;
            }
            list.add(new String(this.buffin, this.buffinBeg, k - this.buffinBeg));
            this.buffinBeg = k + 1;
        }
        return true;
    }

    private boolean parseValues() {
        int p = this.buffinGetPos(35);
        if (p == -1) {
            return false;
        }
        int size = Numbers.hexToInt(this.buffin, this.buffinBeg, p - this.buffinBeg);
        if (size == 0) {
            return true;
        }
        this.buffinBeg = p;
        int b = 0;
        int index = -1;
        int value = 0;
        boolean sign = false;
        int index_max = this.tags.length;
        while (true) {
            if (this.buffinBeg >= this.buffinEnd) {
                if (index < 0 && index >= index_max) {
                    return false;
                }
                break;
            }
            if ((b = this.buffin[this.buffinBeg++] & 0xFF) == 59 || b == 35) {
                if (index >= 0) {
                    if (index >= index_max) {
                        return false;
                    }
                    this.tags[index++].setReadValInt(sign ? -value : value);
                    value = 0;
                    sign = false;
                }
                if (b != 35) continue;
                p = this.buffinGetPos(33);
                if (p == -1) {
                    return false;
                }
                index = Numbers.hexToInt(this.buffin, this.buffinBeg, p - this.buffinBeg);
                this.buffinBeg = p + 1;
                continue;
            }
            if (b == 45) {
                sign = !sign;
                continue;
            }
            value = (value << 4) + Numbers.asciiDigitToInt(b);
        }
        this.tags[index++].setReadValInt(sign ? -value : value);
        this.indexRead = index;
        return true;
    }

    private boolean parseProps() {
        int p = this.buffinGetPos(35);
        if (p == -1) {
            return false;
        }
        int size = Numbers.hexToInt(this.buffin, this.buffinBeg, p - this.buffinBeg);
        if (size == 0) {
            return true;
        }
        this.buffinBeg = p + 1;
        p = this.buffinGetPos(33);
        if (p == -1) {
            return false;
        }
        int index = Numbers.hexToInt(this.buffin, this.buffinBeg, p - this.buffinBeg);
        this.buffinBeg = p + 1;
        int b = 0;
        int value = 0;
        int index_max = this.tags.length;
        boolean endflag = false;
        while (!endflag) {
            endflag = this.buffinBeg >= this.buffinEnd;
            if (!endflag) {
                b = this.buffin[this.buffinBeg++] & 0xFF;
            }
            if (b == 59 || endflag) {
                if (index >= index_max) {
                    return false;
                }
                TagRWInt tag = this.tags[index];
                if (value == 1) {
                    this.irrtags.put(tag, index);
                }
                if (value == 1 && tag.getObject() == null) {
                    tag.setObject(new TagInt("IRR", 0));
                } else if (value == 0 && tag.getObject() != null) {
                    tag.setObject(null);
                }
                ++index;
                value = 0;
                continue;
            }
            value = (value << 4) + Numbers.asciiDigitToInt(b);
        }
        this.indexRead = index;
        return true;
    }

    @Override
    public String getInfo() {
        return this.enable ? (!this.connected ? "\u001b[31m\u001b[01mERROR! \u001b[0m" : "") + String.format("%-16s ", this.tagHost.toString() + ":" + this.tagPort.toString()) + " discon=" + this.tagDisconnectCounter + " recon=" + this.tagReconnectCounter + " tags=" + this.tags.length : "disabled";
    }

    @Override
    protected boolean reload() {
        RpClientModule tmp = new RpClientModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.closedown();
        this.copySettingsFrom(tmp);
        this.alarmValues = tmp.alarmValues;
        this.tagfilter = tmp.tagfilter;
        this.reconnectTimeSec = tmp.reconnectTimeSec;
        this.timeoutMs = tmp.timeoutMs;
        this.cooldownTime = 0L;
        tmp.tagHost.copyValueTo(this.tagHost);
        tmp.tagPort.copyValueTo(this.tagPort);
        tmp.tagConnected.copyValueTo(this.tagConnected);
        tmp.tagReconnectCounter.copyValueTo(this.tagReconnectCounter);
        tmp.tagDisconnectCounter.copyValueTo(this.tagDisconnectCounter);
        return this.prepare();
    }
}

