/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagBase;

public class TagInt
extends TagBase {
    private volatile int value;

    public TagInt(String name, int value) {
        super(name);
        this.setInt(value);
    }

    public TagInt(String name, int value, int flags) {
        super(name, flags);
        this.setInt(value);
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.INT;
    }

    @Override
    public boolean getBool() {
        return this.value != 0;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return "" + this.value;
    }

    @Override
    public void setBool(boolean value) {
        if (this.value != (value ? 1 : 0)) {
            this.value = value ? 1 : 0;
        }
    }

    @Override
    public void setOn() {
        if (this.value != 1) {
            this.value = 1;
        }
    }

    @Override
    public void setOff() {
        if (this.value != 0) {
            this.value = 0;
        }
    }

    @Override
    public void setInt(int value) {
        if (this.value != value) {
            this.value = value;
        }
    }

    @Override
    public void setLong(long value) {
        if (this.value != (int)value) {
            this.value = (int)value;
        }
    }

    @Override
    public void setDouble(double value) {
        if (this.value != (int)value) {
            this.value = (int)value;
        }
    }

    @Override
    public void setString(String value) {
        int parsed;
        try {
            parsed = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            parsed = 0;
        }
        if (this.value != parsed) {
            this.value = parsed;
        }
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getInt() == this.value;
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setInt(this.value);
    }
}

