/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagBase;

public class TagString
extends TagBase {
    private volatile String value;

    public TagString(String name, String value) {
        super(name);
        this.setString(value);
    }

    public TagString(String name, String value, int flags) {
        super(name, flags);
        this.setString(value);
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.STRING;
    }

    @Override
    public boolean getBool() {
        return this.value.equals("on");
    }

    @Override
    public int getInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public long getLong() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public double getDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public void setBool(boolean value) {
        this.value = value ? "on" : "off";
    }

    @Override
    public void setOn() {
        this.value = "on";
    }

    @Override
    public void setOff() {
        this.value = "off";
    }

    @Override
    public void setInt(int value) {
        this.value = "" + value;
    }

    @Override
    public void setLong(long value) {
        this.value = "" + value;
    }

    @Override
    public void setDouble(double value) {
        this.value = "" + value;
    }

    @Override
    public void setString(String value) {
        this.value = value.length() <= 4096 ? value : value.substring(0, 4096);
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getString().equals(this.value);
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setString(this.value);
    }
}

