/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.arcsvr;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.PatternList;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagPlain;
import promauto.jroboplc.plugin.arcsvr.ArcvalBase;
import promauto.jroboplc.plugin.arcsvr.ArcvalHolder;

public class ArcvalRegex
extends ArcvalBase {
    private final Logger logger = LoggerFactory.getLogger(ArcvalRegex.class);
    private int force_ms;
    private long lastforce_ms;
    private Mode mode;
    private PatternList filters = new PatternList();
    private Map<String, Rec> recs = new TreeMap<String, Rec>();
    private boolean needInit;
    private boolean phantomsOnly;
    private Function<Rec, Tag> getTagByModeFunc;

    ArcvalRegex(ArcvalHolder holder, String arcname) {
        super(holder, arcname);
    }

    public boolean load(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.period_ms = cm.get(conf, "period_ms", 1000);
        this.force_ms = cm.get(conf, "force_s", 60) * 1000;
        this.arcsize = cm.get(conf, "size", 1209600);
        this.descr = cm.get(conf, "descr", "");
        this.period_align = cm.get(conf, "period_align", false);
        String stype = cm.get(conf, "type", "INT32");
        String speriod = cm.get(conf, "mode", "period");
        try {
            this.ftype = ArcvalBase.FieldType.valueOf(stype.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.env.printError(this.logger, e, this.module.getName(), this.arcname, "Bad type = " + stype);
            return false;
        }
        try {
            this.mode = Mode.valueOf(speriod.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.env.printError(this.logger, e, this.module.getName(), this.arcname, "Bad period = " + speriod);
            return false;
        }
        try {
            this.filters.load(conf, "tags");
        }
        catch (PatternSyntaxException e) {
            this.env.printError(this.logger, e, this.module.getName(), this.arcname, "Tags loading error");
            return false;
        }
        this.getTagByModeFunc = this.mode == Mode.PERIOD ? rec -> rec.tag : rec -> rec.value;
        return true;
    }

    @Override
    public void link() {
        this.recs.values().forEach(rec -> {
            rec.tobeRemoved = true;
        });
        for (Module mod : this.env.getModuleManager().getModules()) {
            for (Tag tag : mod.getTagTable().values()) {
                String tagname;
                if (tag.getType() == Tag.Type.STRING || !this.filters.match(tagname = tag.hasFlags(4) ? tag.getName() : mod.getName() + '.' + tag.getName())) continue;
                Rec rec2 = this.recs.get(tagname);
                if (rec2 == null) {
                    rec2 = new Rec();
                    this.recs.put(tagname, rec2);
                    this.needInit = true;
                }
                this.needInit |= rec2.phantom;
                rec2.mod = mod;
                rec2.tag = tag;
                rec2.phantom = false;
                rec2.tobeRemoved = false;
            }
        }
        this.needInit |= this.recs.values().removeIf(rec -> !rec.phantom && rec.tobeRemoved);
        this.phantomsOnly = this.recs.values().stream().allMatch(rec -> rec.phantom);
    }

    @Override
    public boolean init() {
        super.init();
        long curms = System.currentTimeMillis();
        if (this.period_align) {
            long curdayms = LocalTime.now().toNanoOfDay() / 1000000L;
            this.lastpass_ms = curms - curdayms % (long)this.period_ms;
            this.lastforce_ms = curms - curdayms % (long)this.force_ms;
        } else {
            this.lastforce_ms = curms;
        }
        boolean res = false;
        Database db = this.module.getDatabase();
        try (Statement st = db.getConnection().createStatement();){
            this.initArc(st);
            this.initTags(st);
            db.commit();
            List<Integer> idtags = this.recs.values().stream().map(rec -> rec.idtag).collect(Collectors.toList());
            this.initArctable(st, idtags);
            db.commit();
            this.initPst(idtags);
            this.initCurrec(st);
            db.commit();
            this.initValues(st);
            db.commit();
            res = true;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.module.getName(), this.arcname, "Init error:");
            db.rollback();
        }
        this.needInit = false;
        return res;
    }

    private void initTags(Statement st) throws SQLException {
        Map<String, ArcvalBase.DescrTagid> tmp = this.getTaglistMap(st);
        for (Map.Entry<String, Rec> ent : this.recs.entrySet()) {
            String tagname = ent.getKey();
            Rec rec = ent.getValue();
            ArcvalBase.DescrTagid dti = tmp.get(tagname);
            if (dti == null) {
                rec.idtag = this.createTaglistRec(st, tagname, tagname);
                continue;
            }
            rec.idtag = dti.tagid;
            tmp.remove(tagname);
        }
        for (String tagname : tmp.keySet()) {
            if (this.filters.match(tagname)) {
                this.recs.put(tagname, new Rec(tmp.get((Object)tagname).tagid));
                continue;
            }
            this.deleteTaglistRec(st, tmp.get((Object)tagname).tagid, tagname);
        }
    }

    private void initValues(Statement st) throws SQLException {
        if (this.mode == Mode.CHANGE) {
            for (Rec rec : this.recs.values()) {
                if (rec.phantom) {
                    rec.value = null;
                    continue;
                }
                if (rec.value == null) {
                    rec.value = TagPlain.create(rec.tag);
                    continue;
                }
                rec.tag.copyValueTo(rec.value);
            }
            String sql = String.format("select first 1 * from %s order by rec desc", this.module.makeTableName(this.arcname));
            try (ResultSet rs = st.executeQuery(sql);){
                if (rs.next()) {
                    HashMap<Integer, Integer> tmp = new HashMap<Integer, Integer>();
                    ResultSetMetaData md = rs.getMetaData();
                    int n = md.getColumnCount();
                    for (int i = 1; i <= n; ++i) {
                        String field = md.getColumnName(i);
                        if (!field.startsWith("T")) continue;
                        tmp.put(Integer.parseInt(field.substring(1)), i);
                    }
                    for (Rec rec : this.recs.values()) {
                        Integer idx;
                        if (rec.value == null || (idx = (Integer)tmp.get(rec.idtag)) == null) continue;
                        if (rec.value.getType() == Tag.Type.DOUBLE) {
                            rec.value.setDouble(rs.getDouble(idx));
                        } else {
                            rec.value.setLong(rs.getLong(idx));
                        }
                        if (!rs.wasNull()) continue;
                        rec.value.setBool(!rec.tag.getBool());
                    }
                } else {
                    for (Rec rec : this.recs.values()) {
                        if (rec.phantom) continue;
                        rec.value.setBool(!rec.tag.getBool());
                    }
                }
            }
        }
    }

    @Override
    protected void setPstInsertData() throws SQLException {
        int i = 0;
        for (Rec rec : this.recs.values()) {
            Tag tag = this.getTagByModeFunc.apply(rec);
            if (tag == null) {
                this.pstInsert.setNull(++i, this.ftypeSql);
                continue;
            }
            this.setPstInsertFunc.apply(++i, tag);
        }
        this.pstInsert.setLong(++i, this.currec);
        this.pstInsert.setTimestamp(++i, Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.needInit && !this.init()) {
            this.closePreparedStatements();
        }
        if (this.phantomsOnly) {
            return true;
        }
        long curms = System.currentTimeMillis();
        if (!this.hasExecTimeCome(curms)) {
            return true;
        }
        if (this.mode == Mode.CHANGE) {
            long ms;
            boolean hasChanges = false;
            for (Rec rec : this.recs.values()) {
                if (rec.phantom || rec.tag.equalsValue(rec.value)) continue;
                hasChanges = true;
                rec.tag.copyValueTo(rec.value);
            }
            if (this.force_ms > 0 && (ms = curms - this.lastforce_ms) >= (long)this.force_ms) {
                this.lastforce_ms += (long)(this.force_ms * (int)(ms / (long)this.force_ms));
                hasChanges = true;
            }
            if (!hasChanges) {
                return true;
            }
        }
        return super.execute();
    }

    @Override
    public String pack() {
        long count = this.recs.values().stream().filter(rec -> rec.phantom).count();
        if (count == 0L) {
            return "";
        }
        Database db = this.module.getDatabase();
        try (Statement st = db.getConnection().createStatement();){
            for (Map.Entry<String, Rec> ent : this.recs.entrySet()) {
                if (!ent.getValue().phantom) continue;
                this.deleteTaglistRec(st, ent.getValue().idtag, ent.getKey());
            }
            this.recs.values().removeIf(rec -> rec.phantom);
            this.needInit = true;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.module.getName(), this.arcname, "Pack error");
            db.rollback();
        }
        return this.arcname + ": " + count + "\r\n";
    }

    @Override
    public String getInfo() {
        long nolink_cnt = this.recs.values().stream().filter(rec -> rec.phantom).count();
        return String.format("\r\n%s: %s per=%d%s size=%d cur=%d tags=%d%s", new Object[]{this.arcname, this.mode, this.period_ms, this.mode == Mode.PERIOD ? "" : Integer.valueOf(47 + this.force_ms / 1000), this.arcsize, this.currec, this.recs.size(), nolink_cnt == 0L ? "" : "/\u001b[31m" + nolink_cnt + " nolink" + "\u001b[0m"});
    }

    @Override
    public String getNolinks() {
        StringBuilder sb = new StringBuilder();
        this.recs.entrySet().stream().filter(rec -> ((Rec)rec.getValue()).phantom).forEach(rec -> sb.append("  ").append((String)rec.getKey()).append("\r\n"));
        return sb.toString();
    }

    private static class Rec {
        Module mod = null;
        Tag tag = null;
        int idtag;
        Tag value = null;
        boolean phantom = false;
        boolean tobeRemoved = false;

        Rec(int idtag) {
            this.idtag = idtag;
            this.phantom = true;
        }

        Rec() {
        }
    }

    static enum Mode {
        PERIOD,
        CHANGE;

    }
}

