/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.core.tags.TagRWBool;
import promauto.jroboplc.core.tags.TagRWDouble;
import promauto.jroboplc.core.tags.TagRWInt;
import promauto.jroboplc.core.tags.TagRWLong;
import promauto.jroboplc.core.tags.TagRWString;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;
import promauto.utils.Numbers;

public class ModbusTag {
    public String name = "";
    public String tracktagName = "";
    public Type type = Type.UINT16;
    public Region region = Region.HLDREG;
    public Access access = Access.RW;
    public boolean inverted = false;
    public int address = 0;
    public int size = 1;
    public boolean littleEndian = false;
    public boolean readEnd = false;
    public boolean readOnce = false;
    public boolean writeSingle = true;
    public boolean writeMultiple = true;
    public boolean enable = true;
    public boolean bitNameOnly = false;
    public TagRW tag;
    public ModbusTag tracktag;
    public boolean needWrite;

    public static ModbusTag create(String name, int address) {
        return new ModbusTag().name(name).address(address);
    }

    public ModbusTag name(String name) {
        this.name = name;
        return this;
    }

    public ModbusTag type(Type type) {
        this.type = type;
        return this;
    }

    public ModbusTag inverted(boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    public ModbusTag region(Region region) {
        this.region = region;
        return this;
    }

    public ModbusTag access(Access access) {
        this.access = access;
        return this;
    }

    public ModbusTag address(int address) {
        this.address = address;
        return this;
    }

    public ModbusTag littleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
        return this;
    }

    public ModbusTag readEnd(boolean readEnd) {
        this.readEnd = readEnd;
        return this;
    }

    public ModbusTag writeSingle(boolean writeSingle) {
        this.writeSingle = writeSingle;
        return this;
    }

    public ModbusTag writeMultiple(boolean writeMultiple) {
        this.writeMultiple = writeMultiple;
        return this;
    }

    public ModbusTag enable(boolean enable) {
        this.enable = enable;
        return this;
    }

    public ModbusTag size(int size) {
        this.size = size;
        return this;
    }

    public ModbusTag trackName(String tracktagName) {
        this.tracktagName = tracktagName;
        return this;
    }

    public boolean isWriteOnly() {
        return this.access == Access.WO;
    }

    public void init() {
        if (this.region == Region.DSCINP || this.region == Region.INPREG || this.type == Type.STRING) {
            this.access = Access.RO;
        }
        if (this.region == Region.COIL || this.region == Region.DSCINP) {
            this.type = Type.BOOL;
            this.size = 1;
        } else {
            switch (this.type) {
                case BOOL: 
                case INT16: 
                case UINT16: 
                case FLOAT16: {
                    this.size = 1;
                    break;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    this.size = 2;
                    break;
                }
                case STRING: {
                    this.size = Math.max(this.size, 1);
                }
            }
        }
        switch (this.type) {
            case BOOL: {
                this.tag = new TagRWBool(this.name, false, 8);
                break;
            }
            case INT16: 
            case UINT16: 
            case INT32: {
                this.tag = new TagRWInt(this.name, 0, 8);
                break;
            }
            case UINT32: {
                this.tag = new TagRWLong(this.name, 0L, 8);
                break;
            }
            case FLOAT16: 
            case FLOAT32: {
                this.tag = new TagRWDouble(this.name, 0.0, 8);
                break;
            }
            case STRING: {
                this.tag = new TagRWString(this.name, "", 8);
            }
        }
    }

    public void putValueIntoBuff(int[] buff, int pos) {
        switch (this.type) {
            case BOOL: {
                buff[pos] = this.tag.getWriteValBool() ^ this.inverted ? 1 : 0;
                break;
            }
            case INT16: 
            case UINT16: {
                buff[pos] = this.tag.getWriteValInt() & 0xFFFF;
                break;
            }
            case INT32: 
            case UINT32: {
                long l = (long)this.tag.getWriteValInt() & 0xFFFFFFFFL;
                if (this.littleEndian) {
                    buff[pos + 1] = (int)(l >> 16);
                    buff[pos] = (int)(l & 0xFFFFL);
                    break;
                }
                buff[pos] = (int)(l >> 16);
                buff[pos + 1] = (int)(l & 0xFFFFL);
                break;
            }
            case FLOAT16: {
                buff[pos] = Numbers.encodeFloat16((float)this.tag.getWriteValDouble());
                break;
            }
            case FLOAT32: {
                long l = (long)Numbers.encodeFloat32((float)this.tag.getWriteValDouble()) & 0xFFFFFFFFL;
                if (this.littleEndian) {
                    buff[pos + 1] = (int)(l >> 16);
                    buff[pos] = (int)(l & 0xFFFFL);
                    break;
                }
                buff[pos] = (int)(l >> 16);
                buff[pos + 1] = (int)(l & 0xFFFFL);
                break;
            }
        }
    }

    public void fetchValueFromProtocolBuffin(ProtocolModbus protocol, int pos) {
        switch (this.type) {
            case BOOL: {
                this.tag.setReadValBool(protocol.getAnswerWord(pos) != 0 ^ this.inverted);
                break;
            }
            case INT16: {
                this.tag.setReadValInt((short)protocol.getAnswerWord(pos));
                break;
            }
            case UINT16: {
                this.tag.setReadValInt(protocol.getAnswerWord(pos));
                break;
            }
            case INT32: {
                this.tag.setReadValInt(protocol.getAnswerInt32(pos, this.littleEndian));
                break;
            }
            case UINT32: {
                this.tag.setReadValLong((long)protocol.getAnswerInt32(pos, this.littleEndian) & 0xFFFFFFFFL);
                break;
            }
            case FLOAT16: {
                this.tag.setReadValDouble(Numbers.decodeFloat16(protocol.getAnswerWord(pos)));
                break;
            }
            case FLOAT32: {
                this.tag.setReadValDouble(Numbers.decodeFloat32(protocol.getAnswerInt32(pos, this.littleEndian)));
                break;
            }
            case STRING: {
                this.tag.setReadValString(protocol.getAnswerString(pos, this.size));
            }
        }
    }

    public static enum Region {
        COIL,
        DSCINP,
        HLDREG,
        INPREG;

    }

    public static enum Access {
        RO,
        WO,
        RW;

    }

    public static enum Type {
        BOOL,
        INT16,
        UINT16,
        INT32,
        UINT32,
        FLOAT16,
        FLOAT32,
        STRING;

    }
}

