/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.SQLException;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.raduga.Context;
import promauto.jroboplc.plugin.raduga.DataService;
import promauto.jroboplc.plugin.raduga.Doser;
import promauto.jroboplc.plugin.raduga.Line;
import promauto.jroboplc.plugin.raduga.Periods;
import promauto.jroboplc.plugin.raduga.Task;

public class Dispenser {
    private final Logger logger = LoggerFactory.getLogger(Doser.class);
    private final Context ctx;
    public final Line line;
    private int id;
    private String name;
    private String descr;
    protected TagRW tagDescr;
    protected TagRW tagProductId;
    protected TagRW tagProductName;
    protected TagRW tagPercentage;
    protected TagRW tagSumWeight;
    private int lastSaveTime;

    public Dispenser(Context ctx, Line line) {
        this.ctx = ctx;
        this.line = line;
        this.lastSaveTime = this.getSaveTime();
    }

    private int getSaveTime() {
        return LocalDateTime.now().getSecond();
    }

    public boolean load(Object conf) {
        Configuration cm = this.ctx.env.getConfiguration();
        cm.toMap(conf).forEach((k, v) -> {
            this.name = k;
            this.descr = (String)v;
        });
        TagTable tt = this.ctx.tagtable;
        Tag[] tagArray = new Tag[4];
        this.tagProductId = tt.createRWInt(this.makeTagName("ProductId"), 0);
        tagArray[0] = this.tagProductId;
        this.tagProductName = tt.createRWString(this.makeTagName("ProductName"), "");
        tagArray[1] = this.tagProductName;
        this.tagSumWeight = tt.createRWLong(this.makeTagName("SumWeight"), 0L);
        tagArray[2] = this.tagSumWeight;
        this.tagPercentage = tt.createRWInt(this.makeTagName("Percentage"), 0);
        tagArray[3] = this.tagPercentage;
        this.ctx.addRepoTags(tagArray);
        this.tagDescr = tt.createRWString(this.makeTagName("Descr"), "");
        return true;
    }

    private String makeTagName(String tagname) {
        return "dsp." + this.line.makeTagName(this.name + '_' + tagname);
    }

    public void init() throws SQLException {
        this.id = this.ctx.service.syncDispenser(this.line.getId(), this.name, this.descr);
    }

    public int getId() {
        return this.id;
    }

    public void reset() {
        this.tagProductId.setReadValInt(0);
        this.tagProductName.setReadValString("");
        this.tagPercentage.setReadValInt(0);
    }

    public String getName() {
        return this.name;
    }

    public boolean isInUse() {
        return this.tagProductId.getInt() > 0;
    }

    public void installTask(Task task) {
        this.reset();
        for (Task.Dispenser td : task.dispensers) {
            if (!td.dispenserName.equals(this.name)) continue;
            this.tagProductId.setReadValInt(td.productId);
            this.tagProductName.setReadValString(td.productName);
            this.tagPercentage.setReadValInt(td.percentage);
            break;
        }
    }

    public void execute() throws SQLException {
        if (this.lastSaveTime == this.getSaveTime()) {
            return;
        }
        this.lastSaveTime = this.getSaveTime();
        if (!this.tagSumWeight.hasWriteValue()) {
            return;
        }
        long weightBeg = this.tagSumWeight.getLong();
        long weightEnd = this.tagSumWeight.getWriteValLong();
        this.tagSumWeight.setReadValLong(weightEnd);
        long weight = weightEnd - weightBeg;
        if (weight == 0L) {
            return;
        }
        if (weight < 0L) {
            weight = 0L;
        }
        DataService svc = this.ctx.service;
        Task.ExecDsp te = new Task.ExecDsp();
        te.dt = this.ctx.now();
        te.periodShift = this.ctx.periods.calcPeriodShift(te.dt);
        te.periodHour = Periods.calcPeriodHour(te.dt);
        te.dispenserId = this.id;
        te.lineId = this.line.getId();
        te.taskId = this.line.getTaskId();
        te.recipeId = this.line.getRecipeId();
        te.inputProductId = this.tagProductId.getInt();
        te.outputProductId = this.line.getDstProductId();
        te.weight = weight;
        te.sumWeightBeg = weightBeg;
        te.sumWeightEnd = weightEnd;
        svc.saveTaskExecDsp(te);
    }
}

