/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.redisexp;

import promauto.jroboplc.plugin.redisexp.TagInfo;

public class TagInfoCodec {
    public static final String CHANNEL_UPDATE = "update";
    public static final String CHANNEL_DELETE = "delete";
    public static final String CHANNEL_WRITE = "write";
    public static final String CHANNEL_RESET = "reset";
    public static final String TAGS_KEY = "tags";
    public static final String SERVER_TIME_KEY = "server.time";
    private static final long MAX_HEX_DIGITS_11 = 0xFFFFFFFFFFFL;

    public static String encodeName(String name) {
        return String.format("%02X%s", name.length(), name);
    }

    public static String encodeData(String value, long time, char type, boolean good) {
        return String.format(good ? "=%c%011X %s" : "!%c%011X %s", Character.valueOf(type), time & 0xFFFFFFFFFFFL, value);
    }

    public static long decodeTimeFromData(String data) {
        try {
            return Long.parseLong(data.substring(2, 13), 16);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static String encodeMessageUpdate(String encodedName, String encodedData) {
        return encodedName + encodedData;
    }

    public static TagInfo decodeMessageUpdate(String message) {
        try {
            int nlen = TagInfoCodec.hexFirstByte(message);
            TagInfo result = new TagInfo();
            result.name = message.substring(2, nlen + 2);
            result.data = message.substring(nlen + 2);
            result.good = message.charAt(nlen + 2) != '!';
            result.type = message.charAt(nlen + 3);
            result.time = Long.parseLong(message.substring(nlen + 4, nlen + 15), 16);
            result.value = message.substring(nlen + 16);
            return result;
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }

    public static String encodeMessageDelete(String name, long time) {
        return String.format("%011X %s", time & 0xFFFFFFFFFFFL, name);
    }

    public static TagInfo decodeMessageDelete(String message) {
        try {
            TagInfo result = new TagInfo();
            result.time = Long.parseLong(message.substring(0, 11), 16);
            result.name = message.substring(12);
            return result;
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }

    public static String encodeMessageWrite(String name, String value) {
        return String.format("%02X%s %s", name.length(), name, value);
    }

    public static TagInfo decodeMessageWrite(String message) {
        try {
            int nlen = TagInfoCodec.hexFirstByte(message);
            TagInfo result = new TagInfo();
            result.name = message.substring(2, nlen + 2);
            result.value = message.substring(nlen + 3);
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static int hexFirstByte(String s) {
        return (TagInfoCodec.hexDigit(s.charAt(0)) << 4) + TagInfoCodec.hexDigit(s.charAt(1));
    }

    private static int hexDigit(char digit) {
        if (digit > '0' && digit < ':') {
            return digit - 48;
        }
        if (digit > '@' && digit < 'G') {
            return digit - 55;
        }
        if (digit > '`' && digit < 'g') {
            return digit - 87;
        }
        return 0;
    }
}

