/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.DeviceZCTAItem;
import promauto.jroboplc.plugin.roboplant.Input;
import promauto.jroboplc.plugin.roboplant.Output;

public class DeviceZCTA
extends Device {
    public static final int MARKER_END = 65535;
    public static final int ZCTA_SIZE = 100;
    Input inpStart;
    Input inpStop;
    Tag tagSost;
    Tag tagAlarm;
    Tag tagStopFlow;
    Tag tagStopRout;
    Tag tagStepSize;
    Tag tagStepTime;
    Tag tagDlyAlarm;
    Tag tagDlyStopFlow;
    Tag tagDlyStopRout;
    Tag tagCode;
    Tag tagEnable;
    DeviceZCTAItem[] zdv;
    int cntAlarm;
    int cntStopFlow;
    int cntStopRout;
    int stepCnt;
    int current;
    int sost;
    boolean alarm;
    boolean stopFlow;
    boolean stopRout;
    int getZdvDly_cnt = 0;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpStart = this.getInput("Start", res);
        this.inpStop = this.getInput("Stop", res);
        this.tagSost = this.getOutputTag("Sost", res);
        this.tagAlarm = this.getOutputTag("Alarm", res);
        this.tagStopFlow = this.getOutputTag("StopFlow", res);
        this.tagStopRout = this.getOutputTag("StopRout", res);
        this.tagStepSize = this.getOutputTag("StepSize", res);
        this.tagStepTime = this.getOutputTag("StepTime", res);
        this.tagDlyAlarm = this.getOutputTag("DlyAlarm", res);
        this.tagDlyStopFlow = this.getOutputTag("DlyStopFlow", res);
        this.tagDlyStopRout = this.getOutputTag("DlyStopRout", res);
        this.tagCode = this.getOutputTag("Code", res);
        this.tagEnable = this.getOutputTag("Enable", res);
        this.initZdv();
        for (int i = 0; i < 100; ++i) {
            this.zdv[i].tagAddress = this.getOutputTag("Address" + i, res);
            this.zdv[i].tagMode = this.getOutputTag("Mode" + i, res);
        }
        if (res.value) {
            this.resetState();
        }
    }

    void initZdv() {
        this.zdv = new DeviceZCTAItem[100];
        for (int i = 0; i < 100; ++i) {
            this.zdv[i] = new DeviceZCTAItem();
        }
    }

    protected void resetState() {
        this.tagSost.setInt(0);
        this.tagAlarm.setInt(0);
        this.tagStopFlow.setInt(0);
        this.tagStopRout.setInt(0);
        this.cntAlarm = 0;
        this.cntStopFlow = 0;
        this.cntStopRout = 0;
        this.stepCnt = 0;
        this.current = 0;
        this.sost = 0;
        this.alarm = false;
        this.stopFlow = false;
        this.stopRout = false;
    }

    protected void linkZdvItems() {
        for (int i = 0; i < 100; ++i) {
            int addr = this.zdv[i].tagAddress.getInt();
            if (addr == 65535) {
                if (this.current <= i) break;
                for (int j = i; j < this.current; ++j) {
                    this.setZdvControl(j, 0);
                    this.zdv[j].address = -1;
                    this.zdv[j].reset();
                }
                this.current = i;
                break;
            }
            if (this.zdv[i].address == addr) continue;
            this.zdv[i].address = addr;
            this.zdv[i].reset();
            Device d = this.module.getDevice(addr);
            if (d == null) continue;
            Output output = d.getOutput("Output");
            if (output != null) {
                this.zdv[i].setOutput(output.tag);
            }
            if ((output = d.getOutput("Control")) == null) continue;
            this.zdv[i].setControl(output.tag);
        }
    }

    @Override
    public boolean execute() {
        int i;
        this.linkZdvItems();
        boolean _ok = false;
        boolean _alarm = false;
        boolean _stopflow = false;
        boolean _stoprout = false;
        boolean enable = this.tagEnable.getBool();
        if (this.sost > 0 && this.inpStop.getInt() > 0) {
            this.sost = 0;
            for (i = 0; i < this.current; ++i) {
                this.setZdvControl(i, 0);
            }
        }
        if (this.sost == 0) {
            this.alarm = false;
            if (enable) {
                this.stopFlow = true;
                this.stopRout = true;
            } else {
                this.stopFlow = false;
                this.stopRout = false;
            }
            if (this.inpStart.getInt() > 0 && enable && this.tagCode.getInt() > 0) {
                this.cntAlarm = 0;
                this.cntStopFlow = 0;
                this.cntStopRout = 0;
                this.stepCnt = 0;
                this.current = 0;
                this.sost = 2;
            }
        }
        if (this.sost > 0) {
            _alarm = false;
            _stopflow = false;
            _stoprout = false;
            _ok = true;
            for (i = 0; i < this.current; ++i) {
                if (this.getZdvControl(i) != (this.zdv[i].tagMode.getInt() & 0xF)) {
                    this.setZdvControl(i, this.zdv[i].tagMode.getInt() & 0xF);
                }
                if (this.getZdvOutput(i)) continue;
                if ((this.zdv[i].tagMode.getInt() & 0x100) > 0) {
                    _alarm = true;
                }
                if ((this.zdv[i].tagMode.getInt() & 0x200) > 0) {
                    _stopflow = true;
                }
                if ((this.zdv[i].tagMode.getInt() & 0x400) > 0) {
                    _stoprout = true;
                }
                _ok = false;
            }
        }
        if (this.sost == 1 || this.sost == 4) {
            this.alarm = this.getZdvDly(_alarm, this.tagDlyAlarm.getInt(), this.cntAlarm);
            this.cntAlarm = this.getZdvDly_cnt;
            this.stopFlow = this.getZdvDly(_stopflow, this.tagDlyStopFlow.getInt(), this.cntStopFlow);
            this.cntStopFlow = this.getZdvDly_cnt;
            this.stopRout = this.getZdvDly(_stoprout, this.tagDlyStopRout.getInt(), this.cntStopRout);
            this.cntStopRout = this.getZdvDly_cnt;
            this.sost = _ok ? 1 : 4;
        }
        if (this.sost == 2) {
            if (this.stepCnt == 0) {
                int n = this.current + this.tagStepSize.getInt();
                for (i = this.current; i < n; ++i) {
                    if (i >= 100 || this.zdv[i].tagAddress.getInt() == 65535 || (this.zdv[i].tagMode.getInt() & 0xF0) == 0) {
                        this.sost = 3;
                        break;
                    }
                    this.setZdvControl(i, this.zdv[i].tagMode.getInt() & 0xF);
                }
                this.current = i;
                this.stepCnt = this.tagStepTime.getInt();
            } else {
                --this.stepCnt;
            }
        }
        if (this.sost == 3 && _ok) {
            this.sost = 1;
        }
        this.tagSost.setInt(this.sost);
        this.tagAlarm.setBool(this.alarm);
        this.tagStopFlow.setBool(this.stopFlow);
        this.tagStopRout.setBool(this.stopRout);
        return true;
    }

    protected boolean getZdvDly(boolean v, int dly, int cnt) {
        this.getZdvDly_cnt = cnt;
        if (!this.tagEnable.getBool()) {
            return false;
        }
        if (v) {
            if (this.getZdvDly_cnt < dly) {
                ++this.getZdvDly_cnt;
                v = false;
            }
        } else {
            this.getZdvDly_cnt = 0;
        }
        return v;
    }

    protected boolean getZdvOutput(int idx) {
        return this.zdv[idx].getOutputValue() > 0 || (this.zdv[idx].tagMode.getInt() & 0xF) == 0;
    }

    protected void setZdvControl(int idx, int value) {
        int zdv_type = (this.zdv[idx].tagMode.getInt() & 0xF0) >> 4;
        int v = 0;
        int m = 0;
        if (zdv_type == 1) {
            m = 65295;
            v = value == 1 ? 32 : (value == 2 ? 48 : 0);
        } else if (zdv_type == 2) {
            m = 255;
            v = value;
            v <<= 8;
        }
        v = (this.zdv[idx].getControlValue() & m) + v;
        this.zdv[idx].setControlValue(v);
        this.zdv[idx].state = value;
    }

    protected int getZdvControl(int idx) {
        int zdv_type = (this.zdv[idx].tagMode.getInt() & 0xF0) >> 4;
        int v = 0;
        if (zdv_type == 1) {
            v = this.zdv[idx].getControlValue() >> 4;
        } else if (zdv_type == 2) {
            v = this.zdv[idx].getControlValue() >> 8;
        }
        return v;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("cntAlarm", this.cntAlarm);
        state.saveVar("cntStopFlow", this.cntStopFlow);
        state.saveVar("cntStopRout", this.cntStopRout);
        state.saveVar("stepCnt", this.stepCnt);
        state.saveVar("current", this.current);
        state.saveVar("sost", this.sost);
        state.saveVar("alarm", this.alarm);
        state.saveVar("stopFlow", this.stopFlow);
        state.saveVar("stopRout", this.stopRout);
        for (int i = 0; i < 100; ++i) {
            state.saveVar("state_" + i, this.zdv[i].state);
            state.saveVar("address_" + i, this.zdv[i].address);
        }
    }

    @Override
    public void loadStateExtra(State state) {
        this.cntAlarm = state.loadVar("cntAlarm", this.cntAlarm);
        this.cntStopFlow = state.loadVar("cntStopFlow", this.cntStopFlow);
        this.cntStopRout = state.loadVar("cntStopRout", this.cntStopRout);
        this.stepCnt = state.loadVar("stepCnt", this.stepCnt);
        this.current = state.loadVar("current", this.current);
        this.sost = state.loadVar("sost", this.sost);
        this.alarm = state.loadVar("alarm", this.alarm);
        this.stopFlow = state.loadVar("stopFlow", this.stopFlow);
        this.stopRout = state.loadVar("stopRout", this.stopRout);
        for (int i = 0; i < 100; ++i) {
            this.zdv[i].state = state.loadVar("state_" + i, this.zdv[i].state);
        }
    }
}

