/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.arcsvr;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.api.Task;
import promauto.jroboplc.plugin.arcsvr.ArcsvrModule;
import promauto.jroboplc.plugin.arcsvr.ArcvalHolder;
import promauto.utils.ParamsMap;

public abstract class ArcvalBase {
    private final Logger logger = LoggerFactory.getLogger(ArcvalBase.class);
    private static final long REC_MAX = Long.MAX_VALUE;
    protected final ArcsvrModule module;
    protected final ArcvalHolder holder;
    protected String arcname;
    protected Environment env;
    protected int idarc;
    protected String descr;
    protected int period_ms;
    protected int arcsize;
    protected long currec;
    protected int timemax;
    protected int timecnt;
    protected boolean period_align;
    protected long lastpass_ms;
    protected FieldType ftype;
    protected int ftypeSql;
    protected String ftypeStr = "";
    protected PreparedStatement pstInsert = null;
    protected PreparedStatement pstDelete = null;
    protected SqlExceptionBiConsumer<Integer, Tag> setPstInsertFunc;

    public ArcvalBase(ArcvalHolder arcvalHolder, String arcname) {
        this.module = arcvalHolder.module;
        this.holder = arcvalHolder;
        this.arcname = arcname;
        this.env = EnvironmentInst.get();
    }

    public abstract void link();

    public boolean init() {
        this.timemax = this.calcTaskTimes(this.period_ms);
        this.timecnt = 0;
        switch (this.ftype) {
            case INT16: {
                this.ftypeSql = 5;
                this.ftypeStr = "SMALLINT";
                this.setPstInsertFunc = (index, tag) -> this.pstInsert.setShort((int)index, (short)tag.getInt());
                break;
            }
            case INT32: {
                this.ftypeSql = 4;
                this.ftypeStr = "INTEGER";
                this.setPstInsertFunc = (index, tag) -> this.pstInsert.setInt((int)index, tag.getInt());
                break;
            }
            case INT64: {
                this.ftypeSql = -5;
                this.ftypeStr = "BIGINT";
                this.setPstInsertFunc = (index, tag) -> this.pstInsert.setLong((int)index, tag.getLong());
                break;
            }
            case FLOAT: {
                this.ftypeSql = 6;
                this.ftypeStr = "FLOAT";
                this.setPstInsertFunc = (index, tag) -> this.pstInsert.setFloat((int)index, (float)tag.getDouble());
                break;
            }
            case DOUBLE: {
                this.ftypeSql = 8;
                this.ftypeStr = "DOUBLE PRECISION";
                this.setPstInsertFunc = (index, tag) -> this.pstInsert.setDouble((int)index, tag.getDouble());
            }
        }
        return true;
    }

    protected final int calcTaskTimes(int ms) {
        Task task = this.env.getTaskManager().getTask(this.module);
        return task == null || task.getPeriod() == 0 ? 0 : ms / task.getPeriod();
    }

    protected boolean hasExecTimeCome(long curms) {
        if (this.period_align) {
            long ms = curms - this.lastpass_ms;
            if (ms < (long)this.period_ms) {
                return false;
            }
            this.lastpass_ms += (long)(this.period_ms * (int)(ms / (long)this.period_ms));
        } else {
            if (++this.timecnt < this.timemax) {
                return false;
            }
            this.timecnt = 0;
        }
        return true;
    }

    protected void initArc(Statement st) throws SQLException {
        String sql = String.format("select idarc, period, reccnt, descr from %s where arcname='%s'", this.module.makeTableName("arclist"), this.module.makeTableName(this.arcname));
        try (ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                this.idarc = rs.getInt(1);
                if (this.period_ms != rs.getInt(2) || this.arcsize != rs.getInt(3) || !this.descr.equals(rs.getString(4))) {
                    this.updateArclistRec(st);
                }
            } else {
                this.insertArclistRec(st);
            }
        }
    }

    protected void insertArclistRec(Statement st) throws SQLException {
        String sql = String.format("insert into %s (arcname, period, reccnt, descr) values ('%s', %d, %d, '%s')", this.module.makeTableName("arclist"), this.module.makeTableName(this.arcname), this.period_ms, this.arcsize, this.descr);
        this.idarc = this.module.getDatabase().insertReturningId(st, sql, "idarc");
        this.env.logInfo(this.logger, this.module.getName(), this.arcname, "Add archive: " + this.idarc);
    }

    protected void updateArclistRec(Statement st) throws SQLException {
        String sql = String.format("update %s set arcname='%s', period=%d, reccnt=%d, descr='%s' where idarc=%d", this.module.makeTableName("arclist"), this.module.makeTableName(this.arcname), this.period_ms, this.arcsize, this.descr, this.idarc);
        this.env.logInfo(this.logger, this.module.getName(), this.arcname, "Update archive: " + this.idarc);
        st.executeUpdate(sql);
    }

    protected Map<String, DescrTagid> getTaglistMap(Statement st) throws SQLException {
        String sql = String.format("select idtag, tagname, descr from %s where idarc=%d", this.module.makeTableName("taglist"), this.idarc);
        HashMap<String, DescrTagid> map = new HashMap<String, DescrTagid>();
        try (ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                DescrTagid dti = new DescrTagid();
                dti.descr = rs.getString(3);
                dti.tagid = rs.getInt(1);
                map.put(rs.getString(2), dti);
            }
        }
        return map;
    }

    protected int createTaglistRec(Statement st, String tagname, String descr) throws SQLException {
        String sql = String.format("insert into %s (idarc, tagname, descr) values (%d, '%s', '%s')", this.module.makeTableName("taglist"), this.idarc, tagname, descr);
        int idtag = this.module.getDatabase().insertReturningId(st, sql, "idtag");
        this.env.logInfo(this.logger, this.module.getName(), this.arcname, "Add tag: " + idtag, tagname);
        return idtag;
    }

    protected void updateTaglistRec(Statement st, int idtag, String descr) throws SQLException {
        String sql = String.format("update %s set descr='%s' where idtag=%d", this.module.makeTableName("taglist"), descr, idtag);
        st.executeUpdate(sql);
        this.env.logInfo(this.logger, this.module.getName(), this.arcname, "Update tag: " + idtag, descr);
    }

    protected void deleteTaglistRec(Statement st, int idtag, String tagname) throws SQLException {
        String sql = String.format("delete from %s where idtag=%d", this.module.makeTableName("taglist"), idtag);
        st.executeUpdate(sql);
        this.env.logInfo(this.logger, this.module.getName(), this.arcname, "Delete tag: " + idtag, tagname);
    }

    protected void initArctable(Statement st, List<Integer> idtags) throws Exception {
        Database db = this.module.getDatabase();
        ParamsMap params = new ParamsMap("schema=" + this.module.getSchema(), "table=" + this.arcname);
        if (!db.executeScript((String)"arcsvr_arcval_arctable", (Map<String, String>)params).success) {
            throw new Exception("Arctable create error: " + this.arcname);
        }
        List<Integer> delfields = new LinkedList<Integer>();
        HashSet<Integer> oldfields = new HashSet<Integer>();
        String sql = String.format("select first 0 * from %s", this.module.makeTableName(this.arcname));
        try (ResultSet rs = st.executeQuery(sql);){
            ResultSetMetaData md = rs.getMetaData();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                String field = md.getColumnName(i);
                if (!field.startsWith("T")) continue;
                int idtag2 = Integer.parseInt(field.substring(1));
                if (md.getColumnType(i) == this.ftypeSql) {
                    oldfields.add(idtag2);
                    continue;
                }
                delfields.add(idtag2);
            }
        }
        this.alterTable(st, "drop", delfields);
        List<Integer> addfields = idtags.stream().filter(idtag -> !oldfields.contains(idtag)).collect(Collectors.toList());
        Collections.sort(addfields);
        delfields = oldfields.stream().filter(idtag -> !idtags.contains(idtag)).collect(Collectors.toList());
        this.alterTable(st, "drop", delfields);
        this.alterTable(st, "add", addfields);
    }

    private void alterTable(Statement st, String cmd, List<Integer> fields) throws SQLException {
        if (fields.size() > 0) {
            String stype = cmd.equals("add") ? " " + this.ftypeStr : "";
            String sqlfields = fields.stream().map(idtag -> cmd + " T" + idtag + stype).collect(Collectors.joining(","));
            this.env.logInfo(this.logger, this.module.getName(), this.arcname, "Alter table:", cmd, fields.stream().map(idtag -> "T" + idtag).collect(Collectors.joining(",")));
            String sql = String.format("alter table %s %s", this.module.makeTableName(this.arcname), sqlfields);
            st.executeUpdate(sql);
        }
    }

    protected void initPst(List<Integer> idtags) throws SQLException {
        this.closePreparedStatements();
        if (idtags.size() > 0) {
            String fields = idtags.stream().map(idtag -> "T" + idtag).collect(Collectors.joining(","));
            String values = String.join((CharSequence)",", Collections.nCopies(idtags.size(), "?"));
            String sql = String.format("insert into %s (%s, rec, dt) values (%s, ?, ?)", this.module.makeTableName(this.arcname), fields, values);
            Database db = this.module.getDatabase();
            this.pstInsert = db.getConnection().prepareStatement(sql);
            sql = String.format("delete from %s where rec=?", this.module.makeTableName(this.arcname));
            this.pstDelete = db.getConnection().prepareStatement(sql);
        }
    }

    protected void initCurrec(Statement st) throws SQLException {
        String sql = String.format("select first 1 rec from %s order by rec desc", this.module.makeTableName(this.arcname));
        try (ResultSet rs = st.executeQuery(sql);){
            this.currec = rs.next() ? ((this.currec = rs.getLong(1)) > 0L ? this.currec : 0L) : 0L;
        }
        sql = String.format("delete from %s where rec<=%d", this.module.makeTableName(this.arcname), this.currec - (long)this.arcsize);
        st.executeUpdate(sql);
    }

    protected void closePreparedStatements() {
        this.closePreparedStatement(this.pstInsert);
        this.closePreparedStatement(this.pstDelete);
        this.pstInsert = null;
        this.pstDelete = null;
    }

    private void closePreparedStatement(PreparedStatement pst) {
        if (pst != null) {
            try {
                pst.close();
            }
            catch (SQLException e) {
                this.env.printError(this.logger, e, new String[0]);
            }
        }
    }

    public boolean execute() throws SQLException {
        if (this.pstInsert == null || this.pstDelete == null) {
            return false;
        }
        if (++this.currec > (long)this.arcsize) {
            this.pstDelete.setLong(1, this.currec - (long)this.arcsize);
            this.pstDelete.executeUpdate();
        }
        this.setPstInsertData();
        this.pstInsert.executeUpdate();
        if (this.currec > Long.MAX_VALUE) {
            try (Statement st = this.module.getDatabase().getConnection().createStatement();){
                String sql = String.format("delete from %s where rec<=%d and rec>%d", this.module.makeTableName(this.arcname), this.currec - (long)this.arcsize, this.currec);
                st.executeUpdate(sql);
                sql = String.format("update %s set rec=rec-%d", this.module.makeTableName(this.arcname), this.currec - (long)this.arcsize, this.currec - (long)this.arcsize);
                st.executeUpdate(sql);
                this.currec = this.arcsize;
            }
        }
        return true;
    }

    public String pack() {
        return "";
    }

    protected abstract void setPstInsertData() throws SQLException;

    public abstract String getInfo();

    public abstract String getNolinks();

    @FunctionalInterface
    public static interface SqlExceptionBiConsumer<T, U> {
        public void apply(T var1, U var2) throws SQLException;
    }

    protected static class DescrTagid {
        String descr;
        int tagid;

        protected DescrTagid() {
        }
    }

    static enum FieldType {
        INT16,
        INT32,
        INT64,
        FLOAT,
        DOUBLE;

    }
}

