/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.AbstractPlugin;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.plugin.peripherial.AkkontPassModule;
import promauto.jroboplc.plugin.peripherial.BuhlerFBALModule;
import promauto.jroboplc.plugin.peripherial.CentaUrzModule;
import promauto.jroboplc.plugin.peripherial.DeltaVFDMModule;
import promauto.jroboplc.plugin.peripherial.EasyDriveED3100Module;
import promauto.jroboplc.plugin.peripherial.HygrostekDA301Module;
import promauto.jroboplc.plugin.peripherial.I7017Module;
import promauto.jroboplc.plugin.peripherial.I7024Module;
import promauto.jroboplc.plugin.peripherial.IdsDriveEczModule;
import promauto.jroboplc.plugin.peripherial.InnoVertISDModule;
import promauto.jroboplc.plugin.peripherial.KastBOT01Module;
import promauto.jroboplc.plugin.peripherial.KiprBos1Module;
import promauto.jroboplc.plugin.peripherial.Kontakt1Tur01Module;
import promauto.jroboplc.plugin.peripherial.KorennPassModule;
import promauto.jroboplc.plugin.peripherial.LsisSvIg5aModule;
import promauto.jroboplc.plugin.peripherial.LsisSvIp5aModule;
import promauto.jroboplc.plugin.peripherial.MercuryM230Module;
import promauto.jroboplc.plugin.peripherial.ModbusModule;
import promauto.jroboplc.plugin.peripherial.NotisA100Module;
import promauto.jroboplc.plugin.peripherial.OmronFinsModule;
import promauto.jroboplc.plugin.peripherial.OmronV7Module;
import promauto.jroboplc.plugin.peripherial.OwenMa110_1tModule;
import promauto.jroboplc.plugin.peripherial.OwenMu110_16rModule;
import promauto.jroboplc.plugin.peripherial.OwenMu110_8iModule;
import promauto.jroboplc.plugin.peripherial.OwenMv110_16dModule;
import promauto.jroboplc.plugin.peripherial.OwenMv110_8aModule;
import promauto.jroboplc.plugin.peripherial.OwenPVT100Module;
import promauto.jroboplc.plugin.peripherial.OwenTrm138Module;
import promauto.jroboplc.plugin.peripherial.OwenTrm200Module;
import promauto.jroboplc.plugin.peripherial.OwenTrm210Module;
import promauto.jroboplc.plugin.peripherial.OwenTrm212Module;
import promauto.jroboplc.plugin.peripherial.PaGeliosDozkkmcModule;
import promauto.jroboplc.plugin.peripherial.PaGeliosDozmanModule;
import promauto.jroboplc.plugin.peripherial.PaGeliosFlowModule;
import promauto.jroboplc.plugin.peripherial.PaGeliosMaslo2v2Module;
import promauto.jroboplc.plugin.peripherial.PaGeliosMultiPackerModule;
import promauto.jroboplc.plugin.peripherial.PaGeliosPassModule;
import promauto.jroboplc.plugin.peripherial.PaMPTModule;
import promauto.jroboplc.plugin.peripherial.PaPdatModule;
import promauto.jroboplc.plugin.peripherial.PaPdioModule;
import promauto.jroboplc.plugin.peripherial.PaPdioNbModule;
import promauto.jroboplc.plugin.peripherial.PaPdioVlvModule;
import promauto.jroboplc.plugin.peripherial.PaPrksModule;
import promauto.jroboplc.plugin.peripherial.PaRFIDReaderModule;
import promauto.jroboplc.plugin.peripherial.PaRoboModule;
import promauto.jroboplc.plugin.peripherial.PaTermo5Module;
import promauto.jroboplc.plugin.peripherial.SchneiderAtv31Module;
import promauto.jroboplc.plugin.peripherial.SchuleFlowModule;
import promauto.jroboplc.plugin.peripherial.TenzomModule;
import promauto.jroboplc.plugin.peripherial.TenzomTb09Module;
import promauto.jroboplc.plugin.peripherial.TermoMuxModule;
import promauto.jroboplc.plugin.peripherial.TvhPulsarmModule;
import promauto.jroboplc.plugin.peripherial.UpsNanoModule;
import promauto.jroboplc.plugin.peripherial.WessvrAdapterModule;

public class PeripherialPlugin
extends AbstractPlugin {
    private static final String PLUGIN_NAME = "peripherial";
    private final Logger logger = LoggerFactory.getLogger(PeripherialPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginDescription() {
        return "peripherial serial I/O devices";
    }

    @Override
    public Module createModule(String name, Object conf) {
        Module m = this.createPeripherialModule(name, conf);
        if (m != null) {
            this.modules.add(m);
        }
        return m;
    }

    public Module createPeripherialModule(String name, Object conf) {
        String modtype = this.env.getConfiguration().get(conf, "type", "");
        AbstractModule m = null;
        switch (modtype) {
            case "buhler.fbal": {
                m = new BuhlerFBALModule(this, name);
                break;
            }
            case "promauto.pdio": {
                m = new PaPdioModule(this, name);
                break;
            }
            case "promauto.pdiovlv": {
                m = new PaPdioVlvModule(this, name);
                break;
            }
            case "promauto.pdionb": {
                m = new PaPdioNbModule(this, name);
                break;
            }
            case "promauto.prks": {
                m = new PaPrksModule(this, name);
                break;
            }
            case "promauto.pdat": {
                m = new PaPdatModule(this, name);
                break;
            }
            case "promauto.gelios.pass": {
                m = new PaGeliosPassModule(this, name);
                break;
            }
            case "promauto.gelios.flow": {
                m = new PaGeliosFlowModule(this, name);
                break;
            }
            case "promauto.gelios.maslo2v2": {
                m = new PaGeliosMaslo2v2Module(this, name);
                break;
            }
            case "promauto.gelios.dozkkmc": {
                m = new PaGeliosDozkkmcModule(this, name);
                break;
            }
            case "promauto.gelios.dozman": {
                m = new PaGeliosDozmanModule(this, name);
                break;
            }
            case "promauto.gelios.multipacker": {
                m = new PaGeliosMultiPackerModule(this, name);
                break;
            }
            case "promauto.termo5": {
                m = new PaTermo5Module(this, name);
                break;
            }
            case "promauto.robo": {
                m = new PaRoboModule(this, name);
                break;
            }
            case "promauto.rfidreader": {
                m = new PaRFIDReaderModule(this, name);
                break;
            }
            case "promauto.mpt": {
                m = new PaMPTModule(this, name);
                break;
            }
            case "promauto.upsnano": {
                m = new UpsNanoModule(this, name);
                break;
            }
            case "hygrostek.da301": {
                m = new HygrostekDA301Module(this, name);
                break;
            }
            case "icpcon.i7017": {
                m = new I7017Module(this, name);
                break;
            }
            case "icpcon.i7024": {
                m = new I7024Module(this, name);
                break;
            }
            case "owen.trm200": {
                m = new OwenTrm200Module(this, name);
                break;
            }
            case "owen.trm210": {
                m = new OwenTrm210Module(this, name);
                break;
            }
            case "owen.trm212": {
                m = new OwenTrm212Module(this, name);
                break;
            }
            case "owen.trm138": {
                m = new OwenTrm138Module(this, name);
                break;
            }
            case "owen.ma110-1t": {
                m = new OwenMa110_1tModule(this, name);
                break;
            }
            case "owen.mu110-8i": {
                m = new OwenMu110_8iModule(this, name);
                break;
            }
            case "owen.mu110-16r": {
                m = new OwenMu110_16rModule(this, name);
                break;
            }
            case "owen.mv110-8a": {
                m = new OwenMv110_8aModule(this, name);
                break;
            }
            case "owen.mv110-16d": {
                m = new OwenMv110_16dModule(this, name);
                break;
            }
            case "omron.v7": {
                m = new OmronV7Module(this, name);
                break;
            }
            case "schule.flow": {
                m = new SchuleFlowModule(this, name);
                break;
            }
            case "notis.a100": {
                m = new NotisA100Module(this, name);
                break;
            }
            case "schneider.atv31": {
                m = new SchneiderAtv31Module(this, name);
                break;
            }
            case "innovert.isd": {
                m = new InnoVertISDModule(this, name);
                break;
            }
            case "modbus.ig5": 
            case "lsis.sv-ig5a": {
                m = new LsisSvIg5aModule(this, name);
                break;
            }
            case "delta.vfdm": {
                m = new DeltaVFDMModule(this, name);
                break;
            }
            case "modbus": {
                m = new ModbusModule(this, name);
                break;
            }
            case "idsdrive.ecz": {
                m = new IdsDriveEczModule(this, name);
                break;
            }
            case "mercury.m230": {
                m = new MercuryM230Module(this, name);
                break;
            }
            case "kontakt1.tur01": {
                m = new Kontakt1Tur01Module(this, name);
                break;
            }
            case "tenzom.tb09": {
                m = new TenzomTb09Module(this, name);
                break;
            }
            case "tenzom": {
                m = new TenzomModule(this, name);
                break;
            }
            case "omron.fins": {
                m = new OmronFinsModule(this, name);
                break;
            }
            case "wessvr.adapter": {
                m = new WessvrAdapterModule(this, name);
                break;
            }
            case "akkont.pass": {
                m = new AkkontPassModule(this, name);
                break;
            }
            case "termo.mux": {
                m = new TermoMuxModule(this, name);
                break;
            }
            case "korenn.pass": {
                m = new KorennPassModule(this, name);
                break;
            }
            case "owen.pvt100": {
                m = new OwenPVT100Module(this, name);
                break;
            }
            case "kast.bot01": {
                m = new KastBOT01Module(this, name);
                break;
            }
            case "lsis.sv-ip5a": {
                m = new LsisSvIp5aModule(this, name);
                break;
            }
            case "tvh.pulsarm": {
                m = new TvhPulsarmModule(this, name);
                break;
            }
            case "centa.urz": {
                m = new CentaUrzModule(this, name);
                break;
            }
            case "easydrive.ed3100": {
                m = new EasyDriveED3100Module(this, name);
                break;
            }
            case "kipr.bos1": {
                m = new KiprBos1Module(this, name);
                break;
            }
            default: {
                this.env.printError(this.logger, name, "Unknown module type:", modtype);
                return null;
            }
        }
        if (!m.load(conf)) {
            return null;
        }
        return m;
    }
}

