/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.raduga.Context;
import promauto.jroboplc.plugin.raduga.Line;

public class Param {
    private final Logger logger = LoggerFactory.getLogger(Param.class);
    public final Context ctx;
    public final Line line;
    private int id;
    private String name;
    private String descr;
    private Tag tag;

    public Param(Context ctx, Line line, String name) {
        this.ctx = ctx;
        this.line = line;
        this.name = name;
    }

    public boolean load(Object conf) {
        Tag.Type valtype;
        Configuration cm = this.ctx.env.getConfiguration();
        this.descr = cm.get(conf, "descr", "");
        String valtypeStr = cm.get(conf, "valtype", "int");
        try {
            valtype = Tag.Type.valueOf(valtypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.ctx.env.printError(this.logger, this.ctx.moduleName, this.line.getName(), this.name, "Bad param type:", valtypeStr);
            return false;
        }
        this.tag = this.ctx.tagtable.createTag(valtype, "prm." + this.line.makeTagName(this.name));
        this.ctx.addRepoTags(this.tag);
        return true;
    }

    public void init() throws SQLException {
        this.id = this.ctx.service.syncParam(this.name, this.descr, this.tag.getType().toString());
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String val) {
        this.tag.setString(val);
    }

    public void reset() {
        this.setValue("");
    }
}

