/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.DeviceSimpleLogic;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceALM
extends DeviceSimpleLogic {
    Input inpReset;
    int[] values;
    int inpAmount;

    @Override
    public void prepareTags(Device.RefBool res) {
        super.prepareTags(res);
        this.inpReset = this.getInput("Reset", res);
        this.inpAmount = this.inpInput.size();
        this.values = new int[this.inpAmount];
    }

    @Override
    protected void resetState() {
        super.resetState();
        for (int i = 0; i < this.inpAmount; ++i) {
            this.values[i] = 0;
        }
    }

    @Override
    public boolean execute() {
        if (this.inpAmount == 0) {
            return true;
        }
        int output = 0;
        for (int i = 0; i < this.inpAmount; ++i) {
            int value = ((Input)this.inpInput.get(i)).getInt();
            if (this.inpReset.getInt() > 0) {
                this.values[i] = value;
                continue;
            }
            if (value > 0 && this.values[i] == 0) {
                output = 1;
            }
            if (value != 0 || this.values[i] <= 0) continue;
            this.values[i] = 0;
        }
        this.tagOutput.setInt(output);
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        for (int i = 0; i < this.inpAmount; ++i) {
            state.saveVar(((Input)this.inpInput.get((int)i)).tag.getName() + "_value", this.values[i]);
        }
    }

    @Override
    public void loadStateExtra(State state) {
        for (int i = 0; i < this.inpAmount; ++i) {
            String s = ((Input)this.inpInput.get((int)i)).tag.getName() + "_value";
            if (!state.hasVar(s)) continue;
            this.values[i] = state.loadVar(s, this.values[i]);
        }
    }
}

