/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.DeviceSEQCItem;
import promauto.jroboplc.plugin.roboplant.Input;
import promauto.jroboplc.plugin.roboplant.Output;

public class DeviceSEQC
extends Device {
    private static final int MF_NONE_STOPPABLE = 1;
    private static final int MF_TRANSPARENT_START = 2;
    private static final int MF_TRANSPARENT_WORK = 4;
    private static final int MF_FLOW_CONTROLLER = 8;
    private static final int MF_FLOW = 16;
    private static final int MF_WATCHING_ONLY = 32;
    private static final int MF_SOLE_OWNER = 64;
    Input inpStart;
    Input inpStop;
    Input inpStopEmrg;
    Input inpStopFlow;
    List<DeviceSEQC> otherSeqc = new LinkedList<DeviceSEQC>();
    Tag tagSost;
    Tag tagCurrentAddr;
    Tag tagAlarm;
    Tag tagCode;
    Tag tagCheck;
    Tag tagFlags;
    List<Tag> tagAddress = new ArrayList<Tag>();
    List<Tag> tagDelays = new ArrayList<Tag>();
    List<Tag> tagModeFlags = new ArrayList<Tag>();
    DeviceSEQCItem[] mchb;
    int addressCount;
    int cnt;
    int curDelay;
    int podachaCnt;
    int current;
    int sost;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpStart = this.getInput("Start", res);
        this.inpStop = this.getInput("Stop", res);
        this.inpStopEmrg = this.getInput("StopEmrg", res);
        this.inpStopFlow = this.getInput("StopFlow", res);
        this.tagSost = this.getOutputTag("Sost", res);
        this.tagCurrentAddr = this.getOutputTag("Current", res);
        this.tagAlarm = this.getOutputTag("Alarm", res);
        this.tagCode = this.getOutputTag("Code", res);
        this.tagCheck = this.getOutputTag("Check", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.prepareOtherSeqc();
        this.prepareOutputArrays();
        if (res.value) {
            this.resetState();
        }
    }

    private void prepareOtherSeqc() {
        for (Device dev : this.module.devicesByOrder) {
            if (!(dev instanceof DeviceSEQC) || dev == this) continue;
            this.otherSeqc.add((DeviceSEQC)dev);
        }
    }

    private void prepareOutputArrays() {
        this.tagAddress.clear();
        this.tagDelays.clear();
        this.tagModeFlags.clear();
        int i = 0;
        while (true) {
            Output addr = this.getOutput("Address" + i);
            Output dly = this.getOutput("Delays" + i);
            Output flg = this.getOutput("ModeFlags" + i);
            if (addr == null || dly == null || flg == null) break;
            this.tagAddress.add(addr.tag);
            this.tagDelays.add(dly.tag);
            this.tagModeFlags.add(flg.tag);
            ++i;
        }
        this.addressCount = i;
        this.initMchbItems();
    }

    protected void initMchbItems() {
        this.mchb = new DeviceSEQCItem[this.addressCount];
        for (int i = 0; i < this.addressCount; ++i) {
            this.mchb[i] = new DeviceSEQCItem();
        }
    }

    protected void resetState() {
        this.tagSost.setInt(0);
        this.tagCurrentAddr.setInt(65535);
        this.tagAlarm.setInt(0);
        this.tagCode.setInt(0);
        this.tagCheck.setInt(0);
        this.cnt = 0;
        this.curDelay = 0;
        this.podachaCnt = 0;
        this.current = 0;
        this.sost = 0;
    }

    protected void linkMchbItems() {
        for (int i = 0; i < this.addressCount; ++i) {
            int addr = this.tagAddress.get(i).getInt();
            if (this.mchb[i].address == addr) continue;
            this.mchb[i].address = addr;
            this.mchb[i].reset();
            if (addr == 65535) break;
            Device d = this.module.getDevice(addr);
            if (d != null) {
                Output output = d.getOutput(0);
                if (output != null) {
                    this.mchb[i].setTagMasterout(output.tag);
                }
                if ((output = d.getOutput(1)) != null) {
                    this.mchb[i].setTagSost(output.tag);
                }
                if ((output = d.getOutput(6)) == null) continue;
                this.mchb[i].setTagControl(output.tag);
                continue;
            }
            this.tagAddress.get(i).setInt(65535);
            this.mchb[i].address = 65535;
            this.mchb[i].reset();
        }
    }

    @Override
    public boolean execute() {
        boolean flag;
        int modeflags;
        boolean _podachaEn;
        this.linkMchbItems();
        boolean _start = this.inpStart.getInt() > 0 && this.tagCode.getInt() > 0 && this.tagCode.getInt() < 65535;
        boolean _stop = this.inpStop.getInt() > 0;
        boolean _emrgstop = this.inpStopEmrg.getInt() > 0;
        boolean bl = _podachaEn = this.inpStopFlow.getInt() == 0;
        if (this.sost > 0 && this.current > 0) {
            for (int i = 0; i < this.current; ++i) {
                modeflags = this.tagModeFlags.get(i).getInt();
                if ((modeflags & 8) > 0) {
                    _podachaEn &= this.getMchbMasterOut(i) > 0;
                }
                if (!_podachaEn && (modeflags & 0x10) > 0 && this.podachaCnt >= modeflags / 256) {
                    this.stopMchbSequence(i, this.current, 0);
                    this.current = i;
                    this.sost = 1;
                    break;
                }
                if (this.getMchbMasterOut(i) != 0 || (modeflags & 4) != 0) continue;
                this.stopMchbSequence(i + 1, this.current, 0);
                this.current = i;
                this.sost = this.checkMchbInAlarm(i) ? 4 : 1;
            }
        }
        if (_podachaEn) {
            this.podachaCnt = 0;
        } else if (this.podachaCnt < 256) {
            ++this.podachaCnt;
        }
        if ((this.sost == 1 || this.sost == 2 || this.sost == 4 || this.sost == 6) && _stop) {
            this.sost = 3;
        }
        if ((this.sost == 1 || this.sost == 2 || this.sost == 3 || this.sost == 4 || this.sost == 6) && _emrgstop) {
            this.sost = 5;
        }
        if (this.sost == 0) {
            if (_start && !_stop && !_emrgstop) {
                this.sost = 1;
                this.current = 0;
                this.cnt = 0;
            } else {
                this.tagAlarm.setInt(0);
            }
        }
        if (this.sost == 6 && (this.mchb[this.current].getControlValue() & 0x10) == 0) {
            this.sost = 1;
        }
        if (this.sost == 1) {
            modeflags = this.tagModeFlags.get(this.current).getInt();
            if ((modeflags & 0x40) > 0 && this.mchb[this.current].state == 0 && (this.mchb[this.current].getControlValue() & 0x10) > 0) {
                this.sost = 6;
            } else if ((modeflags & 0x10) > 0 && !_podachaEn) {
                this.setMchbControl(this.current, 0);
                this.cnt = 0;
            } else {
                if (this.mchb[this.current].state == 0) {
                    this.setMchbControl(this.current, 1);
                    this.curDelay = this.getMchbStartDelay(this.current);
                    this.cnt = 0;
                } else {
                    int ctrl = this.mchb[this.current].getControlValue();
                    if ((ctrl & 0x10) == 0 && (modeflags & 0x20) == 0) {
                        this.mchb[this.current].setControlValue(ctrl | 0x10);
                    }
                }
                if (this.cnt < this.curDelay) {
                    ++this.cnt;
                }
                if (this.cnt >= this.curDelay) {
                    if (this.getMchbMasterOut(this.current) == 1 || (modeflags & 2) > 0) {
                        ++this.current;
                        flag = true;
                        if (this.current < this.addressCount && this.tagAddress.get(this.current).getInt() != 65535) {
                            flag = false;
                        }
                        if (flag) {
                            this.sost = 2;
                        }
                    } else if (this.mchb[this.current].getSostValue() == 4 || this.mchb[this.current].getSostValue() == 5) {
                        this.sost = 4;
                    }
                }
            }
        }
        if (this.sost == 2) {
            this.setMchbControl(this.current, 1);
        }
        if (this.sost == 3) {
            flag = false;
            if (this.current < this.addressCount && this.tagAddress.get(this.current).getInt() != 65535) {
                flag = true;
            }
            if (flag) {
                if (this.mchb[this.current].state == 1) {
                    this.setMchbControl(this.current, 0);
                    this.curDelay = this.getMchbStopDelay(this.current);
                    this.cnt = 0;
                }
                if (this.cnt < this.curDelay) {
                    ++this.cnt;
                }
                if (this.cnt >= this.curDelay) {
                    if (this.current == 0) {
                        this.stopAll();
                        this.sost = 0;
                    } else {
                        --this.current;
                    }
                }
            } else if (this.current == 0) {
                this.stopAll();
                this.sost = 0;
            } else {
                --this.current;
            }
        }
        if (this.sost == 4 && !this.checkMchbInAlarm(this.current) && _start) {
            this.sost = 1;
            this.tagAlarm.setInt(0);
        }
        if (this.sost == 5) {
            this.stopAll();
            this.sost = 0;
        }
        if ((this.sost == 1 || this.sost == 3 || this.sost == 4 || this.sost == 6) && this.current < this.addressCount) {
            this.tagCurrentAddr.setInt(this.tagAddress.get(this.current).getInt());
        } else {
            this.tagCurrentAddr.setInt(65535);
        }
        this.tagAlarm.setInt(this.sost == 4 || this.sost == 6 ? 1 : 0);
        this.tagSost.setInt(this.sost);
        return true;
    }

    protected int getMchbMasterOut(int idx) {
        return this.mchb[idx].getMasteroutValue();
    }

    protected int getMchbStartDelay(int idx) {
        return this.tagDelays.get(idx).getInt() >> 8;
    }

    protected int getMchbStopDelay(int idx) {
        return this.tagDelays.get(idx).getInt() & 0xFF;
    }

    protected boolean checkMchbInAlarm(int idx) {
        int i = this.mchb[idx].getSostValue();
        return i == 4 || i == 5;
    }

    protected void setMchbControl(int idx, int value) {
        int ctrl = this.mchb[idx].getControlValue();
        if (value > 0) {
            this.mchb[idx].state = 1;
            if ((this.tagModeFlags.get(idx).getInt() & 0x20) == 0) {
                this.mchb[idx].setControlValue(ctrl | 0x10);
            }
        } else {
            this.mchb[idx].state = 0;
            boolean flag = false;
            for (DeviceSEQC seqc : this.otherSeqc) {
                if (!seqc.checkMchbState(this.mchb[idx].address)) continue;
                flag = true;
                break;
            }
            if (!flag && (this.tagModeFlags.get(idx).getInt() & 0x20) == 0) {
                this.mchb[idx].setControlValue(ctrl & 0xEF);
            }
        }
    }

    protected void stopMchbSequence(int idxbeg, int idxend, int stoparmo) {
        for (int i = idxbeg; i <= idxend; ++i) {
            if ((this.tagModeFlags.get(i).getInt() & 1) != 0 && stoparmo <= 0) continue;
            this.mchb[i].state = 0;
            this.setMchbControl(i, 0);
        }
    }

    protected void stopAll() {
        for (int i = 0; i < this.addressCount && this.mchb[i].address != 65535; ++i) {
            this.mchb[i].state = 0;
            this.setMchbControl(i, 0);
        }
    }

    protected boolean checkMchbState(int addr) {
        boolean flag = false;
        for (int i = 0; i < this.addressCount; ++i) {
            if (this.tagAddress.get(i).getInt() == addr) {
                if ((this.tagModeFlags.get(i).getInt() & 0x20) == 0) {
                    flag = this.mchb[i].state > 0;
                    break;
                }
                flag = false;
                break;
            }
            if (this.tagAddress.get(i).getInt() == 65535) break;
        }
        return flag;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("cnt", this.cnt);
        state.saveVar("curDelay", this.curDelay);
        state.saveVar("podachaCnt", this.podachaCnt);
        state.saveVar("current", this.current);
        state.saveVar("sost", this.sost);
        for (int i = 0; i < this.addressCount; ++i) {
            state.saveVar("state_" + i, this.mchb[i].state);
        }
    }

    @Override
    public void loadStateExtra(State state) {
        this.cnt = state.loadVar("cnt", this.cnt);
        this.curDelay = state.loadVar("curDelay", this.curDelay);
        this.podachaCnt = state.loadVar("podachaCnt", this.podachaCnt);
        this.current = state.loadVar("current", this.current);
        this.sost = state.loadVar("sost", this.sost);
        for (int i = 0; i < this.addressCount; ++i) {
            this.mchb[i].state = state.loadVar("state_" + i, this.mchb[i].state);
        }
    }
}

