/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceSTMD
extends Device {
    protected static final int STATE_OFF = 0;
    protected static final int STATE_START_DLY = 1;
    protected static final int STATE_BEFORE_LOAD = 2;
    protected static final int STATE_LOAD_OPEN = 3;
    protected static final int STATE_LOAD_VIBRATE = 4;
    protected static final int STATE_LOAD_DLY = 5;
    protected static final int STATE_LOAD_FINISH = 6;
    protected static final int STATE_BEFORE_INFLATE = 7;
    protected static final int STATE_INFLATE_WARM = 8;
    protected static final int STATE_INFLATE_BLOW1 = 9;
    protected static final int STATE_INFLATE_BLOW2 = 10;
    protected static final int STATE_INFLATE = 11;
    protected static final int STATE_INFLATE_FINISH = 12;
    protected static final int STATE_EXPOSITION = 13;
    protected static final int STATE_DEFLATE1 = 14;
    protected static final int STATE_DEFLATE2 = 15;
    protected static final int STATE_UNLOAD_OPEN = 16;
    protected static final int STATE_UNLOAD_DLY = 17;
    protected static final int STATE_UNLOAD_EMPTY = 18;
    protected static final int STATE_UNLOAD_VIBRATE = 19;
    protected static final int STATE_UNLOAD_FINISH = 20;
    protected static final int STATE_CYCLE_PAUSE = 21;
    protected static final int WAIT_TIMER = 1;
    protected static final int WAIT_DVU1 = 2;
    protected static final int WAIT_DVU2 = 4;
    protected static final int WAIT_CAN_INFL = 8;
    protected static final int WAIT_PSENSOR_OK = 16;
    protected static final int WAIT_PLINE_OK = 32;
    protected static final int WAIT_PAIR_OK = 64;
    protected static final int WAIT_ENERGY_OK = 128;
    protected static final int WAIT_PWORK = 256;
    protected static final int WAIT_PLOAD = 512;
    protected static final int WAIT_PUNLOAD = 1024;
    protected static final int WAIT_PBLOW = 2048;
    protected static final int WAIT_PFAN = 4096;
    protected static final int WAIT_TIMEFAN = 8192;
    private static final int NCL = 1;
    private static final int CLS = 2;
    private static final int NOP = 3;
    private static final int OPN = 4;
    private static final int ALARM_PALARM = 1;
    private static final int ALARM_INFLATE_TIMEOUT = 2;
    private static final int ALARM_DEFLATE_TIMEOUT = 3;
    private static final int ALARM_UNLOAD_TIMEOUT = 4;
    Input inpEnable;
    Input inpSuspend;
    Input inpCanInfl;
    Input inpP;
    Input inpPEmrg;
    Input inpPSensorOk;
    Input inpPLineOk;
    Input inpPAirOk;
    Input inpEnergyOk;
    Input inpDVU1;
    Input inpDVU2;
    Input inpClosedK1;
    Input inpClosedK2;
    Input inpClosedK3;
    Input inpClosedK4;
    Input inpClosedK5;
    Input inpClosedK6;
    Input inpOpenedK1;
    Input inpOpenedK2;
    Tag tagState;
    Tag tagWaitCl;
    Tag tagWaitOp;
    Tag tagWaitEx;
    Tag tagAlarm;
    Tag tagTimer;
    Tag tagCycleNum;
    Tag tagOpenK1;
    Tag tagOpenK2;
    Tag tagOpenK3;
    Tag tagOpenK4;
    Tag tagOpenK5;
    Tag tagOpenK6;
    Tag tagStopFan;
    Tag tagVibr;
    Tag tagBtnStart;
    Tag tagBtnStop;
    Tag tagNextState;
    Tag tagFlags;
    Tag tagCycleQnt;
    Tag tagPAlarm;
    Tag tagPWork;
    Tag tagPWorkMax;
    Tag tagPDelta;
    Tag tagPDeltaMax;
    Tag tagPOpenK5;
    Tag tagPLoad;
    Tag tagPUnload;
    Tag tagPFan;
    Tag tagTimeStartDly;
    Tag tagTimeLoad;
    Tag tagTimeWarm;
    Tag tagTimeInflMax;
    Tag tagTimeDeflMax;
    Tag tagTimeExp;
    Tag tagTimeExpMax;
    Tag tagTimeStopFan;
    Tag tagTimeUnload;
    Tag tagTimeUnloadMin;
    Tag tagTimeUnloadMax;
    Tag tagTimeVibr;
    Tag tagTimeCycDly;
    Tag tagTimeLoadVibr;
    Tag tagPBlow;
    private int state;
    private int waitCl;
    private int waitOp;
    private int waitEx;
    private int alarm;
    private int timer;
    private int openK1;
    private int openK2;
    private int openK3;
    private int openK4;
    private int openK5;
    private int openK6;
    private int stopfan;
    private int vibr;
    private int timerFan;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpEnable = this.getInput("Enable", res);
        this.inpSuspend = this.getInput("Suspend", res);
        this.inpCanInfl = this.getInput("CanInfl", res);
        this.inpP = this.getInput("P", res);
        this.inpPEmrg = this.getInput("PEmrg", res);
        this.inpPSensorOk = this.getInput("PSensorOk", res);
        this.inpPLineOk = this.getInput("PLineOk", res);
        this.inpPAirOk = this.getInput("PAirOk", res);
        this.inpEnergyOk = this.getInput("EnergyOk", res);
        this.inpDVU1 = this.getInput("DVU1", res);
        this.inpDVU2 = this.getInput("DVU2", res);
        this.inpClosedK1 = this.getInput("ClosedK1", res);
        this.inpClosedK2 = this.getInput("ClosedK2", res);
        this.inpClosedK3 = this.getInput("ClosedK3", res);
        this.inpClosedK4 = this.getInput("ClosedK4", res);
        this.inpClosedK5 = this.getInput("ClosedK5", res);
        this.inpClosedK6 = this.getInput("ClosedK6", res);
        this.inpOpenedK1 = this.getInput("OpenedK1", res);
        this.inpOpenedK2 = this.getInput("OpenedK2", res);
        this.tagState = this.getOutputTag("State", res);
        this.tagWaitCl = this.getOutputTag("WaitCl", res);
        this.tagWaitOp = this.getOutputTag("WaitOp", res);
        this.tagWaitEx = this.getOutputTag("WaitEx", res);
        this.tagAlarm = this.getOutputTag("Alarm", res);
        this.tagTimer = this.getOutputTag("Timer", res);
        this.tagCycleNum = this.getOutputTag("CycleNum", res);
        this.tagOpenK1 = this.getOutputTag("OpenK1", res);
        this.tagOpenK2 = this.getOutputTag("OpenK2", res);
        this.tagOpenK3 = this.getOutputTag("OpenK3", res);
        this.tagOpenK4 = this.getOutputTag("OpenK4", res);
        this.tagOpenK5 = this.getOutputTag("OpenK5", res);
        this.tagOpenK6 = this.getOutputTag("OpenK6", res);
        this.tagStopFan = this.getOutputTag("StopFan", res);
        this.tagVibr = this.getOutputTag("Vibr", res);
        this.tagBtnStart = this.getOutputTag("BtnStart", res);
        this.tagBtnStop = this.getOutputTag("BtnStop", res);
        this.tagNextState = this.getOutputTag("NextState", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.tagCycleQnt = this.getOutputTag("CycleQnt", res);
        this.tagPAlarm = this.getOutputTag("PAlarm", res);
        this.tagPWork = this.getOutputTag("PWork", res);
        this.tagPWorkMax = this.getOutputTag("PWorkMax", res);
        this.tagPDelta = this.getOutputTag("PDelta", res);
        this.tagPDeltaMax = this.getOutputTag("PDeltaMax", res);
        this.tagPOpenK5 = this.getOutputTag("POpenK5", res);
        this.tagPLoad = this.getOutputTag("PLoad", res);
        this.tagPUnload = this.getOutputTag("PUnload", res);
        this.tagPFan = this.getOutputTag("PFan", res);
        this.tagTimeStartDly = this.getOutputTag("TimeStartDly", res);
        this.tagTimeLoad = this.getOutputTag("TimeLoad", res);
        this.tagTimeWarm = this.getOutputTag("TimeWarm", res);
        this.tagTimeInflMax = this.getOutputTag("TimeInflMax", res);
        this.tagTimeDeflMax = this.getOutputTag("TimeDeflMax", res);
        this.tagTimeExp = this.getOutputTag("TimeExp", res);
        this.tagTimeExpMax = this.getOutputTag("TimeExpMax", res);
        this.tagTimeStopFan = this.getOutputTag("TimeStopFan", res);
        this.tagTimeUnload = this.getOutputTag("TimeUnload", res);
        this.tagTimeUnloadMin = this.getOutputTag("TimeUnloadMin", res);
        this.tagTimeUnloadMax = this.getOutputTag("TimeUnloadMax", res);
        this.tagTimeVibr = this.getOutputTag("TimeVibr", res);
        this.tagTimeCycDly = this.getOutputTag("TimeCycDly", res);
        this.tagTimeLoadVibr = this.getOutputTag("TimeLoadVibr", res);
        this.tagPBlow = this.getOutputTag("PBlow", res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagState.setInt(0);
        this.tagWaitCl.setInt(0);
        this.tagWaitOp.setInt(0);
        this.tagWaitEx.setInt(0);
        this.tagAlarm.setInt(0);
        this.tagTimer.setInt(0);
        this.tagCycleNum.setInt(0);
        this.tagOpenK1.setInt(0);
        this.tagOpenK2.setInt(0);
        this.tagOpenK3.setInt(0);
        this.tagOpenK4.setInt(0);
        this.tagOpenK5.setInt(0);
        this.tagOpenK6.setInt(0);
        this.tagStopFan.setInt(0);
        this.tagVibr.setInt(0);
        this.state = 0;
        this.waitCl = 0;
        this.waitOp = 0;
        this.waitEx = 0;
        this.alarm = 0;
        this.timer = 0;
        this.openK1 = 0;
        this.openK2 = 0;
        this.openK3 = 0;
        this.openK4 = 0;
        this.openK5 = 0;
        this.openK6 = 0;
        this.stopfan = 0;
        this.vibr = 0;
        this.timerFan = 0;
    }

    @Override
    public boolean execute() {
        this.makeConsistency();
        this.updateTimer();
        this.waitCl = 0;
        this.waitOp = 0;
        this.waitEx = 0;
        this.alarm = 0;
        if (this.tagNextState.getInt() > 0) {
            if (this.state > 0 && this.tagNextState.getInt() == this.state + 1) {
                ++this.state;
                this.resetTimer();
            }
            this.tagNextState.setInt(0);
        }
        if (this.state == 0) {
            this.setValves(0, 0, 0, 0, 1, 1);
            this.tagBtnStop.setDouble(0.0);
            if (this.tagBtnStart.getBool()) {
                this.nextState();
            }
        }
        this.tagBtnStart.setDouble(0.0);
        if (this.state == 1) {
            this.tagCycleNum.setInt(0);
            this.setValves(0, 0, 0, 0, 1, 1);
            if (this.tagBtnStop.getBool()) {
                this.state = 0;
                this.resetTimer();
            } else {
                this.useTimer(this.tagTimeStartDly);
                this.nextStateIfChecked();
            }
        }
        if (this.state == 2) {
            if (this.tagBtnStop.getBool()) {
                this.state = 0;
            } else {
                this.setValves(0, 0, 0, 0, 1, 1);
                this.chkValves(2, 2, 2, 2, 1, 1);
                this.chkEx(512, this.inpP.getInt() <= this.tagPLoad.getInt());
                this.chkEx(32, this.inpPLineOk.getInt() > 0);
                this.chkEx(64, this.inpPAirOk.getInt() > 0);
                this.chkEx(16, this.inpPSensorOk.getInt() > 0);
                this.chkEx(128, this.inpEnergyOk.getInt() > 0);
                this.chkEx(2, this.inpDVU1.getInt() > 0);
                this.chkEx(4, this.inpDVU2.getInt() == 0);
                this.nextStateIfChecked();
            }
        }
        if (this.state == 3) {
            this.setValves(1, 0, 0, 0, 1, 1);
            this.chkValves(4, 0, 0, 0, 0, 0);
            this.nextStateIfChecked();
        }
        if (this.state == 4) {
            this.setValves(1, 0, 0, 0, 1, 1);
            this.useTimer(this.tagTimeLoadVibr);
            if (this.nextStateIfChecked()) {
                this.resetTimer();
                this.setupTimer(this.tagTimeLoad);
            }
        }
        if (this.state == 5) {
            this.setValves(1, 0, 0, 0, 1, 1);
            this.useTimer(this.tagTimeLoad);
            this.nextStateIfChecked();
        }
        if (this.state == 6) {
            if (this.tagTimeWarm.getInt() > 0) {
                this.setValves(0, 0, 0, 0, 1, 0);
                this.chkValves(2, 2, 2, 2, 1, 2);
            } else {
                this.setValves(0, 0, 0, 0, 1, 0);
                this.chkValves(2, 2, 2, 2, 1, 2);
            }
            this.nextStateIfChecked();
        }
        if (this.state == 7) {
            this.chkEx(8, this.inpCanInfl.getInt() > 0);
            this.chkEx(32, this.inpPLineOk.getInt() > 0);
            this.nextStateIfChecked();
        }
        if (this.state == 8) {
            this.setValves(0, 0, 1, 0, 1, 0);
            this.useTimer(this.tagTimeWarm);
            if (this.nextStateIfChecked()) {
                this.resetTimer();
                this.setupTimer(this.tagTimeInflMax);
            }
        }
        if (this.state == 9) {
            this.setValves(0, 0, 0, 0, 1, 0);
            this.chkValves(0, 0, 2, 0, 1, 0);
            this.nextStateIfChecked();
        }
        if (this.state == 10) {
            this.setValves(0, 0, 1, 0, 1, 0);
            this.chkEx(2048, this.inpP.getInt() >= this.tagPBlow.getInt());
            this.nextStateIfChecked();
            if (!this.checked() && this.timer <= 0) {
                this.alarm = 2;
            }
        }
        if (this.state == 11) {
            this.setValves(0, 0, 1, 0, 0, 0);
            this.chkValves(0, 0, 0, 0, 0, 0);
            this.chkEx(256, this.inpP.getInt() >= this.tagPWork.getInt());
            this.nextStateIfChecked();
            if (!this.checked() && this.timer <= 0) {
                this.alarm = 2;
            }
        }
        if (this.state == 12) {
            this.resetTimer();
            this.setValves(0, 0, 0, 0, 0, 0);
            this.chkValves(2, 2, 2, 2, 2, 2);
            this.nextStateIfChecked();
        }
        if (this.state == 13) {
            if (this.inpP.getInt() <= this.tagPWork.getInt() - this.tagPDelta.getInt() && this.openK4 == 0) {
                this.openK4 = 1;
            }
            if (this.inpP.getInt() >= this.tagPWork.getInt() && this.openK4 == 1) {
                this.openK4 = 0;
            }
            this.setValves(0, 0, 0, this.openK4, 0, 0);
            this.useTimer(this.tagTimeExp);
            if (this.nextStateIfChecked()) {
                this.resetTimer();
                this.setupTimer(this.tagTimeDeflMax);
            }
        }
        if (this.state == 14) {
            this.setValves(0, 0, 0, 0, 1, 1);
            this.chkEx(4096, this.inpP.getInt() <= this.tagPFan.getInt());
            if (this.nextStateIfChecked()) {
                this.timerFan = -1;
            }
            if (!this.checked() && this.timer <= 0) {
                this.alarm = 3;
            }
        }
        if (this.state == 15) {
            this.setValves(0, 0, 0, 0, 1, 1);
            ++this.timerFan;
            this.chkEx(1024, this.inpP.getInt() <= this.tagPUnload.getInt());
            this.chkEx(8192, this.timerFan >= this.tagTimeStopFan.getInt());
            if (!this.checked() && this.timer <= 0) {
                this.alarm = 3;
            }
            if (this.nextStateIfChecked()) {
                this.resetTimer();
            }
        }
        if (this.state == 16) {
            this.setValves(0, 1, 0, 0, 1, 1);
            this.chkValves(0, 4, 0, 0, 0, 0);
            this.nextStateIfChecked();
        }
        if (this.state == 17) {
            this.setValves(0, 1, 0, 0, 1, 1);
            this.useTimer(this.tagTimeUnload);
            this.nextStateIfChecked();
        }
        if (this.state == 18) {
            this.resetTimer();
            this.setValves(0, 1, 0, 0, 1, 1);
            this.chkEx(4, this.inpDVU2.getInt() == 0);
            if (!this.nextStateIfChecked()) {
                this.alarm = 4;
            }
        }
        if (this.state == 19) {
            this.setValves(0, 1, 0, 0, 1, 1);
            this.useTimer(this.tagTimeVibr);
            this.nextStateIfChecked();
        }
        if (this.state == 20) {
            this.setValves(0, 0, 0, 0, 1, 1);
            this.chkValves(2, 2, 2, 2, 1, 1);
            this.nextStateIfChecked();
        }
        if (this.state == 21) {
            this.setValves(0, 0, 0, 0, 1, 1);
            this.useTimer(this.tagTimeCycDly);
            if (this.checked()) {
                this.state = 2;
                this.tagCycleNum.setInt(this.tagCycleNum.getInt() + 1);
                if (this.tagCycleNum.getInt() >= this.tagCycleQnt.getInt() && this.tagCycleQnt.getInt() > 0) {
                    this.state = 0;
                }
                if (this.tagBtnStop.getBool()) {
                    this.state = 0;
                }
            }
        }
        int n = this.openK5 = this.openK5 > 0 && this.inpP.getInt() <= this.tagPOpenK5.getInt() ? 1 : 0;
        if (this.inpPEmrg.getInt() > 0 || this.inpClosedK1.getInt() == 0 || this.inpClosedK2.getInt() == 0 || this.inpPSensorOk.getInt() == 0) {
            this.openK4 = 0;
            this.openK3 = 0;
        }
        if (this.inpP.getInt() >= this.tagPAlarm.getInt()) {
            this.alarm = 1;
        }
        this.vibr = this.state == 19 || this.state == 4 ? 1 : 0;
        this.stopfan = this.state >= 15 && this.state <= 20 ? 1 : 0;
        this.tagState.setInt(this.state);
        this.tagWaitCl.setInt(this.waitCl);
        this.tagWaitOp.setInt(this.waitOp);
        this.tagWaitEx.setInt(this.waitEx);
        this.tagAlarm.setInt(this.alarm);
        this.tagTimer.setInt(this.timer);
        this.tagOpenK1.setInt(this.openK1);
        this.tagOpenK2.setInt(this.openK2);
        this.tagOpenK3.setInt(this.openK3);
        this.tagOpenK4.setInt(this.openK4);
        this.tagOpenK5.setInt(this.openK5);
        this.tagOpenK6.setInt(this.openK6);
        this.tagStopFan.setInt(this.stopfan);
        this.tagVibr.setInt(this.vibr);
        return true;
    }

    private void makeConsistency() {
        if (this.tagPWork.getInt() > this.tagPWorkMax.getInt()) {
            this.tagPWork.setInt(this.tagPWorkMax.getInt());
        }
        if (this.tagPDelta.getInt() > this.tagPDeltaMax.getInt()) {
            this.tagPDelta.setInt(this.tagPDeltaMax.getInt());
        }
        if (this.tagTimeExp.getInt() > this.tagTimeExpMax.getInt()) {
            this.tagTimeExp.setInt(this.tagTimeExpMax.getInt());
        }
        if (this.tagTimeUnload.getInt() < this.tagTimeUnloadMin.getInt()) {
            this.tagTimeUnload.setInt(this.tagTimeUnloadMin.getInt());
        }
    }

    private void useTimer(Tag time) {
        this.setupTimer(time);
        this.chkEx(1, this.timer <= 0);
    }

    private void setupTimer(Tag time) {
        if (this.timer < 0) {
            this.timer = time.getInt();
        }
    }

    private void updateTimer() {
        if (this.timer >= 0) {
            --this.timer;
        }
    }

    private void resetTimer() {
        this.timer = -1;
    }

    private void nextState() {
        ++this.state;
    }

    private boolean nextStateIfChecked() {
        if (this.checked()) {
            this.nextState();
            return true;
        }
        return false;
    }

    private boolean checked() {
        return (this.waitCl | this.waitOp | this.waitEx) == 0;
    }

    private void setValves(int k1, int k2, int k3, int k4, int k5, int k6) {
        this.openK1 = k1;
        this.openK2 = k2;
        this.openK3 = k3;
        this.openK4 = k4;
        this.openK5 = k5;
        this.openK6 = k6;
    }

    private void chkValves(int k1, int k2, int k3, int k4, int k5, int k6) {
        this.chkValve(0, k1, this.inpClosedK1, this.inpOpenedK1);
        this.chkValve(1, k2, this.inpClosedK2, this.inpOpenedK2);
        this.chkValve(2, k3, this.inpClosedK3);
        this.chkValve(3, k4, this.inpClosedK4);
        this.chkValve(4, k5, this.inpClosedK5);
        this.chkValve(5, k6, this.inpClosedK6);
    }

    private boolean chkValve(int bit, int mode, Input inp) {
        if (mode == 1 && inp.getInt() > 0) {
            this.waitCl += 1 << bit;
        } else if (mode == 2 && inp.getInt() <= 0) {
            this.waitCl += 1 << bit + 8;
        } else {
            return true;
        }
        return false;
    }

    private boolean chkValve(int bit, int mode, Input inpClosed, Input inpOpened) {
        if (!this.chkValve(bit, mode, inpClosed)) {
            return false;
        }
        if (mode == 3 && inpOpened.getInt() > 0) {
            this.waitOp += 1 << bit;
        } else if (mode == 4 && inpOpened.getInt() <= 0) {
            this.waitOp += 1 << bit + 8;
        } else {
            return true;
        }
        return false;
    }

    private boolean chkEx(int waitMask, boolean is_ok) {
        if (!is_ok) {
            this.waitEx += waitMask;
            return false;
        }
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("state", this.state);
        state.saveVar("waitCl", this.waitCl);
        state.saveVar("waitOp", this.waitOp);
        state.saveVar("waitEx", this.waitEx);
        state.saveVar("alarm", this.alarm);
        state.saveVar("timer", this.timer);
        state.saveVar("openK1", this.openK1);
        state.saveVar("openK2", this.openK2);
        state.saveVar("openK3", this.openK3);
        state.saveVar("openK4", this.openK4);
        state.saveVar("openK5", this.openK5);
        state.saveVar("openK6", this.openK6);
        state.saveVar("stopfan", this.stopfan);
        state.saveVar("vibr", this.vibr);
        state.saveVar("timerFan", this.timerFan);
    }

    @Override
    public void loadStateExtra(State state) {
        this.state = state.loadVar("state", this.state);
        this.waitCl = state.loadVar("waitCl", this.waitCl);
        this.waitOp = state.loadVar("waitOp", this.waitOp);
        this.waitEx = state.loadVar("waitEx", this.waitEx);
        this.alarm = state.loadVar("alarm", this.alarm);
        this.timer = state.loadVar("timer", this.timer);
        this.openK1 = state.loadVar("openK1", this.openK1);
        this.openK2 = state.loadVar("openK2", this.openK2);
        this.openK3 = state.loadVar("openK3", this.openK3);
        this.openK4 = state.loadVar("openK4", this.openK4);
        this.openK5 = state.loadVar("openK5", this.openK5);
        this.openK6 = state.loadVar("openK6", this.openK6);
        this.stopfan = state.loadVar("stopfan", this.stopfan);
        this.vibr = state.loadVar("vibr", this.vibr);
        this.timerFan = state.loadVar("timerFan", this.timerFan);
    }
}

