/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.Device;

public class DeviceZDVH
extends Device {
    Tag tagClosed;
    Tag tagOpened;
    Tag tagBlok;
    Tag tagFlags;
    Channel chnlIn;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.createTagDescr();
        this.tagClosed = this.getOutputTag("Closed", res);
        this.tagOpened = this.getOutputTag("Opened", res);
        this.tagBlok = this.getOutputTag("Blok", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.chnlIn = this.createChannel("ChnlIn", Channel.Type.In, res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagOpened.setInt(0);
        this.tagClosed.setInt(0);
    }

    @Override
    public boolean execute() {
        int closed;
        int opened;
        if (!this.chnlIn.isOk()) {
            this.tagClosed.setInt(this.tagClosed.getInt() > 0 ? 0 : 1);
            this.tagOpened.setInt(this.tagOpened.getInt() > 0 ? 0 : 1);
            return false;
        }
        int blok = this.tagBlok.getInt();
        if (blok > 0) {
            opened = blok != 1 ? 1 : 0;
            closed = blok == 1 ? 1 : 0;
        } else {
            closed = this.chnlIn.tagValue.getInt() > 0 == (this.tagFlags.getInt() & 0x80) > 0 ? 1 : 0;
            opened = 1 - closed;
        }
        if (this.tagClosed.getInt() != closed) {
            this.tagClosed.setInt(closed);
        }
        if (this.tagOpened.getInt() != opened) {
            this.tagOpened.setInt(opened);
        }
        return true;
    }
}

