/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.ArrayList;
import java.util.List;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceZDVT
extends Device {
    Input inpEnable;
    List<Direction> dirs = new ArrayList<Direction>();
    Tag tagOutput;
    Tag tagSost;
    Tag tagControl;
    Tag tagBlok;
    Tag tagFlags;
    Tag tagDelay;
    Tag tagParam;
    int sost;
    int curdirNum;
    int curdirSost;
    int delayCnt;
    int dirAmount;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.createTagDescr();
        this.inpEnable = this.getInput("Enable", res);
        this.tagOutput = this.getOutputTag(0, res);
        this.tagSost = this.getOutputTag(1, res);
        this.tagControl = this.getOutputTag(2, res);
        this.tagBlok = this.getOutputTag(3, res);
        this.tagFlags = this.getOutputTag(4, res);
        this.tagDelay = this.getOutputTag(5, res);
        this.tagParam = this.getOutputTag(6, res);
        this.prepareDirections(res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void prepareDirections(Device.RefBool res) {
        Input inp;
        this.dirs.clear();
        int i = 1;
        while ((inp = this.getInput("Dir" + i)) != null) {
            Direction dir = new Direction();
            dir.inp = inp;
            dir.channelIn = this.createChannel("Chnl" + i + "In", Channel.Type.In, res);
            dir.channelOut = this.createChannel("Chnl" + i + "Out", Channel.Type.Out, res);
            this.dirs.add(dir);
            ++i;
        }
        this.dirAmount = this.dirs.size();
    }

    protected void resetState() {
        this.tagOutput.setInt(0);
        this.tagSost.setInt(0);
        this.sost = 0;
        this.curdirNum = 255;
        this.curdirSost = 0;
        this.delayCnt = 0;
    }

    @Override
    public boolean execute() {
        int dr;
        int i;
        boolean dat_in = false;
        for (Direction dir : this.dirs) {
            if (dir.channelIn.isOk() && dir.channelOut.isOk()) continue;
            this.tagOutput.setInt(0);
            this.tagSost.setInt(254);
            return false;
        }
        int flags = this.tagFlags.getInt();
        int control = this.tagControl.getInt();
        int blok = this.tagBlok.getInt();
        boolean en = this.inpEnable.getInt() > 0;
        int first_inp = -1;
        for (i = 0; i < this.dirAmount && first_inp == -1; ++i) {
            if (this.dirs.get((int)i).inp.getInt() <= 0) continue;
            first_inp = i;
        }
        int ctrl = control & 0x7F;
        if (ctrl == 0 && (ctrl = control >> 8 & 0x7F) > 0) {
            first_inp = ctrl - 1;
            en = true;
        }
        if ((dr = (ctrl & 0x7F) - 1) == -1 && en) {
            if (this.curdirNum < this.dirAmount && this.dirs.get((int)this.curdirNum).inp.getInt() > 0) {
                dr = this.curdirNum;
            }
            if (dr == -1) {
                dr = first_inp;
            }
        }
        if (dr >= this.dirAmount || dr == -1) {
            dr = 255;
        }
        if (dr != 255) {
            if (dr != this.curdirNum) {
                this.curdirSost = 0;
            }
        } else {
            this.curdirSost = 2;
            for (i = 0; i < this.dirAmount; ++i) {
                this.dirs.get((int)i).channelOut.tagValue.setInt(0);
            }
        }
        this.curdirNum = dr;
        if (this.tagBlok.getBool()) {
            dat_in = true;
        } else if (this.curdirNum < this.dirAmount) {
            boolean bl = dat_in = this.getDataDirChnlIn(this.curdirNum, flags) > 0;
        }
        if ((control & 0x80) > 0) {
            dat_in = false;
            this.curdirSost = 0;
            this.tagControl.setInt(control &= 0xFF7F);
        }
        if (this.curdirSost == 0) {
            this.delayCnt = 0;
            for (i = 0; i < this.dirAmount; ++i) {
                this.dirs.get((int)i).channelOut.tagValue.setBool(i == this.curdirNum && (!dat_in || blok > 0 || (flags & 3) == 2));
            }
            this.curdirSost = 1;
        } else if (this.curdirSost == 1) {
            int flgs = flags & 3;
            if (flgs == 0 || flgs == 1 && dat_in) {
                if (this.curdirNum < this.dirAmount) {
                    this.dirs.get((int)this.curdirNum).channelOut.tagValue.setInt(0);
                }
                this.curdirSost = 2;
            }
        } else if (this.curdirSost == 2) {
            // empty if block
        }
        dr = -1;
        int dr_kolvo = 0;
        for (i = 0; i < this.dirAmount; ++i) {
            if (this.getDataDirChnlIn(i, flags) <= 0) continue;
            ++dr_kolvo;
        }
        for (i = 0; i < this.dirAmount && dr == -1; ++i) {
            if (this.getDataDirChnlIn(i, flags) <= 0) continue;
            dr = i;
        }
        int sst = dr + 1;
        if (blok > 0) {
            sst = ctrl > 0 ? ctrl : this.curdirNum + 1;
        }
        boolean alm = false;
        if (this.curdirNum != 255 && !dat_in) {
            if (this.delayCnt < this.tagDelay.getInt()) {
                ++this.delayCnt;
            } else {
                alm = true;
                if ((flags & 0x10) > 0 && this.delayCnt++ > this.tagDelay.getInt() * 2) {
                    this.tagControl.setInt(control |= 0x80);
                }
            }
        } else {
            this.delayCnt = 0;
        }
        int n = this.sost = alm ? this.curdirNum + 1 | 0x80 : sst & 0x7F;
        if (dr_kolvo > 1) {
            this.sost |= 0x80;
        }
        this.tagSost.setInt(this.sost);
        this.tagOutput.setBool(first_inp >= 0 && ((flags & 4) > 0 ? en && dat_in : en));
        int tmpParam = 0;
        for (i = this.dirAmount - 1; i >= 0; --i) {
            tmpParam <<= 1;
            tmpParam |= this.getDataDirChnlIn(i, flags);
            tmpParam <<= 1;
            tmpParam |= this.dirs.get((int)i).channelOut.tagValue.getInt();
        }
        this.tagParam.setInt(tmpParam);
        return true;
    }

    protected int getDataDirChnlIn(int dirnum, int flags) {
        if ((flags >> dirnum + 8 & 1) > 0) {
            return 1 - (this.dirs.get((int)dirnum).channelIn.tagValue.getBool() == (flags & 0x80) > 0 ? 1 : 0);
        }
        return this.dirs.get((int)dirnum).channelIn.tagValue.getBool() == (flags & 0x80) > 0 ? 1 : 0;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("sost", this.sost);
        state.saveVar("curdirNum", this.curdirNum);
        state.saveVar("curdirSost", this.curdirSost);
        state.saveVar("delayCnt", this.delayCnt);
    }

    @Override
    public void loadStateExtra(State state) {
        this.sost = state.loadVar("sost", this.sost);
        this.curdirNum = state.loadVar("curdirNum", this.curdirNum);
        this.curdirSost = state.loadVar("curdirSost", this.curdirSost);
        this.delayCnt = state.loadVar("delayCnt", this.delayCnt);
    }

    static class Direction {
        Input inp;
        Channel channelIn;
        Channel channelOut;

        Direction() {
        }
    }
}

