/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.ModbusBitTag;
import promauto.jroboplc.plugin.peripherial.ModbusTag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class ModbusModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(ModbusModule.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected int maxWriteSizeCoil = 128;
    protected int maxWriteSizeReg = 16;
    protected boolean globalWriteSingle = true;
    protected boolean globalWriteMultiple = true;
    protected boolean forcedWriteWO = false;
    protected boolean hasReadCoils;
    protected boolean hasReadDscinps;
    protected boolean hasReadHldregs;
    protected boolean hasReadInpregs;
    protected List<ModbusTag> modbustags = new ArrayList<ModbusTag>();
    protected List<ModbusBitTag> bittags = new ArrayList<ModbusBitTag>();
    private int[] buff = new int[2];

    public ModbusModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.modbustags.clear();
        Configuration cm = this.env.getConfiguration();
        String cs = cm.get(conf, "charset", "");
        if (!cs.isEmpty()) {
            this.protocol.charset = Charset.forName(cs);
        }
        this.maxWriteSizeCoil = cm.get(conf, "maxWriteSizeInp", this.maxWriteSizeCoil);
        this.maxWriteSizeReg = cm.get(conf, "maxWriteSizeReg", this.maxWriteSizeReg);
        this.globalWriteSingle = cm.get(conf, "writeSingle", this.globalWriteSingle);
        this.globalWriteMultiple = cm.get(conf, "writeMultiple", this.globalWriteMultiple);
        this.forcedWriteWO = cm.get(conf, "forcedWriteWO", this.forcedWriteWO);
        if (!this.loadModbusTags(conf)) {
            return false;
        }
        this.init();
        return true;
    }

    protected boolean loadModbusTags(Object conf) {
        Configuration cm = this.env.getConfiguration();
        try {
            for (Object conf_tag : cm.toList(cm.get(conf, "tags"))) {
                ModbusTag mtag = new ModbusTag();
                mtag.name = cm.get(conf_tag, "name", mtag.name);
                mtag.type = ModbusTag.Type.valueOf(cm.get(conf_tag, "type", mtag.type.toString()).toUpperCase());
                mtag.inverted = cm.get(conf_tag, "inverted", mtag.inverted);
                mtag.region = ModbusTag.Region.valueOf(cm.get(conf_tag, "region", mtag.region.toString()).toUpperCase());
                mtag.access = ModbusTag.Access.valueOf(cm.get(conf_tag, "access", mtag.access.toString()).toUpperCase());
                mtag.address = cm.get(conf_tag, "address", mtag.address);
                mtag.littleEndian = cm.get(conf_tag, "littleEndian", mtag.littleEndian);
                mtag.readEnd = cm.get(conf_tag, "readEnd", mtag.readEnd);
                mtag.readOnce = cm.get(conf_tag, "readOnce", mtag.readOnce);
                mtag.writeSingle = cm.get(conf_tag, "writeSingle", mtag.writeSingle);
                mtag.writeMultiple = cm.get(conf_tag, "writeMultiple", mtag.writeMultiple);
                mtag.enable = cm.get(conf_tag, "enable", mtag.enable);
                mtag.size = cm.get(conf_tag, "size", mtag.size);
                mtag.tracktagName = cm.get(conf_tag, "tracktag", mtag.tracktagName);
                mtag.bitNameOnly = cm.get(conf_tag, "bitNameOnly", mtag.bitNameOnly);
                Object confBits = cm.get(conf_tag, "bits");
                if (confBits != null) {
                    cm.toMap(confBits).forEach((bitname, mask) -> this.addModbusBitTag(mtag, (String)bitname, Integer.parseInt(mask.toString())));
                }
                this.addModbusTag(mtag);
            }
        }
        catch (IllegalArgumentException e) {
            this.env.printError(this.logger, e, this.name);
            return false;
        }
        return true;
    }

    protected ModbusTag addModbusTag(ModbusTag mtag) {
        mtag.init();
        this.tagtable.add(mtag.tag);
        this.modbustags.add(mtag);
        return mtag;
    }

    protected TagRW addModbusBitTag(ModbusTag mtag, String bitname, int mask) {
        TagRW tag = null;
        if (mtag.type == ModbusTag.Type.UINT16) {
            String tagname = mtag.bitNameOnly ? bitname : mtag.name + '.' + bitname;
            tag = this.tagtable.createRWInt(tagname, 0, 8);
            this.bittags.add(new ModbusBitTag(mtag.name, mask, tag));
        }
        return tag;
    }

    private void init() {
        this.modbustags.sort((a, b) -> a.address - b.address);
        this.hasReadCoils = false;
        this.hasReadDscinps = false;
        this.hasReadHldregs = false;
        this.hasReadInpregs = false;
        for (ModbusTag mtag : this.modbustags) {
            if (mtag.access == ModbusTag.Access.WO) continue;
            this.hasReadCoils |= mtag.enable && mtag.region == ModbusTag.Region.COIL;
            this.hasReadDscinps |= mtag.enable && mtag.region == ModbusTag.Region.DSCINP;
            this.hasReadHldregs |= mtag.enable && mtag.region == ModbusTag.Region.HLDREG;
            this.hasReadInpregs |= mtag.enable && mtag.region == ModbusTag.Region.INPREG;
        }
        try {
            Map<String, ModbusTag> map = this.modbustags.stream().collect(Collectors.toMap(c -> c.name, c -> c));
            for (ModbusTag mt : this.modbustags) {
                if (mt.tracktagName.isEmpty()) continue;
                mt.tracktag = map.get(mt.tracktagName);
            }
        }
        catch (IllegalStateException e) {
            this.env.printError(this.logger, this.name, "Duplicate tagname");
        }
        this.bittags.forEach(btag -> {
            btag.reftag = (TagRW)this.tagtable.get(btag.refTagname);
        });
        this.bittags.removeIf(btag -> btag.reftag == null);
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        this.processBittagsWrites();
        if (this.emulated) {
            for (ModbusTag mtag2 : this.modbustags) {
                mtag2.tag.acceptWriteValue();
            }
        } else {
            if (this.firstPass || this.tagError.getBool()) {
                this.modbustags.stream().filter(ModbusTag::isWriteOnly).forEach(mtag -> mtag.tag.raiseWriteValue());
            }
            boolean needWriteReg = false;
            boolean needWriteCoil = false;
            for (ModbusTag mtag3 : this.modbustags) {
                if (mtag3.access == ModbusTag.Access.RO) continue;
                mtag3.needWrite = mtag3.enable && (mtag3.tag.hasWriteValue() || mtag3.tracktag != null && !mtag3.tag.equalsValue(mtag3.tracktag.tag) || this.forcedWriteWO && mtag3.access == ModbusTag.Access.WO);
                needWriteCoil |= mtag3.needWrite && mtag3.region == ModbusTag.Region.COIL;
                needWriteReg |= mtag3.needWrite && mtag3.region == ModbusTag.Region.HLDREG;
            }
            if (needWriteReg) {
                result = this.writeMultiple(ModbusTag.Region.HLDREG);
                result &= this.writeSingle(ModbusTag.Region.HLDREG);
            }
            if (needWriteCoil) {
                result &= this.writeMultiple(ModbusTag.Region.COIL);
                result &= this.writeSingle(ModbusTag.Region.COIL);
            }
            if (this.hasReadHldregs) {
                result &= this.readRegisters(ModbusTag.Region.HLDREG);
            }
            if (this.hasReadInpregs) {
                result &= this.readRegisters(ModbusTag.Region.INPREG);
            }
            if (this.hasReadCoils) {
                result &= this.readRegisters(ModbusTag.Region.COIL);
            }
            if (this.hasReadDscinps) {
                result &= this.readRegisters(ModbusTag.Region.DSCINP);
            }
        }
        this.processBittagsReads();
        return result;
    }

    private void processBittagsWrites() {
        this.bittags.stream().filter(btag -> btag.tag.hasWriteValue()).forEach(ModbusBitTag::writeValue);
    }

    private void processBittagsReads() {
        this.bittags.forEach(ModbusBitTag::readValue);
    }

    private boolean writeMultiple(ModbusTag.Region region) {
        int maxWriteSize;
        if (!this.globalWriteMultiple) {
            return true;
        }
        int n = maxWriteSize = region == ModbusTag.Region.HLDREG ? this.maxWriteSizeReg : this.maxWriteSizeCoil;
        if (maxWriteSize <= 0) {
            return true;
        }
        int beg = 0;
        int end = 0;
        int size = 0;
        int buffsize = 0;
        int nextaddr = 0;
        for (int i = 0; i < this.modbustags.size(); ++i) {
            ModbusTag mtag = this.modbustags.get(i);
            if (size >= maxWriteSize || size > 0 && mtag.address != nextaddr) {
                if (!this.writeMultiple1(region, beg, end, buffsize)) {
                    return false;
                }
                size = 0;
                buffsize = 0;
            }
            if (!mtag.needWrite || !mtag.writeMultiple || mtag.region != region) continue;
            if (size == 0) {
                beg = i;
            }
            end = i;
            ++size;
            buffsize += mtag.size;
            nextaddr = mtag.address + mtag.size;
        }
        return size <= 0 || this.writeMultiple1(region, beg, end, buffsize);
    }

    private boolean writeMultiple1(ModbusTag.Region region, int beg, int end, int buffsize) {
        if (beg > end || buffsize == 1 && this.modbustags.get((int)beg).writeSingle && this.globalWriteSingle) {
            return true;
        }
        this.adjustBuff(buffsize);
        int pbuff = 0;
        for (int j = beg; j <= end; ++j) {
            ModbusTag mtag = this.modbustags.get(j);
            if (mtag.access == ModbusTag.Access.RO) continue;
            mtag.putValueIntoBuff(this.buff, pbuff);
            if (mtag.access == ModbusTag.Access.WO) {
                mtag.tag.copyLastWriteToRead();
            }
            mtag.needWrite = false;
            pbuff += mtag.size;
        }
        boolean result = false;
        try {
            boolean bl = result = region == ModbusTag.Region.HLDREG ? this.protocol.requestCmd10(this.modbustags.get((int)beg).address, buffsize, this.buff) : this.protocol.requestCmd0F(this.modbustags.get((int)beg).address, buffsize, this.buff);
            if (!result) {
                for (int i = beg; i <= end; ++i) {
                    this.modbustags.get((int)i).tag.raiseWriteValue();
                }
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return result;
    }

    private boolean writeSingle(ModbusTag.Region region) {
        if (!this.globalWriteSingle) {
            return true;
        }
        boolean result = false;
        try {
            for (ModbusTag mtag : this.modbustags) {
                if (!mtag.needWrite || !mtag.writeSingle || mtag.region != region) continue;
                mtag.needWrite = false;
                if (mtag.access == ModbusTag.Access.WO) {
                    mtag.tag.copyLastWriteToRead();
                }
                if (region == ModbusTag.Region.HLDREG) {
                    int size = mtag.size;
                    this.adjustBuff(size);
                    mtag.putValueIntoBuff(this.buff, 0);
                    for (int i = 0; i < size; ++i) {
                        result = this.protocol.requestCmd6(mtag.address + i, this.buff[i]);
                    }
                } else {
                    result = this.protocol.requestCmd5(mtag.address, mtag.tag.getWriteValInt());
                }
                if (result) continue;
                mtag.tag.raiseWriteValue();
                return false;
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return true;
    }

    private boolean readRegisters(ModbusTag.Region region) {
        try {
            boolean isReg = region == ModbusTag.Region.HLDREG || region == ModbusTag.Region.INPREG;
            boolean result = false;
            int beg = -1;
            int end = -1;
            for (int i = 0; i < this.modbustags.size(); ++i) {
                ModbusTag mtag = this.modbustags.get(i);
                if (mtag.enable && mtag.region == region && mtag.access != ModbusTag.Access.WO && (!mtag.readOnce || this.tagError.getBool())) {
                    if (beg == -1) {
                        beg = i;
                    }
                    end = i;
                }
                if (end < 0 || !this.modbustags.get((int)end).readEnd && i != this.modbustags.size() - 1) continue;
                int addrbeg = this.modbustags.get((int)beg).address;
                int size = this.modbustags.get((int)end).address + this.modbustags.get((int)end).size - addrbeg;
                switch (region) {
                    case HLDREG: {
                        result = this.protocol.requestCmd3(addrbeg, size);
                        break;
                    }
                    case INPREG: {
                        result = this.protocol.requestCmd4(addrbeg, size);
                        break;
                    }
                    case COIL: {
                        result = this.protocol.requestCmd1(addrbeg, size);
                        break;
                    }
                    case DSCINP: {
                        result = this.protocol.requestCmd2(addrbeg, size);
                    }
                }
                if (!result) {
                    return false;
                }
                for (int j = beg; j <= end; ++j) {
                    mtag = this.modbustags.get(j);
                    if (mtag.region != region || mtag.access == ModbusTag.Access.WO) continue;
                    if (isReg) {
                        mtag.fetchValueFromProtocolBuffin(this.protocol, mtag.address - addrbeg);
                        continue;
                    }
                    mtag.tag.setReadValBool(this.protocol.getAnswerBit(mtag.address - addrbeg) > 0 ^ mtag.inverted);
                }
                beg = -1;
                end = -1;
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            return false;
        }
        return true;
    }

    public void adjustBuff(int size) {
        if (this.buff.length < size) {
            this.buff = new int[size];
        }
    }

    @Override
    protected boolean reload() {
        ModbusModule tmp = new ModbusModule(this.plugin, this.name);
        return this.reloadFrom(tmp);
    }

    protected boolean reloadFrom(ModbusModule tmp) {
        TagRW tag;
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.maxWriteSizeCoil = tmp.maxWriteSizeCoil;
        this.maxWriteSizeReg = tmp.maxWriteSizeReg;
        this.globalWriteSingle = tmp.globalWriteSingle;
        this.globalWriteMultiple = tmp.globalWriteMultiple;
        this.forcedWriteWO = tmp.forcedWriteWO;
        for (ModbusTag mtag : this.modbustags) {
            Tag found = tmp.tagtable.get(mtag.tag.getName());
            if (found != null && found.getType() == mtag.tag.getType() && found instanceof TagRW) continue;
            this.tagtable.remove(mtag.tag);
        }
        for (ModbusTag mtag : tmp.modbustags) {
            tag = (TagRW)this.tagtable.get(mtag.tag.getName());
            if (tag == null) {
                this.tagtable.add(mtag.tag);
                continue;
            }
            mtag.tag = tag;
        }
        this.modbustags = tmp.modbustags;
        this.bittags.stream().map(btag -> btag.tag.getName()).filter(tagname -> tmp.tagtable.get((String)tagname) == null).forEach(tagname -> this.tagtable.remove((String)tagname));
        for (ModbusBitTag btag2 : tmp.bittags) {
            tag = (TagRW)this.tagtable.get(btag2.tag.getName());
            if (tag == null) {
                this.tagtable.add(btag2.tag);
                continue;
            }
            btag2.tag = tag;
        }
        this.bittags = tmp.bittags;
        this.init();
        this.updateTagsStatus();
        return true;
    }
}

