/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceZDVS
extends Device {
    Input inpInput;
    Input inpEnable;
    Input inpDoOpenFull;
    Input inpDoOpenMid;
    Tag tagOutput;
    Tag tagSost;
    Tag tagInOut;
    Tag tagControl;
    Tag tagBlok;
    Tag tagFlags;
    Channel chnlClOut;
    Channel chnlOpOut;
    Channel chnlMiOut;
    Channel chnlClIn;
    Channel chnlOpIn;
    Channel chnlMiIn;
    int cmd;
    int cur_pos;
    int last_pos;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.createTagDescr();
        this.inpInput = this.getInput("Input", res);
        this.inpEnable = this.getInput("Enable", res);
        this.inpDoOpenFull = this.getInput("DoOpenFull", res);
        this.inpDoOpenMid = this.getInput("DoOpenMid", res);
        this.tagOutput = this.getOutputTag("Output", res);
        this.tagSost = this.getOutputTag("Sost", res);
        this.tagInOut = this.getOutputTag("InOut", res);
        this.tagControl = this.getOutputTag("Control", res);
        this.tagBlok = this.getOutputTag("Blok", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.chnlClOut = this.createChannel("ChnlClOut", Channel.Type.Out, res);
        this.chnlOpOut = this.createChannel("ChnlOpOut", Channel.Type.Out, res);
        this.chnlMiOut = this.createChannel("ChnlMiOut", Channel.Type.Out, res);
        this.chnlClIn = this.createChannel("ChnlClIn", Channel.Type.In, res);
        this.chnlOpIn = this.createChannel("ChnlOpIn", Channel.Type.In, res);
        this.chnlMiIn = this.createChannel("ChnlMiIn", Channel.Type.In, res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagOutput.setInt(0);
        this.tagSost.setInt(0);
        this.tagInOut.setInt(0);
        this.cmd = 0;
        this.cur_pos = 0;
        this.last_pos = 0;
    }

    @Override
    public boolean execute() {
        if (!(this.chnlClIn.isOk() && this.chnlClOut.isOk() && this.chnlMiIn.isOk() && this.chnlMiOut.isOk() && this.chnlOpIn.isOk() && this.chnlOpOut.isOk())) {
            this.tagSost.setInt(8);
            return false;
        }
        int flags = this.tagFlags.getInt();
        int control = this.tagControl.getInt();
        int ctrl1 = control & 0xFF;
        int ctrl2 = control >> 8 & 0xFF;
        int ctrl = ctrl1 == 0 || ctrl2 > 0 && (flags & 0x40) > 0 ? ctrl2 : ctrl1;
        this.cmd = ctrl > 0 ? ctrl : (this.inpEnable.getInt() == 0 ? 1 : (this.inpDoOpenMid.getInt() > 0 ? 4 : (this.inpDoOpenFull.getInt() > 0 ? 3 : 2)));
        this.cmd -= 2;
        int inOp = this.chnlOpIn.tagValue.getBool() == (flags & 0x80) > 0 ? 1 : 0;
        int inMi = this.chnlMiIn.tagValue.getBool() == (flags & 0x80) > 0 ? 1 : 0;
        int inCl = this.chnlClIn.tagValue.getBool() == (flags & 0x80) > 0 ? 1 : 0;
        int new_pos = 0;
        new_pos = this.tagBlok.getBool() && this.cmd >= 0 ? this.cmd : (inOp > 0 ? 1 : (inMi > 0 ? 2 : (inCl > 0 ? 0 : 3)));
        if (new_pos != this.cur_pos) {
            this.last_pos = this.cur_pos;
            this.cur_pos = new_pos;
        }
        boolean outCl = false;
        boolean outMi = false;
        boolean outOp = false;
        int x = this.cmd * 10 + this.cur_pos;
        int z = x * 10 + this.last_pos;
        if (x == 0 || x == 11 || z == 220) {
            outCl = false;
            outOp = false;
        }
        if (x == 1 || x == 2 || x == 3 || x == 21 || z == 231 || z == 233 || z == 221) {
            outCl = true;
            outOp = false;
        }
        if (x == 10 || x == 12 || x == 13 || x == 20 || z == 230 || z == 232) {
            outCl = false;
            outOp = true;
        }
        if (this.cmd < 0) {
            outCl = false;
            outOp = false;
            outMi = false;
        }
        this.tagInOut.setInt(inCl + inOp * 2 + inMi * 4 + (outCl ? 16 : 0) + (outOp ? 32 : 0) + (outMi ? 64 : 0));
        this.tagOutput.setBool(!outCl && !outOp && this.inpEnable.getInt() > 0 && this.inpInput.getInt() > 0);
        int sost = this.tagSost.getInt();
        sost = inCl + inOp > 1 ? 7 : (this.cur_pos == 2 && this.last_pos == 1 ? 5 : (this.cur_pos == 3 ? (this.last_pos == 0 ? 4 : (this.last_pos == 1 ? 5 : (this.last_pos == 2 && (this.cmd == 0 || this.cmd == 2) ? 4 : (this.last_pos == 2 && this.cmd == 1 ? 5 : 3)))) : this.cur_pos));
        this.tagSost.setInt(sost);
        this.chnlClOut.tagValue.setBool(outCl);
        this.chnlMiOut.tagValue.setBool(outMi);
        this.chnlOpOut.tagValue.setBool(outOp);
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("cmd", this.cmd);
        state.saveVar("cur_pos", this.cur_pos);
        state.saveVar("last_pos", this.last_pos);
    }

    @Override
    public void loadStateExtra(State state) {
        this.cmd = state.loadVar("cmd", this.cmd);
        this.cur_pos = state.loadVar("cur_pos", this.cur_pos);
        this.last_pos = state.loadVar("last_pos", this.last_pos);
    }
}

