/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolAA55;

public class PaPrksModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaPrksModule.class);
    protected ProtocolAA55 protocol = new ProtocolAA55(this);
    private static final int INP_SIZE = 64;
    private static final int F_OFSET = 16;
    private static final float DELITEL = 4.0f;
    private static final int F_DIVISOR = 4;
    private static final int F_POROG = 20;
    protected Tag[] inps = new Tag[64];
    protected Tag[] frqs = new Tag[64];
    private int[] tmpBuffin = new int[64];
    private int[] buffin = new int[17];
    private int[] buffout = new int[2];
    private TagRW tagFirmware;
    private Tag tagResetCnt;
    private int resetCntPeriod;
    private boolean canUseCmdA0;
    private boolean noFreq;

    public PaPrksModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.resetCntPeriod = cm.get(conf, "resetCntPeriod_s", 0) * 1000;
        this.noFreq = cm.get(conf, "noFreq", false);
        for (int i = 0; i < 64; ++i) {
            this.inps[i] = this.tagtable.createInt((i < 10 ? "inp0" : "inp") + i, 0, 8);
            if (this.noFreq) continue;
            this.frqs[i] = this.tagtable.createInt((i < 10 ? "frq0" : "frq") + i, 0, 8);
        }
        this.tagFirmware = this.tagtable.createRWString("firmware", "");
        this.tagResetCnt = this.tagtable.createInt("resetcnt", 0);
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < 64; ++i) {
            this.addChannelMapTag(chtags, this.inps[i], "" + i);
            if (this.noFreq) continue;
            this.addChannelMapTag(chtags, this.frqs[i], i + "a");
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            if (this.firstPass || this.tagError.getBool()) {
                Pattern p;
                Matcher m;
                result = this.protocol.requestFirmware(this.tagFirmware);
                this.canUseCmdA0 = false;
                if (result && (m = (p = Pattern.compile("pRKS (\\d+)\\.(\\d+)")).matcher(this.tagFirmware.getString())).matches()) {
                    int ver = Integer.parseInt(m.group(1)) * 100 + Integer.parseInt(m.group(2));
                    boolean bl = this.canUseCmdA0 = ver >= 303;
                }
            }
            if (result) {
                if (this.noFreq && this.canUseCmdA0) {
                    this.buffout[0] = 85;
                    this.buffout[1] = 160 + this.netaddr;
                    result = this.protocol.request(this.buffout, 2, this.buffin, 9, 0);
                    if (result) {
                        int mask = 1;
                        int i = 0;
                        while (i < 64) {
                            if (mask > 128) {
                                mask = 1;
                            }
                            this.tmpBuffin[i] = (this.buffin[i / 8] & mask) > 0 ? 1 : 0;
                            ++i;
                            mask <<= 1;
                        }
                        for (i = 0; i < 64; ++i) {
                            this.inps[i].setInt(this.tmpBuffin[ProtocolAA55.pRksDatConv[i]]);
                        }
                    }
                } else {
                    int cmd = 32;
                    int fstPos = 0;
                    int lstPos = 16;
                    this.buffout[0] = 85;
                    this.buffout[1] = cmd + this.netaddr;
                    for (int pos = 1; pos < 5; ++pos) {
                        lstPos = 16 * pos;
                        if (this.protocol.request(this.buffout, 2, this.buffin, 17, 0)) {
                            int i = fstPos;
                            int j = 0;
                            while (i < lstPos) {
                                this.tmpBuffin[i] = this.buffin[j];
                                ++i;
                                ++j;
                            }
                        } else {
                            result = false;
                            break;
                        }
                        this.buffout[1] = (cmd += 32) + this.netaddr;
                        fstPos = 16 * pos;
                    }
                    this.setInputsProcs();
                }
            }
            result &= this.protocol.requestResetCnt(this.tagResetCnt, this.resetCntPeriod);
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return result;
    }

    private void setInputsProcs() {
        for (int i = 0; i < 64; ++i) {
            this.inps[i].setInt((this.tmpBuffin[ProtocolAA55.pRksDatConv[i]] & 0x80) > 0 ? 1 : 0);
            if (this.noFreq) continue;
            int frq = this.tmpBuffin[ProtocolAA55.pRksDatConv[i]] & 0x7F;
            frq = Math.round((float)(frq <= 20 ? frq : (frq - 16) * 4) / 4.0f);
            this.frqs[i].setInt(frq);
        }
    }

    @Override
    protected boolean reload() {
        PaPrksModule tmp = new PaPrksModule(this.plugin, this.name);
        if (!tmp.load() || !tmp.prepare()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        if (!this.noFreq && tmp.noFreq) {
            for (Tag tag : this.frqs) {
                this.tagtable.remove(tag);
            }
        }
        if (this.noFreq && !tmp.noFreq) {
            for (int i = 0; i < this.frqs.length; ++i) {
                this.frqs[i] = tmp.frqs[i];
                this.tagtable.add(this.frqs[i]);
            }
        }
        this.noFreq = tmp.noFreq;
        this.resetCntPeriod = tmp.resetCntPeriod;
        return true;
    }
}

