/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.LinkedList;
import java.util.List;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceDTRG
extends Device {
    Input inpMasterIn;
    Input inpTrigSet;
    List<Input> inpEnable = new LinkedList<Input>();
    Tag tagOutput;
    Tag tagReady;
    int output;
    int ready;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpMasterIn = this.getInput("MasterIn", res);
        this.inpTrigSet = this.getInput("TrigSet", res);
        this.tagOutput = this.getOutputTag("Output", res);
        this.tagReady = this.getOutputTag("Ready", res);
        for (Input inp : this.inputs) {
            if (!inp.name.equals("Enable")) continue;
            this.inpEnable.add(inp);
        }
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagOutput.setInt(0);
        this.output = 0;
    }

    @Override
    public boolean execute() {
        this.ready = 1;
        for (Input inp : this.inpEnable) {
            this.ready &= inp.getInt() > 0 ? 1 : 0;
        }
        if (this.ready > 0 && this.inpTrigSet.getInt() > 0) {
            this.output = this.inpMasterIn.getInt();
        }
        this.tagOutput.setInt(this.output);
        this.tagReady.setInt(this.ready);
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("output", this.output);
        state.saveVar("ready", this.ready);
    }

    @Override
    public void loadStateExtra(State state) {
        this.output = state.loadVar("output", this.output);
        this.ready = state.loadVar("ready", this.ready);
    }
}

