/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.tagsaver;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagPlain;
import promauto.jroboplc.plugin.tagsaver.CmdLoad;
import promauto.utils.Numbers;

public class TagsaverModule
extends AbstractModule
implements Signal.Listener {
    private static final Charset charset = Charset.forName("UTF-8");
    private static final int IDX_CRC = 0;
    private static final int IDX_MODNAME = 2;
    private static final int IDX_TAGNAME = 3;
    private static final int IDX_VALUE = 4;
    private static final String CR_LF = "\r\n";
    private static final String CRC_OFF = "crc:off";
    private static final int CRC_LENGHT = 8;
    private static final String TAGSAVER_FORMAT_1 = "tagsaver.format:1";
    private final Logger logger = LoggerFactory.getLogger(TagsaverModule.class);
    private static DateTimeFormatter dtFormatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_");
    private volatile boolean hasSignalReload = false;
    protected Set<TagRec> tags;
    private Path pathSave;
    private Path pathChng;
    private Path pathSaveMir;
    private Path pathChngMir;
    private int historySize;
    private int chngLinesMax;
    private int chngLinesCnt;
    private boolean hasChanges;
    private FileChannel fchannelChng = null;
    private FileChannel fchannelChngMir = null;
    private boolean openedChng = false;
    private boolean modeReload;
    private StringBuilder sb = new StringBuilder();
    private ByteBuffer lastWriteBuffer;
    private CRC32 crcWrite = new CRC32();
    private SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd.HH:mm:ss");

    public TagsaverModule(Plugin plugin, String name) {
        super(plugin, name);
        this.env.getCmdDispatcher().addCommand(this, CmdLoad.class);
    }

    @Override
    public boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.enable = cm.get(conf, "enable", true);
        this.historySize = cm.get(conf, "history", 10);
        this.chngLinesMax = cm.get(conf, "chng.max", 10000);
        this.pathSave = cm.getPath(conf, "file.save", "saves/" + this.name + ".save");
        Map<String, Object> map = cm.toMap(conf);
        this.pathChng = map.containsKey("file.chng") ? cm.getPath(conf, "file.chng", "") : Paths.get(this.pathSave.toString() + ".chng", new String[0]);
        this.pathSaveMir = map.containsKey("mirror.save") ? cm.getPath(conf, "mirror.save", "") : Paths.get(this.pathSave + ".mirror", new String[0]);
        this.pathChngMir = map.containsKey("mirror.chng") ? cm.getPath(conf, "mirror.chng", "") : Paths.get(this.pathSaveMir + ".chng", new String[0]);
        this.modeReload = false;
        return true;
    }

    @Override
    public boolean prepareModule() {
        this.env.getModuleManager().getModules().stream().filter(m -> m != this).forEach(m -> m.addSignalListener(this));
        this.tags = this.collectTags();
        this.hasChanges = false;
        this.chngLinesCnt = 0;
        try {
            Files.createDirectories(this.pathSave.getParent(), new FileAttribute[0]);
            Files.createDirectories(this.pathChng.getParent(), new FileAttribute[0]);
            Files.createDirectories(this.pathSaveMir.getParent(), new FileAttribute[0]);
            Files.createDirectories(this.pathChngMir.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.name);
            return false;
        }
        if (!this.modeReload) {
            if (!(Files.exists(this.pathSave, new LinkOption[0]) && this.readValues(this.pathSave, this.pathChng) || !Files.exists(this.pathSaveMir, new LinkOption[0]))) {
                this.env.printInfo(this.logger, this.name, "Reading from mirror...");
                if (this.readValues(this.pathSaveMir, this.pathChngMir)) {
                    this.env.printInfo(this.logger, this.name, "SUCCESS");
                    this.hasChanges = true;
                } else {
                    this.hasChanges = false;
                    return false;
                }
            }
            this.hasChanges |= !Files.exists(this.pathSave, new LinkOption[0]);
            this.hasChanges |= !Files.exists(this.pathSaveMir, new LinkOption[0]);
            this.hasChanges |= Files.exists(this.pathChng, new LinkOption[0]);
            this.hasChanges |= Files.exists(this.pathChngMir, new LinkOption[0]);
            this.merge();
        }
        for (TagRec rec : this.tags) {
            rec.tag.copyValueTo(rec.value);
        }
        return true;
    }

    private boolean readValues(Path main, Path chng) {
        if (!this.readValues(main, true)) {
            return false;
        }
        return !Files.exists(chng, new LinkOption[0]) || this.readValues(chng, false);
    }

    @Override
    public boolean executeModule() {
        if (this.hasSignalReload) {
            this.hasSignalReload = false;
            this.onSignalReload();
        }
        try {
            boolean needTotalCrc = false;
            for (TagRec rec : this.tags) {
                if (rec.tag.getStatus() == Tag.Status.Deleted) {
                    this.env.printInfo(this.logger, "Reinitialization due to a deleted tag being found: " + rec.module.getName() + ':' + rec.tag.getName());
                    this.onSignalReload();
                    return true;
                }
                if (rec.tag.equalsValue(rec.value)) continue;
                this.hasChanges = true;
                rec.tag.copyValueTo(rec.value);
                this.openFileChg();
                if (!this.openedChng) break;
                this.writeTag(this.fchannelChng, rec, new Date());
                this.lastWriteBuffer.rewind();
                this.fchannelChngMir.write(this.lastWriteBuffer);
                ++this.chngLinesCnt;
                needTotalCrc = true;
            }
            if (needTotalCrc) {
                try {
                    this.writeTotalCrc(this.fchannelChng);
                    this.fchannelChng.force(false);
                    this.lastWriteBuffer.rewind();
                    this.fchannelChngMir.write(this.lastWriteBuffer);
                    this.fchannelChngMir.force(false);
                }
                catch (IOException e) {
                    this.env.printError(this.logger, e, this.name);
                }
            }
            this.closeChng();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name, "File:", this.pathChng.toString());
        }
        if (this.chngLinesCnt > this.chngLinesMax) {
            this.merge();
        }
        return true;
    }

    private Path getHistoryDir(Path file) {
        Path dir = file.getParent();
        if (dir == null) {
            dir = Paths.get(".", new String[0]);
        }
        dir = dir.resolve("history");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.name);
        }
        return dir;
    }

    private void deleteOldHistory(Path file) {
        Path dir = this.getHistoryDir(file);
        TreeMap<String, Path> map = new TreeMap<String, Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "????????_??????_" + file.getFileName());){
            for (Path path : stream) {
                map.put(path.getFileName().toString(), path);
            }
            int i = map.size() - this.historySize;
            for (Path path : map.values()) {
                if (i-- <= 0) {
                    break;
                }
                Files.delete(path);
            }
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.name);
        }
    }

    private Set<TagRec> collectTags() {
        TreeSet<TagRec> tags = new TreeSet<TagRec>();
        for (Module module : this.env.getModuleManager().getModules()) {
            if (!this.isFlagCompatibleWith("AUTOSAVE", module)) continue;
            for (Tag tag : module.getTagTable().getTags("", true)) {
                if (!tag.hasFlags(1) || tag.getStatus() == Tag.Status.Deleted) continue;
                tags.add(new TagRec(module, tag));
            }
        }
        return tags;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean readValues(Path file, boolean checkTotalHash) {
        CRC32 crcRead = new CRC32();
        int version = -1;
        boolean result = false;
        boolean lineHashError = false;
        int totalCnt = 0;
        boolean totalHashError = true;
        boolean hasInitialHash = false;
        String line = null;
        if (!Files.exists(file, new LinkOption[0])) return result;
        try (BufferedReader reader = Files.newBufferedReader(file, charset);){
            Module module = null;
            Tag tag = null;
            boolean hasTotalCrc = false;
            boolean enableCrc = true;
            crcRead.reset();
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                String hash2;
                boolean digested;
                String[] ss;
                if (version == -1) {
                    for (String s : ss = line.split("\\s*;\\s*")) {
                        if (s.equals(TAGSAVER_FORMAT_1)) {
                            version = 1;
                            continue;
                        }
                        if (!s.equals(CRC_OFF)) continue;
                        enableCrc = false;
                        this.hasChanges = true;
                    }
                    if (version > 0) continue;
                    version = 0;
                }
                if (version == 1) {
                    long crc_theirs;
                    long crc_ours3;
                    ss = line.split("\\t+");
                    if (ss.length == 4 || ss.length == 5) {
                        String value;
                        String crc = ss[0];
                        String mod = ss[2];
                        String tagname = ss[3];
                        String string = value = ss.length == 5 ? ss[4] : "";
                        if (enableCrc) {
                            String line1 = line.substring(crc.length());
                            crcRead.update(line1.getBytes(charset));
                            long crc_ours2 = crcRead.getValue();
                            long crc_theirs2 = Long.parseLong(crc, 16);
                            if (crc_ours2 != crc_theirs2) {
                                this.env.printError(this.logger, this.name, "Bad line crc:", file.toString() + CR_LF + line);
                                boolean bl = false;
                                return bl;
                            }
                        }
                        digested = false;
                        module = this.env.getModuleManager().getModule(mod);
                        if (module != null && this.isFlagCompatibleWith("AUTOSAVE", module) && (tag = module.getTagTable().get(tagname)) != null && tag.hasFlags(1)) {
                            try {
                                tag.setString(value);
                                digested = true;
                            }
                            catch (NumberFormatException e) {
                                this.env.printError(this.logger, e, this.name, file.toString() + CR_LF + line);
                            }
                            ++totalCnt;
                        }
                        if (digested) continue;
                        this.env.printInfo(this.logger, this.name, "Forgetting save value: ", mod + "." + tagname + " = " + value);
                        this.hasChanges = true;
                        continue;
                    }
                    if (ss.length != 1) {
                        this.env.printError(this.logger, this.name, "Bad line format:", file.toString() + CR_LF + line);
                        boolean crc_ours3 = false;
                        return crc_ours3;
                    }
                    if (enableCrc && (crc_ours3 = 0xFFFFFFFFL - crcRead.getValue()) != (crc_theirs = Long.parseLong(ss[0], 16))) {
                        this.env.printError(this.logger, this.name, "Bad TOTAL crc:", file.toString() + CR_LF + line);
                        boolean bl = false;
                        return bl;
                    }
                    hasTotalCrc = true;
                    continue;
                }
                if (version != 0) continue;
                if (line.length() > 0 && line.charAt(0) == '#') {
                    String hhash2;
                    if (hasInitialHash) {
                        totalHashError = false;
                        break;
                    }
                    String hhash1 = Integer.toString(Math.abs(sb.toString().hashCode()), 36);
                    totalHashError = !hhash1.equals(hhash2 = line.substring(1));
                    break;
                }
                ss = line.split("\\t");
                if (ss.length != 4) continue;
                digested = false;
                String hash1 = Integer.toString(Math.abs(line.substring(0, line.length() - ss[3].length()).hashCode()), 36);
                if (ss[3].equals("initial")) {
                    hasInitialHash = true;
                    hash2 = hash1;
                } else {
                    hash2 = ss[3];
                }
                if (!hash1.equals(hash2)) {
                    lineHashError = true;
                    this.env.printError(this.logger, this.name, "File:", file.toString(), "Hash error:", line);
                } else {
                    module = this.env.getModuleManager().getModule(ss[0]);
                    if (module != null && this.isFlagCompatibleWith("AUTOSAVE", module) && (tag = module.getTagTable().get(ss[1])) != null && tag.hasFlags(1)) {
                        try {
                            tag.setString(ss[2]);
                            digested = true;
                        }
                        catch (NumberFormatException e) {
                            this.env.printError(this.logger, e, this.name, "File:", file.toString(), "Line:", line);
                        }
                        ++totalCnt;
                    }
                }
                if (!digested) {
                    this.env.printInfo(this.logger, this.name, "Forgetting save value: ", ss[0] + "." + ss[1] + " = " + ss[2]);
                    this.hasChanges = true;
                }
                sb.append(ss[3]);
            }
            if (version == 1 && !hasTotalCrc) {
                throw new Exception("Total crc is absent");
            }
            result = true;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name, "File:", file.toString());
            result = false;
        }
        if (version == 1 && result) {
            if (totalCnt == this.tags.size()) return result;
            this.hasChanges = true;
            return result;
        }
        if (version != 0) return result;
        if (!result) return result;
        if (hasInitialHash || totalCnt != this.tags.size()) {
            this.hasChanges = true;
        }
        if (checkTotalHash && totalHashError) {
            this.env.printError(this.logger, this.name, "File:", file.toString(), "Total hash error");
            result = false;
        }
        if (!lineHashError) return result;
        return false;
    }

    private boolean saveValues(Path path) {
        boolean result = false;
        this.renameFile(path);
        Date date = new Date();
        this.crcWrite.reset();
        try (FileChannel fchannel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            this.writeHeader(fchannel);
            for (TagRec rec : this.tags) {
                this.writeTag(fchannel, rec, date);
            }
            this.writeTotalCrc(fchannel);
            result = true;
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.name, "File:", path.toString());
        }
        return result;
    }

    private void writeHeader(FileChannel fchannel) throws IOException {
        this.lastWriteBuffer = ByteBuffer.wrap("tagsaver.format:1\r\n".getBytes(charset));
        fchannel.write(this.lastWriteBuffer);
    }

    private void writeTotalCrc(FileChannel fchannel) throws IOException {
        String totalcrc = Numbers.toHexString(-1L - this.crcWrite.getValue(), 8);
        this.lastWriteBuffer = ByteBuffer.wrap(totalcrc.getBytes(charset));
        fchannel.write(this.lastWriteBuffer);
        fchannel.force(false);
    }

    private void writeTag(FileChannel fchannel, TagRec rec, Date date) throws IOException {
        this.sb.setLength(0);
        this.sb.append('\t');
        this.sb.append(this.sdf.format(date));
        this.sb.append('\t');
        this.sb.append(rec.module.getName());
        this.sb.append('\t');
        this.sb.append(rec.tag.getName());
        this.sb.append("\t\t\t");
        this.sb.append(rec.tag.getString());
        this.crcWrite.update(this.sb.toString().getBytes(charset));
        String linecrc = Numbers.toHexString((int)this.crcWrite.getValue(), 8);
        this.sb.insert(0, linecrc);
        this.sb.append(CR_LF);
        this.lastWriteBuffer = ByteBuffer.wrap(this.sb.toString().getBytes(charset));
        fchannel.write(this.lastWriteBuffer);
    }

    @Override
    public boolean closedownModule() {
        this.env.getModuleManager().getModules().stream().forEach(m -> m.removeSignalListener(this));
        this.merge();
        return true;
    }

    protected void merge() {
        if (this.hasChanges) {
            if (this.saveValues(this.pathSave)) {
                this.renameFile(this.pathChng);
                this.deleteOldHistory(this.pathSave);
                this.deleteOldHistory(this.pathChng);
            }
            if (this.saveValues(this.pathSaveMir)) {
                this.renameFile(this.pathChngMir);
                this.deleteOldHistory(this.pathSaveMir);
                this.deleteOldHistory(this.pathChngMir);
            }
        }
        this.hasChanges = false;
        this.chngLinesCnt = 0;
        this.crcWrite.reset();
    }

    private void renameFile(Path file) {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                String newname = LocalDateTime.now().format(dtFormatter) + file.getFileName();
                Path newfile = Paths.get(newname, new String[0]);
                Path dir = this.getHistoryDir(file);
                newfile = dir.resolve(newfile);
                Files.move(file, newfile, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.name, "File renaming error:", file.toString());
        }
    }

    private boolean openFileChg() {
        if (this.openedChng) {
            return true;
        }
        try {
            this.fchannelChng = this.openForAppend(this.pathChng);
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.name, "File:", this.pathChng.toString());
            return false;
        }
        try {
            this.fchannelChngMir = this.openForAppend(this.pathChngMir);
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.name, "File:", this.pathChngMir.toString());
            try {
                this.fchannelChng.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        this.openedChng = true;
        return true;
    }

    private FileChannel openForAppend(Path path) throws IOException {
        FileChannel fc;
        if (Files.exists(path, new LinkOption[0])) {
            fc = FileChannel.open(path, StandardOpenOption.WRITE);
            long pos = fc.size() - 8L;
            if (pos > 0L) {
                fc.position(pos);
            }
        } else {
            fc = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            this.writeHeader(fc);
        }
        return fc;
    }

    private void closeChng() {
        if (this.openedChng) {
            try {
                this.fchannelChng.close();
            }
            catch (IOException e) {
                this.env.printError(this.logger, e, this.name);
            }
            try {
                this.fchannelChngMir.close();
            }
            catch (IOException e) {
                this.env.printError(this.logger, e, this.name);
            }
            this.openedChng = false;
        }
    }

    @Override
    public void onSignal(Module sender, Signal signal) {
        this.hasSignalReload = true;
    }

    private void onSignalReload() {
        int size_before = this.tags.size();
        Set<TagRec> newtags = this.collectTags();
        this.tags.retainAll(newtags);
        this.tags.removeIf(rec -> rec.tag.getStatus() == Tag.Status.Deleted);
        int size_after = this.tags.size();
        newtags.removeAll(this.tags);
        this.tags.addAll(newtags);
        this.hasChanges = this.hasChanges || size_before != size_after || newtags.size() > 0;
        this.merge();
    }

    @Override
    public String getInfo() {
        return this.enable ? "tags=" + this.tags.size() : "disabled";
    }

    @Override
    protected boolean reload() {
        boolean res = false;
        TagsaverModule tmp = new TagsaverModule(this.plugin, this.name);
        if (tmp.load()) {
            tmp.modeReload = true;
            try {
                if (tmp.prepare()) {
                    this.copySettingsFrom(tmp);
                    this.pathSave = tmp.pathSave;
                    this.pathChng = tmp.pathChng;
                    this.pathSaveMir = tmp.pathSaveMir;
                    this.pathChngMir = tmp.pathChngMir;
                    this.fchannelChng = tmp.fchannelChng;
                    this.fchannelChngMir = tmp.fchannelChngMir;
                    this.historySize = tmp.historySize;
                    this.chngLinesCnt = tmp.chngLinesCnt;
                    this.chngLinesMax = tmp.chngLinesMax;
                    this.tags.clear();
                    this.tags.addAll(tmp.tags);
                    this.hasChanges = true;
                    this.merge();
                    res = true;
                }
            }
            finally {
                tmp.closedown();
            }
        }
        return res;
    }

    protected static class TagRec
    implements Comparable<TagRec> {
        Module module;
        Tag tag;
        Tag value;

        public TagRec(Module module, Tag tag) {
            this.module = module;
            this.tag = tag;
            this.value = TagPlain.create(tag);
        }

        @Override
        public int compareTo(TagRec o) {
            int res = this.module.getName().compareTo(o.module.getName());
            if (res != 0) {
                return res;
            }
            res = this.tag.getName().compareTo(o.tag.getName());
            if (res != 0) {
                return res;
            }
            return this.tag.getType().ordinal() - o.tag.getType().ordinal();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TagRec)) {
                return false;
            }
            TagRec tagrec = (TagRec)o;
            return this.module.getName().equals(tagrec.module.getName()) && this.tag.getName().equals(tagrec.tag.getName()) && this.tag.getType() == tagrec.tag.getType();
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.module.getName().hashCode();
            result = 31 * result + this.tag.getName().hashCode();
            result = 31 * result + this.tag.getType().ordinal();
            return result;
        }
    }
}

