/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.kkormsvr;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import promauto.jroboplc.plugin.kkormsvr.KkormsvrModule;

class LiveData {
    private final KkormsvrModule module;
    private boolean hasChanges;
    private Map<String, Rec> data = new HashMap<String, Rec>();

    LiveData(KkormsvrModule module) {
        this.module = module;
        this.hasChanges = false;
    }

    int getInt(String name, int defval) {
        Rec rec = this.data.get(name);
        if (rec == null) {
            return defval;
        }
        return (int)rec.value;
    }

    long getLong(String name, long defval) {
        Rec rec = this.data.get(name);
        if (rec == null) {
            return defval;
        }
        return rec.value;
    }

    void set(String name, long value) {
        Rec rec = this.data.get(name);
        if (rec == null) {
            rec = new Rec(0, name, value, true);
            this.data.put(name, rec);
            this.hasChanges = true;
        } else if (rec.value != value) {
            rec.value = value;
            rec.hasChanges = true;
            this.hasChanges = true;
        }
    }

    void load() throws SQLException {
        this.data.clear();
        this.hasChanges = false;
        String sql = "select ld.id, ld.name, ldv.val from kk_livedata ld left join kk_livedataval ldv on ldv.id = ld.id";
        try (ResultSet rs = this.module.getStatement().executeQuery(sql);){
            while (rs.next()) {
                this.data.put(rs.getString("name"), new Rec(rs.getInt("id"), rs.getString("name"), rs.getLong("val"), false));
            }
        }
    }

    void update() throws SQLException {
        if (!this.hasChanges) {
            return;
        }
        Statement st = this.module.getStatement();
        for (Rec rec : this.data.values()) {
            String sql;
            if (!rec.hasChanges) continue;
            if (rec.id == 0) {
                sql = String.format("insert into kk_livedata (name) values ('%s')", rec.name);
                rec.id = this.module.getDatabase().insertReturningId(st, sql, new String[0]);
            } else {
                sql = String.format("delete from kk_livedataval where id=%d", rec.id);
                st.executeUpdate(sql);
            }
            sql = String.format("insert into kk_livedataval (id, val) values (%d, %d)", rec.id, rec.value);
            st.executeUpdate(sql);
            rec.hasChanges = false;
        }
        this.hasChanges = false;
    }

    private static class Rec {
        int id;
        String name;
        long value;
        boolean hasChanges;

        Rec(int id, String name, long value, boolean hasChanges) {
            this.id = id;
            this.name = name;
            this.value = value;
            this.hasChanges = hasChanges;
        }
    }
}

