/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.LinkedList;
import java.util.List;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;
import promauto.jroboplc.plugin.roboplant.Output;

public class DeviceSEQ
extends Device {
    Input inpInput;
    Input inpStop1;
    Input inpStop2;
    Input inpReset;
    Input inpSuspend;
    Tag tagOutput;
    Tag tagStop1;
    Tag tagStop2;
    Tag tagMode;
    Tag tagCurOut;
    Tag tagCnt;
    int outAmount;
    List<Tag> tagOut = new LinkedList<Tag>();
    List<Tag> tagTimeStart = new LinkedList<Tag>();
    List<Tag> tagTimeStopA = new LinkedList<Tag>();
    List<Tag> tagTimeStopB = new LinkedList<Tag>();
    int mode;
    int curOut;
    int cnt;
    int output;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpInput = this.getInput("Input", res);
        this.inpStop1 = this.getInput("Stop1", res);
        this.inpStop2 = this.getInput("Stop2", res);
        this.inpReset = this.getInput("Reset", res);
        this.inpSuspend = this.getInput("Suspend", res);
        this.tagOutput = this.getOutputTag("Output", res);
        this.tagStop1 = this.getOutputTag("Stop1", res);
        this.tagStop2 = this.getOutputTag("Stop2", res);
        this.tagMode = this.getOutputTag("Mode", res);
        this.tagCurOut = this.getOutputTag("CurOut", res);
        this.tagCnt = this.getOutputTag("Cnt", res);
        this.prepareOutputArrays();
        if (res.value) {
            this.resetState();
        }
    }

    private void prepareOutputArrays() {
        this.tagOut.clear();
        this.tagTimeStart.clear();
        this.tagTimeStopA.clear();
        this.tagTimeStopB.clear();
        for (int i = 0; i < 128; ++i) {
            String s = String.format("%03d", i);
            Output output = this.getOutput("TimeStart" + s);
            if (output == null) break;
            this.tagTimeStart.add(output.tag);
            output = this.getOutput("TimeStopA" + s);
            if (output == null) break;
            this.tagTimeStopA.add(output.tag);
            output = this.getOutput("TimeStopB" + s);
            if (output == null) break;
            this.tagTimeStopB.add(output.tag);
            output = this.getOutput("Out_" + s);
            if (output == null) break;
            this.tagOut.add(output.tag);
        }
        this.outAmount = this.tagOut.size();
    }

    protected void resetState() {
        this.tagOutput.setInt(0);
        this.tagStop1.setInt(0);
        this.tagStop2.setInt(0);
        this.tagMode.setInt(0);
        this.tagCurOut.setInt(0);
        this.tagCnt.setInt(0);
        this.mode = 0;
        this.curOut = -1;
        this.cnt = 0;
        this.output = 0;
    }

    protected void setZeros() {
        this.output = 0;
        this.tagStop1.setInt(0);
        this.tagStop2.setInt(0);
        this.cnt = 0;
    }

    @Override
    public boolean execute() {
        block17: {
            block16: {
                boolean tmpSuspend;
                boolean tmpInput = this.inpInput.getInt() > 0;
                boolean tmpStop1 = this.inpStop1.getInt() > 0;
                boolean tmpStop2 = this.inpStop2.getInt() > 0;
                boolean tmpReset = this.inpReset.getInt() > 0;
                boolean bl = tmpSuspend = this.inpSuspend.getInt() > 0;
                if (tmpReset && (this.mode == 5 || this.mode == 6)) {
                    this.setZeros();
                    this.mode = 0;
                }
                if (this.mode == 5 || this.mode == 6) {
                    return true;
                }
                if (this.mode != 2 && tmpInput && !tmpStop1 && !tmpStop2 && this.curOut < this.outAmount && !tmpSuspend) {
                    this.setZeros();
                    this.mode = 2;
                    --this.curOut;
                }
                if (this.mode != 7 && tmpSuspend && !tmpStop1 && !tmpStop2 && this.curOut < this.outAmount && this.curOut >= 0) {
                    this.mode = 7;
                }
                if (this.mode != 3 && tmpStop1 && !tmpStop2 && this.curOut != -1) {
                    this.setZeros();
                    this.mode = 3;
                    ++this.curOut;
                }
                if (this.mode != 4 && tmpStop2 && this.curOut != -1) {
                    this.setZeros();
                    this.mode = 4;
                    ++this.curOut;
                }
                if (this.mode == 2 && tmpInput) {
                    block14: {
                        while (true) {
                            if (this.cnt == 0) {
                                ++this.curOut;
                            }
                            if (this.curOut < 0) {
                                this.curOut = 0;
                            }
                            if (this.curOut >= this.outAmount) break block14;
                            if (this.cnt < this.tagTimeStart.get(this.curOut).getInt()) break;
                            this.cnt = 0;
                            this.tagOut.get(this.curOut).setInt(1);
                        }
                        ++this.cnt;
                        break block16;
                    }
                    this.mode = 1;
                    this.output = 1;
                }
            }
            if (this.mode == 3 || this.mode == 4) {
                block15: {
                    while (true) {
                        if (this.cnt == 0) {
                            --this.curOut;
                        }
                        if (this.curOut >= this.outAmount) {
                            this.curOut = this.outAmount - 1;
                        }
                        if (this.curOut <= -1) break block15;
                        if (this.cnt < (this.mode == 3 ? this.tagTimeStopA.get(this.curOut).getInt() : this.tagTimeStopB.get(this.curOut).getInt())) break;
                        this.cnt = 0;
                        this.tagOut.get(this.curOut).setInt(0);
                    }
                    ++this.cnt;
                    break block17;
                }
                this.mode = this.mode == 3 ? 5 : 6;
                this.tagStop1.setBool(this.mode == 5);
                this.tagStop2.setBool(this.mode == 6);
            }
        }
        this.tagMode.setInt(this.mode);
        this.tagCurOut.setInt(this.curOut);
        this.tagCnt.setInt(this.cnt);
        this.tagOutput.setInt(this.output);
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("mode", this.mode);
        state.saveVar("curOut", this.curOut);
        state.saveVar("cnt", this.cnt);
        state.saveVar("output", this.output);
    }

    @Override
    public void loadStateExtra(State state) {
        this.mode = state.loadVar("mode", this.mode);
        this.curOut = state.loadVar("curOut", this.curOut);
        this.cnt = state.loadVar("cnt", this.cnt);
        this.output = state.loadVar("output", this.output);
    }
}

