/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagBase;
import promauto.jroboplc.core.tags.TagRWBool;
import promauto.jroboplc.core.tags.TagRWDouble;
import promauto.jroboplc.core.tags.TagRWInt;
import promauto.jroboplc.core.tags.TagRWLong;
import promauto.jroboplc.core.tags.TagRWString;

public abstract class TagRW
extends TagBase {
    protected volatile boolean valueWrChanged = false;

    public static TagRW create(Tag.Type type, String tagname, int flags) {
        switch (type) {
            case BOOL: {
                return new TagRWBool(tagname, false, flags);
            }
            case INT: {
                return new TagRWInt(tagname, 0, flags);
            }
            case LONG: {
                return new TagRWLong(tagname, 0L, flags);
            }
            case DOUBLE: {
                return new TagRWDouble(tagname, 0.0, flags);
            }
            case STRING: {
                return new TagRWString(tagname, "", flags);
            }
        }
        throw new IllegalArgumentException("Not supported tag type: " + type.name());
    }

    public TagRW(String name, int flags) {
        super(name, flags);
    }

    public void raiseWriteValue() {
        this.valueWrChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWriteValue() {
        if (this.valueWrChanged) {
            TagRW tagRW = this;
            synchronized (tagRW) {
                if (!this.valueWrChanged) {
                    return false;
                }
                this.copyWriteToLastWrite();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptWriteValue() {
        if (this.valueWrChanged) {
            TagRW tagRW = this;
            synchronized (tagRW) {
                if (!this.valueWrChanged) {
                    return false;
                }
                this.copyWriteToLastWrite();
                this.copyWriteToRead();
                return true;
            }
        }
        return false;
    }

    public void forgetWriteValue() {
        this.valueWrChanged = false;
    }

    public abstract void copyLastWriteToRead();

    protected abstract void copyWriteToLastWrite();

    protected abstract void copyWriteToRead();

    public abstract boolean getWriteValBool();

    public abstract int getWriteValInt();

    public abstract long getWriteValLong();

    public abstract double getWriteValDouble();

    public abstract String getWriteValString();

    public abstract void setReadValBool(boolean var1);

    public abstract void setReadValInt(int var1);

    public abstract void setReadValLong(long var1);

    public abstract void setReadValDouble(double var1);

    public abstract void setReadValString(String var1) throws NumberFormatException;
}

