/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;

public class TagRWDouble
extends TagRW {
    private volatile double valueRd;
    private double valueWr;
    private double valueWrLast = 0.0;

    public TagRWDouble(String name, double value, int flags) {
        super(name, flags);
        this.valueRd = value;
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.DOUBLE;
    }

    @Override
    public boolean getBool() {
        return this.valueRd != 0.0;
    }

    @Override
    public int getInt() {
        return (int)this.valueRd;
    }

    @Override
    public long getLong() {
        return (long)this.valueRd;
    }

    @Override
    public double getDouble() {
        return this.valueRd;
    }

    @Override
    public String getString() {
        return "" + this.valueRd;
    }

    @Override
    public synchronized void setBool(boolean value) {
        this.valueWr = value ? 1.0 : 0.0;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setOn() {
        this.valueWr = 1.0;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setOff() {
        this.valueWr = 0.0;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setInt(int value) {
        this.valueWr = value;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setLong(long value) {
        this.valueWr = value;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setDouble(double value) {
        this.valueWr = value;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setString(String value) {
        try {
            this.valueWr = Double.parseDouble(value.trim());
        }
        catch (NumberFormatException e) {
            this.valueWr = 0.0;
        }
        this.valueWrChanged = true;
    }

    @Override
    public boolean getWriteValBool() {
        return this.valueWrLast != 0.0;
    }

    @Override
    public int getWriteValInt() {
        return (int)this.valueWrLast;
    }

    @Override
    public long getWriteValLong() {
        return (long)this.valueWrLast;
    }

    @Override
    public double getWriteValDouble() {
        return this.valueWrLast;
    }

    @Override
    public String getWriteValString() {
        return "" + this.valueWrLast;
    }

    @Override
    public void setReadValBool(boolean value) {
        this.valueRd = value ? 1.0 : 0.0;
    }

    @Override
    public void setReadValInt(int value) {
        this.valueRd = value;
    }

    @Override
    public void setReadValLong(long value) {
        this.valueRd = value;
    }

    @Override
    public void setReadValDouble(double value) {
        this.valueRd = value;
    }

    @Override
    public void setReadValString(String value) {
        try {
            this.valueRd = Double.parseDouble(value.trim());
        }
        catch (NumberFormatException e) {
            this.valueRd = 0.0;
        }
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getDouble() == this.valueRd;
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setDouble(this.valueRd);
    }

    @Override
    protected void copyWriteToLastWrite() {
        this.valueWrChanged = false;
        this.valueWrLast = this.valueWr;
    }

    @Override
    protected void copyWriteToRead() {
        this.valueRd = this.valueWr;
    }

    @Override
    public void copyLastWriteToRead() {
        this.valueRd = this.valueWrLast;
    }
}

