/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.kkmansvr;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.api.TagRepository;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.kkmansvr.Component;
import promauto.jroboplc.plugin.kkmansvr.Cycle;
import promauto.jroboplc.plugin.kkmansvr.DataService;
import promauto.jroboplc.plugin.kkmansvr.Doser;
import promauto.jroboplc.plugin.kkmansvr.Task;

public class Line {
    public static final String NOT_FOUND = "NOT FOUND";
    private final Logger logger = LoggerFactory.getLogger(Line.class);
    public static final String TASK_INSTALL_OK = "OK";
    public static final String TASK_INSTALL_NOT_EMPTY = "NOT EMPTY";
    public static final String TASK_INSTALL_LINK_ERROR = "LINK ERROR";
    public static final String TASK_INSTALL_WRONG_LINE = "WRONG LINE";
    public static final String TASK_INSTALL_NOT_FOUND = "NOT FOUND";
    public static final String TASK_INSTALL_TOO_MANY_PRODUCTS = "TOO MANY PRODUCTS";
    public static final String TASK_INSTALL_RESET = "RESET";
    public static final String CRC_ERROR = "CRC ERROR";
    static final int LINE_IDLE = 0;
    static final int LINE_PREPARING = 1;
    static final int LINE_LOADING = 2;
    static final int LINE_COMMITTING = 3;
    static final int LINE_UNLOADING = 4;
    final List<Tag> repoTags = new ArrayList<Tag>();
    final List<Component> comps = new ArrayList<Component>();
    final List<Doser> dosers = new ArrayList<Doser>();
    final Map<Integer, Doser> idDosers = new HashMap<Integer, Doser>();
    final DataService service;
    final String modname;
    private int lineId;
    private String lineName;
    private TagRW tagTaskInstall;
    private TagRW tagTaskId;
    private TagRW tagRecipeId;
    private TagRW tagRecipeName;
    private Tag tagCycleReq;
    private TagRW tagCycleCnt;
    private TagRW tagDisable;
    private TagRW tagUnloadStart;
    private Tag tagUnloadFinished;
    private TagRW tagUnloadTimerCnt;
    private Tag tagUnloadTimerSet;
    private TagRW tagRun;
    private TagRW tagCancel;
    private TagRW tagCommit;
    private TagRW tagStatus;
    private TagRW tagSumWeightReq;
    private TagRW tagSumWeightFin;
    private TagRW tagSumWeightCtl;
    private TagRW tagControlId;
    private TagRW tagControlName;
    private TagRW tagControlDescr;
    private TagRW tagControlWeight;
    private TagRW tagControlStable;
    private TagRepository repo;

    public Line(DataService service, String modname) {
        this.service = service;
        this.modname = modname;
    }

    public boolean load(Object conf, TagTable tt) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.lineId = cm.get(conf, "lineId", 0);
        this.lineName = cm.get(conf, "lineName", "Line" + this.lineId);
        int compQnt = cm.get(conf, "compQnt", 8);
        this.loadTags(tt);
        this.dosers.clear();
        cm.toList(cm.get(conf, "dosers")).forEach(conf1 -> {
            Doser doser = new Doser();
            doser.load(conf1);
            this.dosers.add(doser);
        });
        this.comps.clear();
        for (int i = 0; i < compQnt; ++i) {
            Component comp = new Component(this, i);
            comp.loadTags(tt);
            this.comps.add(comp);
        }
        return true;
    }

    private void loadTags(TagTable tt) {
        this.repoTags.clear();
        tt.createRWInt("LineId", this.lineId);
        tt.createRWString("LineName", this.lineName);
        this.tagTaskInstall = tt.createRWString("TaskInstall", "");
        this.repoTags.add(this.tagTaskInstall);
        this.tagTaskId = tt.createRWInt("TaskId", 0);
        this.repoTags.add(this.tagTaskId);
        this.tagRecipeId = tt.createRWInt("RecipeId", 0);
        this.repoTags.add(this.tagRecipeId);
        this.tagRecipeName = tt.createRWString("RecipeName", "");
        this.repoTags.add(this.tagRecipeName);
        this.tagCycleReq = tt.createInt("CycleReq", 0);
        this.repoTags.add(this.tagCycleReq);
        this.tagCycleCnt = tt.createRWInt("CycleCnt", 0);
        this.repoTags.add(this.tagCycleCnt);
        this.tagDisable = tt.createRWBool("Disable", false);
        this.repoTags.add(this.tagDisable);
        this.tagUnloadStart = tt.createRWBool("UnloadStart", false);
        this.repoTags.add(this.tagUnloadStart);
        this.tagUnloadFinished = tt.createBool("UnloadFinished", false);
        this.repoTags.add(this.tagUnloadFinished);
        this.tagUnloadTimerCnt = tt.createRWInt("UnloadTimerCnt", 0);
        this.repoTags.add(this.tagUnloadTimerCnt);
        this.tagUnloadTimerSet = tt.createInt("UnloadTimerSet", 0);
        this.repoTags.add(this.tagUnloadTimerSet);
        this.tagRun = tt.createRWBool("Run", false);
        this.repoTags.add(this.tagRun);
        this.tagStatus = tt.createRWInt("Status", 0);
        this.repoTags.add(this.tagStatus);
        this.tagSumWeightReq = tt.createRWInt("SumWeightReq", 0);
        this.repoTags.add(this.tagSumWeightReq);
        this.tagSumWeightFin = tt.createRWInt("SumWeightFin", 0);
        this.repoTags.add(this.tagSumWeightFin);
        this.tagSumWeightCtl = tt.createRWInt("SumWeightCtl", 0);
        this.repoTags.add(this.tagSumWeightCtl);
        this.tagControlId = tt.createRWInt("ControlId", 0);
        this.repoTags.add(this.tagControlId);
        this.tagControlName = tt.createRWString("ControlName", "");
        this.repoTags.add(this.tagControlName);
        this.tagControlDescr = tt.createRWString("ControlDescr", "");
        this.repoTags.add(this.tagControlDescr);
        this.tagControlStable = tt.createRWBool("ControlStable", false);
        this.repoTags.add(this.tagControlStable);
        this.tagControlWeight = tt.createRWInt("ControlWeight", 0);
        this.tagCancel = tt.createRWBool("Cancel", false);
        this.tagCommit = tt.createRWBool("Commit", false);
    }

    public boolean init() throws SQLException {
        this.repo.load(this.modname, this.repoTags);
        this.comps.forEach(comp -> this.repo.load(this.modname, comp.repoTags));
        this.service.syncLine(this.lineId, this.lineName);
        this.idDosers.clear();
        for (Doser doser : this.dosers) {
            doser.init();
            int doserId = this.service.syncDoser(this.lineId, doser.getName(), doser.getDescr(), doser.isCanControl());
            doser.setDoserId(doserId);
            this.idDosers.put(doserId, doser);
        }
        this.service.deleteOtherDosers(this.lineId, this.idDosers.keySet());
        return true;
    }

    public void execute() throws SQLException {
        if (!this.readDosers()) {
            return;
        }
        this.updateLinkedTags();
        if (this.tagCancel.hasWriteValue() && this.tagCancel.getWriteValBool()) {
            this.cancelTask();
        }
        if (this.tagDisable.hasWriteValue()) {
            if (this.tagDisable.getWriteValBool() && this.isStatus(0)) {
                this.tagDisable.setReadValBool(true);
            }
            if (!this.tagDisable.getWriteValBool()) {
                this.tagDisable.setReadValBool(false);
            }
        }
        if (this.tagTaskInstall.hasWriteValue() && this.isStatus(0)) {
            if (this.tagTaskInstall.getWriteValString().equalsIgnoreCase(TASK_INSTALL_RESET)) {
                this.resetTask();
            } else if (this.tagTaskInstall.getWriteValString().isEmpty()) {
                this.tagTaskInstall.setReadValString("");
            } else if (this.tagTaskInstall.getString().isEmpty()) {
                this.doTaskInstall(this.tagTaskInstall.getWriteValInt());
            } else {
                this.tagTaskInstall.setReadValString(TASK_INSTALL_NOT_EMPTY);
            }
        }
        if (this.tagRun.hasWriteValue() && this.tagRun.getWriteValBool() && this.isStatus(0) && !this.tagDisable.getBool() && this.tagTaskId.getInt() > 0 && (this.tagCycleReq.getInt() == 0 || this.tagCycleCnt.getInt() < this.tagCycleReq.getInt())) {
            this.tagRun.setReadValBool(true);
            this.setStatus(1);
        }
        if (this.isStatus(0)) {
            this.resetCycle();
        }
        if (this.isStatus(1) && this.doTaskPreparing()) {
            this.setStatus(2);
        }
        if (this.isStatus(2) && this.doTaskLoading()) {
            this.setStatus(3);
        }
        if (this.tagCommit.hasWriteValue() && this.isStatus(3) && this.doTaskCommitting()) {
            this.setStatus(4);
        }
        if (this.isStatus(4) && this.doTaskUnloading()) {
            this.setStatus(0);
        }
        this.comps.forEach(Component::execute);
        this.calcSumWeights();
        this.repo.save(this.modname, this.repoTags);
        this.comps.forEach(comp -> this.repo.save(this.modname, comp.repoTags));
    }

    public void setRepo(TagRepository repo) {
        this.repo = repo;
    }

    public Doser getDoser(Tag tagDoserId) {
        if (tagDoserId == null || tagDoserId.getInt() == 0) {
            return null;
        }
        return this.idDosers.get(tagDoserId.getInt());
    }

    private void calcSumWeights() {
        this.tagSumWeightReq.setReadValInt(this.comps.stream().mapToInt(Component::getWeightReq).sum());
        this.tagSumWeightFin.setReadValInt(this.comps.stream().mapToInt(Component::getWeightFin).sum());
    }

    public boolean isStatus(int status) {
        return this.tagStatus.getInt() == status;
    }

    private void setStatus(int status) {
        this.tagStatus.setReadValInt(status);
    }

    private void updateLinkedTags() {
        this.updateControlDoserTags();
        this.comps.forEach(Component::updateDoserTags);
    }

    private boolean readDosers() {
        for (Doser doser : this.dosers) {
            if (!doser.refgr.link()) {
                this.tagTaskInstall.setReadValString(TASK_INSTALL_LINK_ERROR);
                return false;
            }
            doser.refgr.read();
            if (doser.refgr.checkCrc32()) continue;
            EnvironmentInst.get().printError(this.logger, this.lineName, doser.getName(), CRC_ERROR);
            return false;
        }
        return true;
    }

    private void updateControlDoserTags() {
        if (this.tagControlId.getInt() == 0) {
            this.tagControlName.setReadValString("");
            this.tagControlDescr.setReadValString("");
            this.tagControlWeight.setReadValInt(0);
            this.tagControlStable.setReadValBool(false);
        } else {
            Doser doser = this.getDoser(this.tagControlId);
            if (doser == null) {
                this.tagControlName.setReadValString("NOT FOUND");
                this.tagControlDescr.setReadValString("NOT FOUND");
                this.tagControlWeight.setReadValInt(0);
                this.tagControlStable.setReadValBool(false);
            } else {
                this.tagControlName.setReadValString(doser.getName());
                this.tagControlDescr.setReadValString(doser.getDescr());
                this.tagControlWeight.setReadValInt(doser.getWeightTot());
                this.tagControlStable.setReadValBool(doser.getStable());
            }
        }
    }

    private void cancelTask() {
        this.setStatus(0);
        this.tagRun.setReadValBool(false);
        this.tagCancel.setBool(false);
        this.resetCycle();
    }

    private void resetCycle() {
        this.tagUnloadStart.setReadValBool(false);
        this.tagUnloadTimerCnt.setReadValInt(0);
        this.tagSumWeightCtl.setReadValInt(0);
        this.comps.forEach(Component::resetCycle);
    }

    private void resetTask() {
        this.tagTaskId.setReadValInt(0);
        this.tagRecipeId.setReadValInt(0);
        this.tagRecipeName.setReadValString("");
        this.tagControlId.setReadValInt(0);
        this.tagCycleReq.setInt(0);
        this.comps.forEach(Component::resetTask);
        this.tagTaskInstall.setReadValString("");
    }

    private void doTaskInstall(int taskId) throws SQLException {
        Component comp;
        int i;
        Task task = this.service.findTask(taskId);
        if (task == null) {
            this.tagTaskInstall.setReadValString("NOT FOUND");
            return;
        }
        if (task.lineId != this.lineId) {
            this.tagTaskInstall.setReadValString(TASK_INSTALL_WRONG_LINE);
            return;
        }
        if (task.products.size() > this.comps.size()) {
            this.tagTaskInstall.setReadValString(TASK_INSTALL_TOO_MANY_PRODUCTS);
            return;
        }
        this.tagTaskId.setReadValInt(task.taskId);
        this.tagRecipeId.setReadValInt(task.recipeId);
        this.tagRecipeName.setReadValString(task.recipeName);
        this.tagControlId.setReadValInt(task.controlId);
        this.tagCycleReq.setInt(task.cycleReq);
        this.tagCycleCnt.setReadValInt(task.cycleCnt);
        for (i = 0; i < task.products.size(); ++i) {
            comp = this.comps.get(i);
            Task.Product tp = task.products.get(i);
            comp.setProductId(tp.productId);
            comp.setProductName(tp.productName);
            comp.setDoserId(tp.doserId);
            comp.setWeightReq(tp.weightReq);
        }
        for (i = task.products.size(); i < this.comps.size(); ++i) {
            comp = this.comps.get(i);
            comp.setProductId(0);
            comp.setProductName("");
            comp.setDoserId(0);
            comp.setWeightReq(0);
        }
        this.tagTaskInstall.setReadValString(TASK_INSTALL_OK);
        this.updateLinkedTags();
    }

    private boolean doTaskPreparing() {
        this.resetCycle();
        if (this.tagControlId.getInt() == 0) {
            return true;
        }
        Doser doser = this.getDoser(this.tagControlId);
        if (doser == null) {
            return false;
        }
        doser.setEmptyTot(true);
        return doser.getIsEmptyTot();
    }

    private boolean doTaskLoading() {
        return this.comps.stream().filter(Component::isComponentInUse).allMatch(Component::isFinished);
    }

    private boolean doTaskCommitting() throws SQLException {
        if (!this.tagCommit.getWriteValBool()) {
            return false;
        }
        if (this.tagControlId.getInt() > 0 && !this.tagControlStable.getBool()) {
            return false;
        }
        this.tagCycleCnt.setReadValInt(this.tagCycleCnt.getInt() + 1);
        this.tagSumWeightCtl.setReadValInt(this.tagControlWeight.getInt());
        this.tagUnloadTimerCnt.setReadValInt(0);
        Cycle cycle = new Cycle();
        cycle.taskId = this.tagTaskId.getInt();
        cycle.dt = LocalDateTime.now();
        cycle.cycleCnt = this.tagCycleCnt.getInt();
        cycle.weightReq = this.tagSumWeightReq.getInt();
        cycle.weightFin = this.tagSumWeightFin.getInt();
        cycle.weightCtl = this.tagSumWeightCtl.getInt();
        cycle.products = new ArrayList<Cycle.Product>();
        this.comps.stream().filter(comp -> comp.getWeightReq() > 0 && comp.getWeightFin() > 0 && comp.isFinished()).forEach(comp -> {
            Cycle.Product cp = new Cycle.Product();
            cp.productId = comp.getProductId();
            cp.weightReq = comp.getWeightReq();
            cp.weightFin = comp.getWeightFin();
            cycle.products.add(cp);
        });
        this.service.saveCycle(cycle);
        return true;
    }

    private boolean doTaskUnloading() {
        this.tagUnloadStart.setReadValBool(true);
        if (this.tagUnloadTimerCnt.getInt() < this.tagUnloadTimerSet.getInt()) {
            this.tagUnloadTimerCnt.setReadValInt(this.tagUnloadTimerCnt.getInt() + 1);
            return false;
        }
        if (!this.tagUnloadFinished.getBool()) {
            return false;
        }
        this.tagRun.setReadValBool(false);
        this.tagUnloadFinished.setBool(false);
        this.resetCycle();
        return true;
    }

    public String getInfoLine() {
        return String.format("%s (%d), comp=%d", this.lineName, this.lineId, this.comps.size());
    }

    public String getInfoDosers() {
        return String.format("dosers:\r\n%s", this.dosers.stream().map(Doser::getInfo).collect(Collectors.joining("\r\n")));
    }

    public String check() {
        return this.dosers.stream().map(Doser::check).collect(Collectors.joining("\r\n"));
    }
}

