/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolAA55;
import promauto.utils.Numbers;

public class AkkontPassModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(AkkontPassModule.class);
    protected ProtocolAA55 protocol = new ProtocolAA55(this);
    protected Tag tagCrc;
    protected Tag tagSumWesHigh;
    protected Tag tagSumWesLow;
    protected Tag tagWNum;
    protected Tag tagLastWes;
    protected Tag tagCurWes;
    protected Tag tagStageNum;
    protected Tag tagErrCode;
    protected Tag tagWCycle;
    protected Tag tagReqOutput;
    protected Tag tagReqDose;
    protected Tag tagRun;
    protected Tag tagCmdStop;
    protected Tag tagCmdStart;
    protected TagRW tagCmdSetOutput;
    protected TagRW tagCmdSetDose;
    protected Tag tagOutput;
    protected Tag tagOutputKg;
    protected TagRW tagWesSvrState;
    protected Tag[] crcTags;
    private int[] buffin = new int[64];
    private int[] buffout = new int[16];
    private long wesSvrStateTimer;
    private long outWeight;
    private long outTime;
    private boolean outFirstPass;

    public AkkontPassModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.tagCrc = this.tagtable.createInt("Crc", 0);
        this.tagSumWesHigh = this.tagtable.createInt("SumWesHigh", 0, 8);
        this.tagSumWesLow = this.tagtable.createInt("SumWesLow", 0, 8);
        this.tagWNum = this.tagtable.createInt("WNum", 0, 8);
        this.tagLastWes = this.tagtable.createInt("LastWes", 0, 8);
        this.tagCurWes = this.tagtable.createInt("CurWes", 0, 8);
        this.tagStageNum = this.tagtable.createInt("StageNum", 0, 8);
        this.tagErrCode = this.tagtable.createInt("ErrCode", 0, 8);
        this.tagWCycle = this.tagtable.createInt("WCycle", 0, 8);
        this.tagReqOutput = this.tagtable.createInt("ReqOutput", 0, 8);
        this.tagReqDose = this.tagtable.createInt("ReqDose", 0, 8);
        this.tagRun = this.tagtable.createInt("Run", 0, 8);
        this.tagCmdStop = this.tagtable.createInt("CmdStop", 0, 8);
        this.tagCmdStart = this.tagtable.createInt("CmdStart", 0, 8);
        this.tagCmdSetOutput = this.tagtable.createRWInt("CmdSetOutput", 0, 8);
        this.tagCmdSetDose = this.tagtable.createRWInt("CmdSetDose", 0, 8);
        this.crcTags = new Tag[]{this.tagSumWesHigh, this.tagSumWesLow, this.tagWNum, this.tagLastWes};
        this.initCrc16Tags();
        this.tagOutput = this.tagtable.createInt("Output", 0, 8);
        this.tagOutputKg = this.tagtable.createInt("OutputKg", 0, 8);
        this.tagWesSvrState = this.tagtable.createRWInt("WesSvrState", 0);
        return true;
    }

    @Override
    protected void initCrc16Tags() {
        super.initCrc16Tags();
        for (Tag tag : this.crcTags) {
            this.crc16Tags.add(tag);
        }
        this.crc16Tags.add(this.tagError);
    }

    @Override
    public boolean preparePeripherialModule() {
        this.outWeight = 0L;
        this.outTime = 0L;
        this.outFirstPass = true;
        return true;
    }

    public void processWrite(int cmd, TagRW tag) throws Exception {
        if (tag.hasWriteValue()) {
            int value = tag.getWriteValInt();
            this.writeValue(cmd, value);
            tag.setReadValInt(value);
        }
    }

    public void writeValue(int cmd, int value) throws Exception {
        System.out.println(String.format("write %d %d", cmd, value));
        this.buffout[0] = 85;
        this.buffout[1] = 112 + this.netaddr;
        this.buffout[2] = cmd;
        this.buffout[3] = value >> 8 & 0xFF;
        this.buffout[4] = value & 0xFF;
        this.buffout[5] = 0;
        this.protocol.setCrcAA55(this.buffout, 7);
        this.protocol.writeBytes(this.buffout, 7);
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        if (this.emulated) {
            this.calcTagCrc8(this.crcTags, this.tagCrc, this.buffin);
        } else {
            try {
                this.buffout[0] = 85;
                if (this.tagCmdStop.getInt() > 0 && this.tagRun.getInt() > 0) {
                    this.writeValue(160, 1);
                }
                if (this.tagCmdStart.getInt() > 0 && this.tagCmdStop.getInt() == 0 && this.tagRun.getInt() == 0) {
                    this.writeValue(161, 1);
                }
                this.processWrite(162, this.tagCmdSetOutput);
                this.processWrite(163, this.tagCmdSetDose);
                if (result) {
                    this.buffout[1] = 16 + this.netaddr;
                    result = this.protocol.request(this.buffout, 2, this.buffin, 10, 3);
                }
                if (result) {
                    this.tagSumWesHigh.setInt(Numbers.bytesToWord(this.buffin, 0));
                    this.tagSumWesLow.setInt(Numbers.bytesToWord(this.buffin, 2));
                    this.tagWNum.setInt(Numbers.bytesToWord(this.buffin, 4));
                    this.tagLastWes.setInt(Numbers.bytesToWord(this.buffin, 6));
                    this.calcTagCrc8(this.crcTags, this.tagCrc, this.buffin);
                }
                if (result) {
                    this.buffout[1] = 48 + this.netaddr;
                    result = this.protocol.request(this.buffout, 2, this.buffin, 6, 3);
                }
                if (result) {
                    this.tagCurWes.setInt(Numbers.bytesToWord(this.buffin, 0));
                    this.tagStageNum.setInt(this.buffin[3]);
                    this.tagErrCode.setInt(this.buffin[2]);
                    this.tagRun.setBool((this.buffin[2] & 0x80) > 0);
                }
                if (result) {
                    this.buffout[1] = 80 + this.netaddr;
                    result = this.protocol.request(this.buffout, 2, this.buffin, 8, 3);
                }
                if (result) {
                    this.tagWCycle.setInt(Numbers.bytesToWord(this.buffin, 0));
                    this.tagReqOutput.setInt(Numbers.bytesToWord(this.buffin, 2));
                    this.tagReqDose.setInt(Numbers.bytesToWord(this.buffin, 4));
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
            }
        }
        this.calcWeightOutput();
        this.wesSvrStateTimer = AkkontPassModule.updateWesSvrState(this.tagWesSvrState, this.wesSvrStateTimer);
        return result;
    }

    private void calcWeightOutput() {
        int result = 0;
        long W = Numbers.wordsToLong(this.tagSumWesHigh.getInt(), this.tagSumWesLow.getInt());
        long L = this.tagLastWes.getLong();
        long T = this.tagWCycle.getLong() * 100L;
        long ms = System.currentTimeMillis();
        if (this.outFirstPass) {
            this.outFirstPass = false;
            this.outWeight = W;
            this.outTime = ms - T * 3L;
            result = 0;
        } else if (T == 0L || L == 0L) {
            this.outWeight = W;
            this.outTime = ms;
            result = 0;
        } else {
            long tm = ms - this.outTime;
            if (this.outWeight != W || tm < T * 3L) {
                double d = (double)L / (double)T * 3600.0 * 1000.0;
                result = (int)Math.round(d);
                if (this.outWeight != W) {
                    this.outWeight = W;
                    this.outTime = ms;
                }
            } else {
                if (tm > T * 3L) {
                    this.outTime = ms - T * 3L;
                }
                result = 0;
            }
        }
        this.tagOutput.setInt(result);
        this.tagOutputKg.setInt(result / 1000);
    }
}

