/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRWInt;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Output;
import promauto.jroboplc.plugin.roboplant.RoboplantModule;

public class ChannelManager {
    private List<Channel> channels = new LinkedList<Channel>();
    private List<ChannelProvider> providers = new LinkedList<ChannelProvider>();
    private Map<Integer, ChannelProvider> cacheIn = new HashMap<Integer, ChannelProvider>();
    private Map<Integer, ChannelProvider> cacheOut = new HashMap<Integer, ChannelProvider>();
    private RoboplantModule roboplantModule;
    private Tag tagEmpty = new TagRWInt("", 0, 0);

    public ChannelManager(RoboplantModule roboplantModule) {
        this.roboplantModule = roboplantModule;
    }

    public void registerChannelProvider(Device device, Tag tagAddr, Channel.Type type) {
        ChannelProvider provider = new ChannelProvider();
        provider.device = device;
        provider.tagDipNetAddress = tagAddr;
        provider.type = type;
        this.providers.add(provider);
    }

    public Channel createChannel(Tag tagAddrNum, Channel.Type type) {
        if (tagAddrNum == null) {
            return null;
        }
        Channel ch = new Channel();
        ch.tagAddrNum = tagAddrNum;
        ch.classic = tagAddrNum.getType() == Tag.Type.INT;
        ch.type = type;
        this.channels.add(ch);
        return ch;
    }

    public void prepare() {
        this.channels.clear();
        this.providers.clear();
        this.cacheIn.clear();
        this.cacheOut.clear();
    }

    private int extractAddr(int addrnum) {
        return addrnum >> 8 & 0xFF;
    }

    private int extractNum(int addrnum) {
        return addrnum & 0xFF;
    }

    private void cache(ChannelProvider provider) {
        provider.dipNetAddress = provider.tagDipNetAddress.getInt();
        if (provider.type == Channel.Type.In || provider.type == Channel.Type.InOut) {
            this.cacheIn.put(provider.dipNetAddress & 0xFF, provider);
        }
        if (provider.type == Channel.Type.Out || provider.type == Channel.Type.InOut) {
            this.cacheOut.put(provider.dipNetAddress & 0xFF, provider);
        }
    }

    private void uncache(ChannelProvider provider) {
        if (provider.type == Channel.Type.In || provider.type == Channel.Type.InOut) {
            this.cacheIn.remove(provider.dipNetAddress & 0xFF);
        }
        if (provider.type == Channel.Type.Out || provider.type == Channel.Type.InOut) {
            this.cacheOut.remove(provider.dipNetAddress & 0xFF);
        }
    }

    public void execute() {
        for (ChannelProvider provider : this.providers) {
            if (provider.dipNetAddress == null) {
                this.cache(provider);
                continue;
            }
            if (provider.dipNetAddress.intValue() == provider.tagDipNetAddress.getInt()) continue;
            this.uncache(provider);
            int oldProviderNetAddress = provider.dipNetAddress & 0xFF;
            int newProviderNetAddress = provider.tagDipNetAddress.getInt() & 0xFF;
            for (Channel ch : this.channels) {
                int chaddr = this.extractAddr(ch.addrnum);
                if (chaddr != oldProviderNetAddress && chaddr != newProviderNetAddress) continue;
                ch.state = Channel.State.NeedBinding;
            }
            this.cache(provider);
            for (ChannelProvider p : this.providers) {
                if (p == provider || (p.dipNetAddress & 0xFF) != oldProviderNetAddress) continue;
                this.cache(p);
            }
        }
        for (Channel ch : this.channels) {
            if (ch.classic) {
                ChannelProvider provider;
                if (ch.addrnum != ch.tagAddrNum.getInt()) {
                    ch.addrnum = ch.tagAddrNum.getInt();
                    ch.state = Channel.State.NeedBinding;
                    ch.tagValue = null;
                }
                if (ch.state != Channel.State.NeedBinding) continue;
                ChannelProvider channelProvider = provider = ch.type == Channel.Type.In ? this.cacheIn.get(this.extractAddr(ch.addrnum)) : this.cacheOut.get(this.extractAddr(ch.addrnum));
                if (provider == null) {
                    ch.state = Channel.State.Error;
                    continue;
                }
                Output output = provider.device.getOutput(this.extractNum(ch.addrnum));
                if (output == null) {
                    ch.state = Channel.State.Error;
                    continue;
                }
                ch.tagValue = output.tag;
                ch.state = Channel.State.Ok;
                continue;
            }
            if (ch.foreignModuleTagnameText == null || !ch.foreignModuleTagnameText.equals(ch.tagAddrNum.getString())) {
                ch.foreignModuleTagnameText = ch.tagAddrNum.getString();
                if (ch.foreignModuleTagnameText.isEmpty()) {
                    ch.state = Channel.State.Ok;
                    ch.tagValue = this.tagEmpty;
                } else {
                    int k = ch.foreignModuleTagnameText.indexOf(46);
                    if (k < 0) {
                        ch.state = Channel.State.Error;
                        ch.foreignModule = null;
                    } else {
                        ch.state = Channel.State.NeedBinding;
                        String modname = ch.foreignModuleTagnameText.substring(0, k);
                        ch.foreignModule = EnvironmentInst.get().getModuleManager().getModule(modname);
                        ch.foreignTagname = ch.foreignModule == null ? ch.foreignModuleTagnameText : ch.foreignModuleTagnameText.substring(k + 1);
                    }
                    ch.tagValue = null;
                }
            }
            if (ch.state == Channel.State.Ok && ch.tagValue != null && ch.tagValue.getStatus() == Tag.Status.Deleted) {
                ch.state = Channel.State.NeedBinding;
                ch.tagValue = null;
            }
            if (ch.state != Channel.State.NeedBinding) continue;
            ch.tagValue = ch.foreignModule == null ? EnvironmentInst.get().getModuleManager().searchExternalTag(ch.foreignTagname) : ch.foreignModule.getTagTable().get(ch.foreignTagname);
            if (ch.tagValue != null && ch.tagValue.getStatus() == Tag.Status.Deleted) {
                ch.tagValue = null;
            }
            if (ch.tagValue == null) {
                ch.state = Channel.State.Error;
                continue;
            }
            ch.state = Channel.State.Ok;
        }
    }

    public void refreshErrorForeignChannels() {
        this.channels.stream().filter(ch -> !ch.classic && ch.state == Channel.State.Error).forEach(ch -> {
            ch.state = Channel.State.NeedBinding;
        });
    }

    private static class ChannelProvider {
        Device device;
        Tag tagDipNetAddress;
        Integer dipNetAddress = null;
        Channel.Type type;

        private ChannelProvider() {
        }
    }
}

