/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.ArrayList;
import java.util.List;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;
import promauto.jroboplc.plugin.roboplant.Output;

public class DeviceLOADA
extends Device {
    Input inpEnable;
    List<Input> inpInput = new ArrayList<Input>();
    List<Tag> tagOutput = new ArrayList<Tag>();
    List<Tag> tagOrder = new ArrayList<Tag>();
    Tag tagCurrent;
    Tag tagNoOutput;
    Tag tagChanging;
    Tag tagDlyChange;
    int cnt;
    int set_current;
    int loadANum;
    int[] order;
    int[] fl;
    int[] idx;
    private int current;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpEnable = this.getInput("Enable", res);
        this.tagCurrent = this.getOutputTag("Current", res);
        this.tagNoOutput = this.getOutputTag("NoOutput", res);
        this.tagChanging = this.getOutputTag("Changing", res);
        this.tagDlyChange = this.getOutputTag("DlyChange", res);
        int i = 0;
        while (true) {
            Input inp = this.getInput("Input" + i);
            Output out = this.getOutput("Output" + i);
            Output ord = this.getOutput("Order" + i);
            if (inp == null || ord == null || out == null) break;
            this.inpInput.add(inp);
            this.tagOutput.add(out.tag);
            this.tagOrder.add(ord.tag);
            ++i;
        }
        this.loadANum = this.inpInput.size();
        this.order = new int[this.loadANum];
        this.fl = new int[this.loadANum];
        this.idx = new int[this.loadANum];
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        for (int i = 0; i < this.tagOrder.size(); ++i) {
            this.order[i] = this.tagOrder.get(i).getInt();
        }
        this.cnt = 0;
        this.current = 0;
        this.set_current = -1;
    }

    @Override
    public boolean execute() {
        this.rebuildOrder();
        boolean flag = false;
        int tmp_changing = 0;
        if (this.current != this.tagCurrent.getInt() && this.tagCurrent.getInt() >= 0 && this.tagCurrent.getInt() < 16) {
            this.set_current = this.tagCurrent.getInt();
        }
        int dlyChange = this.tagDlyChange.getInt();
        int noOutput = this.tagNoOutput.getInt();
        if (this.set_current != -1) {
            if (this.cnt >= dlyChange) {
                this.current = this.set_current;
                this.set_current = -1;
            } else {
                ++this.cnt;
                tmp_changing = 1;
            }
        }
        int new_current = this.current;
        if (this.inpEnable.getInt() > 0 && !this.isAllOrdersZero()) {
            int i;
            for (i = 0; i < this.loadANum; ++i) {
                this.fl[i] = 0;
                this.idx[i] = 0;
            }
            for (i = 0; i < this.loadANum; ++i) {
                if (this.order[i] <= 0 || this.inpInput.get(i).getInt() != 0 || this.order[i] > this.loadANum) continue;
                this.fl[this.order[i] - 1] = 1;
                this.idx[this.order[i] - 1] = i;
            }
            if (new_current < 0 || new_current >= this.loadANum) {
                new_current = 0;
            }
            for (i = this.order[new_current] - 1; i < this.loadANum; ++i) {
                if (i < 0 || i >= this.loadANum || this.fl[i] <= 0) continue;
                new_current = this.idx[i];
                flag = true;
                break;
            }
            if (!flag) {
                for (i = 0; i < this.order[new_current] - 1; ++i) {
                    if (i < 0 || i >= this.loadANum || this.fl[i] <= 0) continue;
                    new_current = this.idx[i];
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                if (this.cnt >= dlyChange) {
                    noOutput = 1;
                } else {
                    ++this.cnt;
                    tmp_changing = 1;
                }
            } else if (new_current != this.current) {
                if (this.cnt >= dlyChange) {
                    this.current = new_current;
                    for (i = 0; i < 16; ++i) {
                        this.tagOutput.get(i).setBool(i == this.current);
                    }
                    noOutput = 0;
                } else {
                    ++this.cnt;
                    tmp_changing = 1;
                }
            } else {
                if (this.set_current == -1) {
                    this.cnt = 0;
                }
                for (i = 0; i < 16; ++i) {
                    this.tagOutput.get(i).setBool(i == this.current);
                }
                noOutput = 0;
            }
        } else {
            noOutput = this.inpEnable.getInt() > 0 ? 1 : 0;
            this.current = 0;
            for (int i = 0; i < 16; ++i) {
                this.tagOutput.get(i).setInt(0);
                if (this.order[i] != 1) continue;
                this.current = i;
            }
        }
        this.tagChanging.setInt(tmp_changing);
        this.tagDlyChange.setInt(dlyChange);
        this.tagCurrent.setInt(this.current);
        this.tagNoOutput.setInt(noOutput);
        return true;
    }

    private boolean isAllOrdersZero() {
        for (int i = 0; i < 16; ++i) {
            if (this.tagOrder.get(i).getInt() <= 0) continue;
            return false;
        }
        return true;
    }

    protected void rebuildOrder() {
        int idx;
        for (idx = 0; idx < this.loadANum && this.order[idx] == this.tagOrder.get(idx).getInt(); ++idx) {
        }
        if (idx == this.loadANum) {
            return;
        }
        int ord1 = this.order[idx];
        int ord2 = this.tagOrder.get(idx).getInt();
        for (int i = 0; i < this.loadANum; ++i) {
            if (this.order[i] <= 0) continue;
            if (ord1 > 0 && ord2 > 0) {
                if (ord1 < ord2 && this.order[i] >= ord1 && this.order[i] <= ord2) {
                    int n = i;
                    this.order[n] = this.order[n] - 1;
                }
                if (ord1 > ord2 && this.order[i] >= ord2 && this.order[i] <= ord1) {
                    int n = i;
                    this.order[n] = this.order[n] + 1;
                }
            }
            if (ord1 > 0 && ord2 == 0 && this.order[i] > ord1) {
                int n = i;
                this.order[n] = this.order[n] - 1;
            }
            if (ord1 != 0 || ord2 <= 0 || this.order[i] < ord2) continue;
            int n = i;
            this.order[n] = this.order[n] + 1;
        }
        this.order[idx] = this.tagOrder.get(idx).getInt();
        int k = 0;
        for (int j = 1; j <= this.loadANum; ++j) {
            int i;
            for (i = 0; i < this.loadANum; ++i) {
                if (this.order[i] != j) continue;
                this.order[i] = this.order[i] - k;
                break;
            }
            if (i <= this.loadANum) continue;
            ++k;
        }
        for (idx = 0; idx < this.loadANum; ++idx) {
            this.tagOrder.get(idx).setInt(this.order[idx]);
        }
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("cnt", this.cnt);
        state.saveVar("set_current", this.set_current);
        state.saveVar("current", this.current);
        for (int i = 0; i < this.loadANum; ++i) {
            state.saveVar("order_" + i, this.order[i]);
        }
    }

    @Override
    public void loadStateExtra(State state) {
        this.cnt = state.loadVar("cnt", this.cnt);
        this.set_current = state.loadVar("set_current", this.set_current);
        this.current = state.loadVar("current", this.current);
        for (int i = 0; i < this.loadANum; ++i) {
            this.order[i] = state.loadVar("order_" + i, this.order[i]);
        }
    }
}

