/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.Numbers;

public class HygrostekDA301Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(HygrostekDA301Module.class);
    private static final char cmdAdjust = '\u0001';
    private static final char cmdRead = '\u0002';
    private static final char cmdZero = '\u0003';
    private static final char cmdStart = '\u0004';
    private static final char cmdStop = '\u0005';
    private int[] buffout = new int[14];
    private int[] buffin = new int[44];
    protected Tag tagStatus1;
    protected Tag tagInputDampness;
    protected Tag tagTemperature;
    protected Tag tagProductFlow;
    protected Tag tagWaterFlow;
    protected Tag tagProductAmount;
    protected Tag tagWaterAmount;
    protected Tag tagStatus2;
    protected Tag tagAbsoluteWeight;
    protected Tag tagAlarm;
    protected TagRW tagProgramme;
    protected TagRW tagRequiredDampness;
    protected TagRW tagCalibration;
    protected TagRW tagCmdStop;
    protected TagRW tagCmdStart;
    protected TagRW tagCmdZero;
    private int senddelay_ms;

    public HygrostekDA301Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.senddelay_ms = cm.get(conf, "send_delay_ms", 0);
        this.tagStatus1 = this.tagtable.createInt("Status1", 0, 8);
        this.tagInputDampness = this.tagtable.createInt("InputDampness", 0, 8);
        this.tagTemperature = this.tagtable.createInt("Temperature", 0, 8);
        this.tagProductFlow = this.tagtable.createInt("ProductFlow", 0, 8);
        this.tagWaterFlow = this.tagtable.createInt("WaterFlow", 0, 8);
        this.tagProductAmount = this.tagtable.createInt("ProductAmount", 0, 8);
        this.tagWaterAmount = this.tagtable.createInt("WaterAmount", 0, 8);
        this.tagStatus2 = this.tagtable.createInt("Status2", 0, 8);
        this.tagAbsoluteWeight = this.tagtable.createInt("AbsoluteWeight", 0, 8);
        this.tagAlarm = this.tagtable.createInt("Alarm", 0, 8);
        this.tagProgramme = this.tagtable.createRWInt("Programme", 0, 8);
        this.tagRequiredDampness = this.tagtable.createRWInt("RequiredDampness", 0, 8);
        this.tagCalibration = this.tagtable.createRWInt("Calibration", 0, 8);
        this.tagCmdStop = this.tagtable.createRWInt("CmdStop", 0);
        this.tagCmdStart = this.tagtable.createRWInt("CmdStart", 0);
        this.tagCmdZero = this.tagtable.createRWInt("CmdZero", 0);
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagProgramme.acceptWriteValue();
            this.tagRequiredDampness.acceptWriteValue();
            this.tagCalibration.acceptWriteValue();
            this.tagCmdStop.acceptWriteValue();
            this.tagCmdStart.acceptWriteValue();
            this.tagCmdZero.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            result &= this.command(this.tagCmdStop, 5);
            result &= this.command(this.tagCmdStart, 4);
            if ((result &= this.command(this.tagCmdZero, 3)) && (this.tagProgramme.hasWriteValue() || this.tagRequiredDampness.hasWriteValue() || this.tagCalibration.hasWriteValue())) {
                Numbers.intToHexByte(this.tagProgramme.getWriteValInt(), this.buffout, 5);
                Numbers.intToHexByte(this.tagRequiredDampness.getWriteValInt(), this.buffout, 7);
                Numbers.intToHexByte(this.tagCalibration.getWriteValInt(), this.buffout, 9);
                result &= this.request(1, 6);
            }
            if (result && (result &= this.request(2, 0))) {
                this.tagStatus1.setInt(Numbers.asciiByteToInt(this.buffin, 1));
                this.tagInputDampness.setInt(Numbers.asciiByteToInt(this.buffin, 3));
                this.tagTemperature.setInt(Numbers.asciiWordToInt(this.buffin, 5));
                this.tagProductFlow.setInt(Numbers.asciiWordToInt(this.buffin, 9));
                this.tagWaterFlow.setInt(Numbers.asciiWordToInt(this.buffin, 13));
                this.tagProductAmount.setInt((Numbers.asciiWordToInt(this.buffin, 17) << 8) + Numbers.asciiByteToInt(this.buffin, 21));
                this.tagWaterAmount.setInt((Numbers.asciiWordToInt(this.buffin, 23) << 8) + Numbers.asciiByteToInt(this.buffin, 27));
                this.tagRequiredDampness.setReadValInt(Numbers.asciiByteToInt(this.buffin, 29));
                this.tagProgramme.setReadValInt(Numbers.asciiByteToInt(this.buffin, 31));
                this.tagStatus2.setInt(Numbers.asciiByteToInt(this.buffin, 33));
                this.tagAbsoluteWeight.setInt(Numbers.asciiByteToInt(this.buffin, 35));
                this.tagCalibration.setReadValInt(Numbers.asciiByteToInt(this.buffin, 37));
                this.tagAlarm.setInt(Numbers.asciiByteToInt(this.buffin, 39));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return result;
    }

    private boolean command(TagRW tag, int cmd) throws Exception {
        if (tag.hasWriteValue()) {
            return this.request(cmd, 0);
        }
        return true;
    }

    public int calcCrc(int[] data, int size) {
        int crc = 0;
        for (int i = 1; i < size; ++i) {
            crc += data[i];
        }
        return crc & 0xFF;
    }

    public boolean request(int cmd, int sizedata) throws Exception {
        int sizeout = sizedata + 8;
        this.buffout[0] = 36;
        Numbers.intToHexByte(this.netaddr, this.buffout, 1);
        Numbers.intToHexByte(cmd, this.buffout, 3);
        Numbers.intToHexByte(this.calcCrc(this.buffout, sizeout - 3), this.buffout, sizeout - 3);
        this.buffout[sizeout - 1] = 13;
        for (int trynum = 0; trynum < this.retrial; ++trynum) {
            int crc2;
            int crc1;
            this.port.discard();
            if (this.senddelay_ms > 0) {
                for (int j = 0; j < sizeout; ++j) {
                    this.port.writeByte(this.buffout[j]);
                    Thread.sleep(this.senddelay_ms);
                }
            } else {
                this.port.writeBytes(this.buffout, sizeout);
            }
            int sizein = this.port.readBytesDelim(this.buffin, 13);
            boolean goodcrc = true;
            if (sizein >= 3 && this.buffin[0] == 42 && (goodcrc = (crc1 = Numbers.asciiByteToInt(this.buffin, sizein - 3)) == (crc2 = this.calcCrc(this.buffin, sizein - 3)))) {
                return true;
            }
            if (this.canLogError()) {
                this.logError(trynum, !goodcrc, this.buffout, sizeout, this.buffin, Math.abs(sizein), "");
            }
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
        return false;
    }

    @Override
    protected boolean reload() {
        HygrostekDA301Module tmp = new HygrostekDA301Module(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.senddelay_ms = tmp.senddelay_ms;
        return true;
    }
}

