/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OwenMv110_16dModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OwenMv110_16dModule.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected TagRW tagTOut;
    protected TagRW[] tagInp = null;
    protected TagRW[] tagCnt = null;
    private boolean usecnt;
    protected final int size;
    protected final int regInp;
    protected final int regCnt;
    protected final int regTOut;

    public OwenMv110_16dModule(Plugin plugin, String name) {
        super(plugin, name);
        this.size = 16;
        this.regInp = 51;
        this.regCnt = 64;
        this.regTOut = 48;
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.usecnt = !cm.get(conf, "nocnt", false);
        this.tagTOut = this.protocol.addWriteTag(48, this.tagtable.createRWInt("TOut", 0, 8));
        if (this.tagInp == null) {
            this.tagInp = new TagRW[this.size];
        }
        if (this.tagCnt == null && this.usecnt) {
            this.tagCnt = new TagRW[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            this.tagInp[i] = this.tagtable.createRWInt(String.format("inp%02d", i), 0, 8);
            if (!this.usecnt) continue;
            this.tagCnt[i] = this.protocol.addWriteTag(64 + i, this.tagtable.createRWInt(String.format("cnt%02d", i), 0, 8));
        }
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < this.size; ++i) {
            this.addChannelMapTag(chtags, this.tagInp[i], "" + i);
            this.addChannelMapTag(chtags, this.tagCnt[i], "cnt" + i);
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagTOut.acceptWriteValue();
            for (int i = 0; i < this.size; ++i) {
                this.tagInp[i].acceptWriteValue();
                if (!this.usecnt) continue;
                this.tagCnt[i].acceptWriteValue();
            }
            return true;
        }
        boolean result = true;
        try {
            if (result) {
                result = this.protocol.sendWriteTags(16);
            }
            result &= this.readInputs();
            if (this.usecnt && result && (result = this.protocol.requestCmd3(this.regCnt, this.size))) {
                for (int i = 0; i < this.size; ++i) {
                    this.tagCnt[i].setReadValInt(this.protocol.getAnswerWord(i));
                }
            }
            if (result && (this.firstPass || this.tagError.getBool()) && (result = this.protocol.requestCmd3(this.regTOut, 1))) {
                this.tagTOut.setReadValInt(this.protocol.getAnswerWord(0));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    protected boolean readInputs() throws Exception {
        if (!this.protocol.requestCmd3(this.regInp, 1)) {
            return false;
        }
        int inps = this.protocol.getAnswerWord(0);
        for (int i = 0; i < this.size; ++i) {
            this.tagInp[i].setReadValInt(inps >> i & 1);
        }
        return true;
    }

    @Override
    protected boolean reload() {
        OwenMv110_16dModule tmp = new OwenMv110_16dModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        if (this.usecnt && !tmp.usecnt) {
            for (TagRW tag : this.tagCnt) {
                this.tagtable.remove(tag);
            }
            this.tagCnt = null;
        }
        if (!this.usecnt && tmp.usecnt) {
            this.tagCnt = tmp.tagCnt;
            for (TagRW tag : tmp.tagCnt) {
                this.tagtable.add(tag);
            }
        }
        this.usecnt = tmp.usecnt;
        return true;
    }
}

