/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.PostedCommands;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Command;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Flags;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.api.Task;
import promauto.jroboplc.core.func.FuncTag;

public abstract class AbstractModule
implements Module {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Environment env = EnvironmentInst.get();
    protected final Plugin plugin;
    protected final String name;
    protected TagTable tagtable;
    protected boolean enable;
    protected boolean debuglogging;
    protected volatile boolean hasReloadRequest = false;
    protected Consumer<Boolean> reloader = null;
    protected boolean taskable = true;
    protected Map<String, String> flags = null;
    private boolean suspended;
    protected PostedCommands postedCommands = null;
    protected Queue<Signal> signals = null;
    protected Set<Signal.Listener> signalListeners = null;
    private List<FuncTag> functags;
    private int indexFuncTag;

    protected AbstractModule(Plugin plugin, String name) {
        this.plugin = plugin;
        this.name = name;
        this.tagtable = new TagTable();
    }

    @Override
    public boolean isEnabled() {
        return this.enable;
    }

    public boolean isDebugLogging() {
        return this.debuglogging;
    }

    @Override
    public boolean isTaskable() {
        return this.taskable;
    }

    @Override
    public boolean canHaveExternalTags() {
        return false;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public TagTable getTagTable() {
        return this.tagtable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInfo() {
        return "";
    }

    public boolean load() {
        Object conf = this.env.getConfiguration().getModuleConf(this.plugin.getPluginName(), this.name);
        return conf != null && this.load(conf);
    }

    public final boolean load(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.enable = cm.get(conf, "enable", true);
        this.debuglogging = cm.get(conf, "debug.logging", false);
        this.loadModuleFlags(cm.toMap(conf));
        boolean res = this.loadModule(conf);
        this.loadTagValues(cm.toMap(cm.get(conf, "tag.values")));
        this.loadTagFlags(cm.toMap(cm.get(conf, "tag.flags")));
        return res &= this.loadTagFunctions(cm.toMap(cm.get(conf, "func.tags")));
    }

    private void loadModuleFlags(Map<String, Object> initmap) {
        this.clearFlags();
        initmap.entrySet().stream().filter(ent -> ((String)ent.getKey()).startsWith("flag.")).forEach(ent -> {
            if (this.flags == null) {
                this.flags = new HashMap<String, String>();
            }
            this.flags.put(((String)ent.getKey()).substring(5).toUpperCase(), ent.getValue().toString().toUpperCase());
        });
    }

    private void loadTagValues(Map<String, Object> initmap) {
        initmap.entrySet().stream().forEach(ent -> {
            Tag tag = this.tagtable.get((String)ent.getKey());
            if (tag != null) {
                this.initTagValue(tag, ent.getValue());
            } else {
                this.tagtable.getTags((String)ent.getKey(), false).stream().forEach(tag1 -> this.initTagValue((Tag)tag1, ent.getValue()));
            }
        });
    }

    private void initTagValue(Tag tag, Object value) {
        if (value instanceof Boolean) {
            tag.setBool((Boolean)value);
        } else {
            tag.setString(value.toString());
        }
    }

    private void loadTagFlags(Map<String, Object> initmap) {
        initmap.entrySet().stream().forEach(ent -> {
            Tag tag = this.tagtable.get((String)ent.getKey());
            if (tag != null) {
                tag.setFlags(Flags.parseFlags(ent.getValue().toString()));
            } else {
                this.tagtable.getTags((String)ent.getKey(), false).stream().forEach(tag1 -> tag1.setFlags(Flags.parseFlags(ent.getValue().toString())));
            }
        });
    }

    protected abstract boolean loadModule(Object var1);

    public void copySettingsFrom(AbstractModule src) {
        this.enable = src.enable;
        this.debuglogging = src.debuglogging;
        this.clearFlags();
        this.flags = src.flags;
        this.copyFuntagsFrom(src);
    }

    private void clearFlags() {
        if (this.flags != null) {
            this.flags.clear();
            this.flags = null;
        }
    }

    @Override
    public String getFlag(String flag) {
        if (this.flags == null) {
            return "";
        }
        String value = this.flags.get(flag.toUpperCase());
        return value == null ? "" : value;
    }

    @Override
    public boolean isFlagCompatibleWith(String flag, Module module) {
        return this.getFlag(flag.toUpperCase()).equals(module.getFlag(flag.toUpperCase()));
    }

    @Override
    public final boolean prepare() {
        if (!this.enable) {
            return true;
        }
        this.hasReloadRequest = false;
        this.clearSignals();
        return this.prepareModule() && this.prepareTagFunctions();
    }

    protected abstract boolean prepareModule();

    @Override
    public final boolean execute() {
        if (!this.enable) {
            return true;
        }
        if (this.hasReloadRequest) {
            this.executeReload();
        }
        if (this.suspended) {
            return true;
        }
        if (this.postedCommands != null) {
            this.postedCommands.execute();
        }
        boolean res = this.executeModule();
        this.executeFunctagsBefore();
        this.processSignals();
        this.executeFunctagsAfter();
        return res;
    }

    protected boolean executeModule() {
        return true;
    }

    @Override
    public final boolean closedown() {
        if (!this.enable) {
            return true;
        }
        boolean res = this.closedownModule();
        this.processSignals();
        return res;
    }

    protected boolean closedownModule() {
        return true;
    }

    @Override
    public final void requestReload(Consumer<Boolean> reloader) {
        this.reloader = reloader;
        if (this.taskable || this instanceof Task) {
            boolean running;
            boolean bl = running = this.enable && EnvironmentInst.get().isRunning();
            if (running && this.taskable) {
                Task task = EnvironmentInst.get().getTaskManager().getTask(this);
                boolean bl2 = running = task != null && task.isRunning();
            }
            if (running) {
                this.hasReloadRequest = true;
                return;
            }
        }
        this.executeReload();
    }

    private void executeReload() {
        this.hasReloadRequest = false;
        boolean res = this.reload();
        if (res) {
            this.env.printInfo(this.logger, this.name, "Successfully reloaded");
            this.postSignal(Signal.SignalType.RELOADED);
        } else {
            this.env.printError(this.logger, this.name, "Failed to reload");
        }
        if (this.reloader != null) {
            this.reloader.accept(res);
            this.reloader = null;
        }
    }

    protected boolean reload() {
        EnvironmentInst.get().printError(this.logger, this.name, "Reloading is not supported");
        return false;
    }

    @Override
    public void loadState(State state) {
    }

    @Override
    public void saveState(State state) {
    }

    @Override
    public String check() {
        return "";
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public void setSuspended(boolean value) {
        this.suspended = value;
    }

    @Override
    public void postCommand(Command cmd, Console console, Module module, String args) {
        if (this.postedCommands == null) {
            this.postedCommands = new PostedCommands();
        }
        this.postedCommands.post(cmd, console, module, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSignalListener(Signal.Listener signalListener) {
        if (this.signalListeners == null) {
            this.signalListeners = new HashSet<Signal.Listener>();
        }
        Set<Signal.Listener> set = this.signalListeners;
        synchronized (set) {
            this.signalListeners.add(signalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSignalListener(Signal.Listener signalListener) {
        if (this.signalListeners != null) {
            Set<Signal.Listener> set = this.signalListeners;
            synchronized (set) {
                this.signalListeners.remove(signalListener);
            }
        }
    }

    @Override
    public void postSignal(Signal.SignalType id) {
        this.postSignal(id, null);
    }

    @Override
    public void postSignal(Signal.SignalType id, Object data) {
        if (this.signalListeners == null) {
            return;
        }
        if (this.signals == null) {
            this.signals = new ConcurrentLinkedQueue<Signal>();
        }
        this.signals.add(new Signal(id, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSignals() {
        if (this.signals != null) {
            while (!this.signals.isEmpty()) {
                Signal signal = this.signals.poll();
                if (this.signalListeners == null) continue;
                Set<Signal.Listener> set = this.signalListeners;
                synchronized (set) {
                    for (Signal.Listener listener : this.signalListeners) {
                        listener.onSignal(this, signal);
                    }
                }
            }
        }
    }

    private void clearSignals() {
        if (this.signals != null) {
            this.signals.clear();
        }
    }

    private boolean loadTagFunctions(Map<String, Object> initmap) {
        try {
            for (String tagname : initmap.keySet()) {
                if (this.functags == null) {
                    this.functags = new LinkedList<FuncTag>();
                }
                this.functags.add(FuncTag.create(this, tagname, initmap.get(tagname)));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name, "Failed to load func tags");
            return false;
        }
        return true;
    }

    private boolean prepareTagFunctions() {
        if (this.functags == null) {
            return true;
        }
        return this.functags.stream().allMatch(FuncTag::prepare);
    }

    private void executeFunctagsBefore() {
        if (this.functags == null) {
            return;
        }
        this.indexFuncTag = 0;
        while (this.indexFuncTag < this.functags.size() && this.functags.get(this.indexFuncTag).isBeforeExecute()) {
            this.functags.get(this.indexFuncTag).execute();
            ++this.indexFuncTag;
        }
    }

    private void executeFunctagsAfter() {
        if (this.functags == null) {
            return;
        }
        while (this.indexFuncTag < this.functags.size()) {
            this.functags.get(this.indexFuncTag).execute();
            ++this.indexFuncTag;
        }
    }

    private void copyFuntagsFrom(AbstractModule src) {
        if (this.functags != null) {
            this.functags.forEach(ft -> this.tagtable.remove(ft.getTag()));
        }
        if (src.functags != null) {
            src.functags.forEach(ft -> this.tagtable.add(ft.getTag()));
        }
        this.functags = src.functags;
    }
}

