/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.text.WordUtils;
import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.api.CmdDispatcher;
import promauto.jroboplc.core.api.Command;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Plugin;

public class CmdHelp
extends AbstractCommand {
    private static final String LINE_SEP = "\r\n";
    private final int WIDTH_DESCR = 180;
    private int cmdWidth;

    @Override
    public String getName() {
        return "h";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "shows this help";
    }

    @Override
    public String execute(Console console, String args) {
        StringBuilder sb = new StringBuilder();
        Map<String, CmdDispatcher.Entry> commands = EnvironmentInst.get().getCmdDispatcher().getCommands();
        TreeMap<String, Command> commons = new TreeMap<String, Command>();
        TreeMap<String, PluginCmdInfo> plugins = new TreeMap<String, PluginCmdInfo>();
        this.cmdWidth = 10;
        for (CmdDispatcher.Entry entry : commands.values()) {
            int w;
            String cmdname = entry.command.getName();
            if (entry.plugin == null) {
                commons.put(cmdname, entry.command);
            } else {
                String plugname = entry.plugin.getPluginName();
                PluginCmdInfo pluginfo = (PluginCmdInfo)plugins.get(plugname);
                if (pluginfo == null) {
                    pluginfo = new PluginCmdInfo();
                    pluginfo.plugin = entry.plugin;
                    plugins.put(plugname, pluginfo);
                }
                pluginfo.commands.put((entry.module == null ? "p:" : "m:") + cmdname, entry.command);
            }
            if ((w = entry.command.getName().length() + entry.command.getUsage().length()) <= this.cmdWidth) continue;
            this.cmdWidth = w;
        }
        this.cmdWidth += 4;
        sb.append("General format:\r\n");
        sb.append("  <comand>     common command\r\n");
        sb.append("  p:<command>  plugin command, where 'p' is a plugin name\r\n");
        sb.append("  m:<command>  module command, where 'm' is a module name\r\n\r\n");
        if (!commons.isEmpty()) {
            sb.append("\u001b[01m");
            sb.append("Common commands:\r\n");
            sb.append("\u001b[0m");
            this.addCmdLines(sb, commons);
        }
        for (PluginCmdInfo pluginfo : plugins.values()) {
            sb.append(LINE_SEP);
            sb.append("\u001b[01m");
            sb.append(pluginfo.plugin.getPluginName());
            sb.append("\u001b[0m");
            sb.append(":");
            sb.append(LINE_SEP);
            this.addCmdLines(sb, pluginfo.commands);
        }
        return sb.toString();
    }

    private void addCmdLines(StringBuilder sb, Map<String, Command> commands) {
        for (Map.Entry<String, Command> cmd : commands.entrySet()) {
            sb.append("  ");
            sb.append("\u001b[01m");
            sb.append("\u001b[32m");
            sb.append(cmd.getKey());
            sb.append("\u001b[0m");
            sb.append("\u001b[32m");
            sb.append(String.format(" %-" + (this.cmdWidth - cmd.getKey().length()) + "s", cmd.getValue().getUsage()));
            sb.append("\u001b[0m");
            String[] s = WordUtils.wrap((String)cmd.getValue().getDescription(), (int)180, (String)LINE_SEP, (boolean)true).split(LINE_SEP);
            sb.append(s[0] + LINE_SEP);
            for (int i = 1; i < s.length; ++i) {
                sb.append(String.format("%" + (this.cmdWidth + 3) + "s%s\r\n", " ", s[i]));
            }
        }
    }

    private static class PluginCmdInfo {
        public Plugin plugin;
        public Map<String, Command> commands = new TreeMap<String, Command>();

        private PluginCmdInfo() {
        }
    }
}

