/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.kkormsvr;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.kkormsvr.KkDoser;
import promauto.jroboplc.plugin.kkormsvr.KkLine;
import promauto.jroboplc.plugin.kkormsvr.KkormsvrModule;

public class KkGroup {
    private static final int STATE_IDLE = 0;
    private static final int STATE_START = 1;
    private static final int STATE_TASK = 2;
    private static final int STATE_DOSING = 3;
    private static final int STATE_ERROR = 4;
    public final KkormsvrModule module;
    public final KkLine line;
    public final int level;
    private int cycleCnt;
    private int state;
    private String prmCycleCnt;
    private String prmState;
    private Tag tagCycleCnt;
    private Tag tagState;
    private List<KkDoser> dosers = new ArrayList<KkDoser>();

    KkGroup(KkLine line, int level) {
        this.line = line;
        this.module = line.module;
        this.level = level;
    }

    void addDoser(KkDoser doser) {
        this.dosers.add(doser);
    }

    void load() {
        TagTable tt = this.module.getTagTable();
        this.tagCycleCnt = tt.createInt(this.prefix() + "CycleCnt", 0);
        this.tagState = tt.createInt(this.prefix() + "State", 0);
    }

    private String prefix() {
        return this.line.prefix() + "Group" + this.level + ".";
    }

    void initLiveData() {
        this.prmCycleCnt = this.prefix() + "CycleCnt";
        this.prmState = this.prefix() + "State";
    }

    void readLiveData() {
        this.cycleCnt = this.module.livedata.getInt(this.prmCycleCnt, this.cycleCnt);
        this.state = this.module.livedata.getInt(this.prmState, this.state);
    }

    void updateLiveData() {
        this.module.livedata.set(this.prmCycleCnt, this.cycleCnt);
        this.module.livedata.set(this.prmState, this.state);
    }

    void execute() {
        if (this.state == 0 && this.line.isRunning() && this.canStartCycle()) {
            this.state = 1;
        }
        if (this.state == 1) {
            this.prepareTaskSend();
            if (this.isTaskSendReady()) {
                this.sendTask();
                this.state = 2;
            }
        }
        if (this.state == 2) {
            if (this.isTaskAccepted()) {
                this.startDosing();
                this.state = 3;
            } else if (this.isTaskRejected()) {
                this.state = 4;
            }
        }
        if (this.state == 3 && this.isDosingFinished()) {
            this.state = 0;
            ++this.cycleCnt;
        }
        this.updateTags();
    }

    private void updateTags() {
        this.tagCycleCnt.setInt(this.cycleCnt);
        this.tagState.setInt(this.state);
    }

    void reset() {
        this.state = 0;
        this.cycleCnt = 0;
    }

    private boolean canStartCycle() {
        return this.cycleCnt < this.line.getCycleReq() && this.cycleCnt <= this.line.getCycleCnt() + this.level;
    }

    private void prepareTaskSend() {
        this.dosers.stream().filter(KkDoser::isHasTask).forEach(KkDoser::prepareTaskSend);
    }

    private boolean isTaskSendReady() {
        return this.dosers.stream().filter(KkDoser::isHasTask).allMatch(KkDoser::isTaskSendReady);
    }

    private void sendTask() {
        this.dosers.stream().filter(KkDoser::isHasTask).forEach(KkDoser::sendTask);
    }

    private boolean isTaskAccepted() {
        return this.dosers.stream().filter(KkDoser::isHasTask).allMatch(KkDoser::isTaskAccepted);
    }

    private boolean isTaskRejected() {
        return this.dosers.stream().filter(KkDoser::isHasTask).allMatch(KkDoser::isTaskRejected);
    }

    private void startDosing() {
        this.dosers.stream().filter(KkDoser::isHasTask).forEach(KkDoser::startDosing);
    }

    private boolean isDosingFinished() {
        return this.dosers.stream().filter(KkDoser::isHasTask).allMatch(KkDoser::isDosingFinished);
    }

    int getCycleCnt() {
        return this.cycleCnt;
    }

    boolean isIdle() {
        return this.state == 0;
    }

    boolean isError() {
        return this.state == 4;
    }

    public String getInfo() {
        return "  group" + this.level + ": " + this.getStateStr() + " cnt=" + this.cycleCnt + "\r\n" + this.dosers.stream().map(KkDoser::getInfo).collect(Collectors.joining("\r\n"));
    }

    private String getStateStr() {
        switch (this.state) {
            case 0: {
                return "IDLE";
            }
            case 1: {
                return "START";
            }
            case 2: {
                return "TASK";
            }
            case 3: {
                return "DOSING";
            }
            case 4: {
                return "ERROR";
            }
        }
        return "";
    }
}

