/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.operhour;

import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.plugin.operhour.Context;
import promauto.jroboplc.plugin.operhour.DataService;
import promauto.jroboplc.plugin.operhour.DataServiceImpl;
import promauto.jroboplc.plugin.operhour.OperhourPlugin;

public class OperhourModule
extends AbstractModule
implements Signal.Listener {
    private final Logger logger = LoggerFactory.getLogger(OperhourModule.class);
    public static final String DBSCR_OPERHOUR = "dbscr/dbscr.operhour.yml";
    public static final String OPERHOUR_INIT_1 = "operhour.init1";
    public static final String TABLE_REPO = "OH_REPO";
    private Database database;
    private boolean needInit;
    private Context ctx = new Context();

    public OperhourModule(Plugin plugin, String name) {
        super(plugin, name);
        this.ctx.setModule(this);
        this.ctx.setDataService(new DataServiceImpl());
        this.ctx.setEnvironment(EnvironmentInst.get());
    }

    @Override
    public final boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.ctx.emulated = cm.get(conf, "emulate", false);
        this.ctx.databaseModuleName = cm.get(conf, "database", "db");
        this.ctx.tagConnected = this.tagtable.createBool("connected", false);
        return true;
    }

    @Override
    public final boolean prepareModule() {
        if (this.ctx.emulated) {
            return true;
        }
        this.database = this.env.getModuleManager().getModule(this.ctx.databaseModuleName, Database.class);
        if (this.database == null) {
            this.env.printError(this.logger, this.name, "Database not found:", this.ctx.databaseModuleName);
            return false;
        }
        this.ctx.service.setDb(this.database);
        this.addAsSignalListerToAllOthers();
        boolean res = true;
        this.needInit = res &= this.database.loadScriptFromResource(OperhourPlugin.class, DBSCR_OPERHOUR) != null;
        return res;
    }

    @Override
    public void onSignal(Module sender, Signal signal) {
        if (sender == this.database && signal.type == Signal.SignalType.CONNECTED && !this.ctx.tagConnected.getBool()) {
            this.needInit = true;
        } else if (sender == this.database && signal.type == Signal.SignalType.DISCONNECTED) {
            this.ctx.tagConnected.setBool(false);
        } else if (signal.type == Signal.SignalType.RELOADED) {
            // empty if block
        }
    }

    private void init() {
        this.ctx.tagConnected.setBool(false);
        if (this.ctx.emulated || this.database == null || !this.database.isConnected()) {
            return;
        }
        boolean res = this.database.executeScript((String)OPERHOUR_INIT_1).success;
        if (res) {
            DataService svc = this.ctx.service;
            try (Statement st = svc.createStatement();){
                svc.startSync();
                svc.finishSync(this.ctx.deleteOtherStuff);
                svc.commit();
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                svc.rollback();
            }
        }
        if (!res) {
            this.env.printError(this.logger, this.name, "Initialization error");
        }
        this.ctx.tagConnected.setBool(res);
        this.needInit = false;
    }

    @Override
    public boolean executeModule() {
        if (this.ctx.emulated) {
            this.tagtable.acceptWriteValues();
            return true;
        }
        if (this.database == null || !this.database.isConnected()) {
            return true;
        }
        if (this.needInit) {
            this.init();
        }
        if (this.ctx.tagConnected.getBool()) {
            try (Statement st = this.ctx.service.createStatement();){
                this.ctx.service.commit();
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name, ", Last sql =", this.ctx.service.getLastSql());
                this.ctx.service.rollback();
                this.ctx.tagConnected.setBool(false);
                this.needInit = true;
            }
        }
        return true;
    }

    @Override
    public boolean closedownModule() {
        this.ctx.tagConnected.setBool(false);
        this.removeAsSignalListerFromAllOthers();
        return true;
    }

    @Override
    public String getInfo() {
        if (!this.enable) {
            return "disabled";
        }
        if (this.ctx.emulated) {
            return "emulated";
        }
        return "";
    }

    @Override
    public String check() {
        return "";
    }

    @Override
    protected boolean reload() {
        OperhourModule tmp = new OperhourModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.closedown();
        this.copySettingsFrom(tmp);
        return true;
    }
}

