/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class KastBOT01Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(KastBOT01Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Tag tagState;
    protected Tag tagWorkCnt;
    protected Tag tagCurPdv;
    protected TagRW tagSearch;
    private static final int MAX_SENS_CNT = 50;
    private static final int MAX_PDV_CNT = 8;
    private static final int[] PDVi_SENS_ADR_START = new int[]{101, 152, 203, 254, 305, 356, 407, 458};
    public Tag[][] tagT;
    public Tag[] pdvTMax;
    private int[] PDViSensCnt;
    private int pdvCnt;

    public KastBOT01Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        int i;
        Configuration cm = this.env.getConfiguration();
        this.pdvCnt = cm.get(conf, "pdvCnt", 8);
        this.pdvCnt = this.pdvCnt > 8 ? 8 : this.pdvCnt;
        this.PDViSensCnt = new int[this.pdvCnt];
        for (i = 0; i < this.pdvCnt; ++i) {
            this.PDViSensCnt[i] = cm.get(conf, String.format("SensCnt_PDV%02d", i + 1), 50);
            this.PDViSensCnt[i] = this.PDViSensCnt[i] > 50 ? 50 : this.PDViSensCnt[i];
        }
        this.tagState = this.tagtable.createInt("State", 0, 8);
        this.tagWorkCnt = this.tagtable.createInt("WorkCnt", 0, 8);
        this.tagCurPdv = this.tagtable.createInt("CurPdv", 0, 8);
        this.tagSearch = this.tagtable.createRWInt("Search", 0, 8);
        this.tagT = new Tag[8][50];
        this.pdvTMax = new Tag[8];
        for (i = 0; i < this.pdvCnt; ++i) {
            this.pdvTMax[i] = this.tagtable.createInt(String.format("PDV%02d.TMax", i + 1), 0, 8);
            for (int j = 0; j < this.PDViSensCnt[i]; ++j) {
                this.tagT[i][j] = this.tagtable.createInt(String.format("PDV%02d.T%02d", i + 1, j + 1), 0, 8);
            }
        }
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagSearch.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            if (this.tagSearch.hasWriteValue()) {
                int value = this.tagSearch.getWriteValInt();
                result = this.protocol.requestCmd6(1, value);
            }
            if (result) {
                result = this.protocol.requestCmd3(0, 5);
                if (result) {
                    this.tagState.setInt(this.protocol.getAnswerWord(0));
                    this.tagWorkCnt.setInt(this.protocol.getAnswerWord(2));
                    this.tagCurPdv.setInt(this.protocol.getAnswerWord(4));
                }
                if (this.tagState.getInt() == 2) {
                    for (int i = 0; i < this.pdvCnt; ++i) {
                        short tmax = 0;
                        short val = 0;
                        result = this.protocol.requestCmd3(PDVi_SENS_ADR_START[i], this.PDViSensCnt[i]);
                        if (result) {
                            for (int j = 0; j < this.PDViSensCnt[i]; ++j) {
                                val = (short)this.protocol.getAnswerWord(j);
                                if (j == 0) {
                                    tmax = val;
                                }
                                this.tagT[i][j].setInt(val);
                                if ((tmax >= val || val == Short.MAX_VALUE) && (tmax != Short.MAX_VALUE || val == Short.MAX_VALUE)) continue;
                                tmax = val;
                            }
                        }
                        this.pdvTMax[i].setInt(tmax);
                    }
                }
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

