/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script;

import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.plugin.script.ScriptJava;

public class ScriptJavaEmpty
extends ScriptJava {
    private static final String MODULE_RD = "rd";
    private static final String MODULE_FAT = "fat";
    private static final int ENABLE_OFF = 0;
    Ref refFatRun;
    Ref refFatSet;
    Ref refFatCur;
    Ref refCurFlow;
    Ref refErrorFlag;
    Ref refPercent;
    Ref tagStart;
    Ref tagEnable;
    Ref tagZero;
    Ref tagDvUp;
    Ref tagDvDown;
    Ref tagTimeout;
    Ref tagAlarm;
    private int cnt;

    @Override
    public boolean load() {
        this.refCurFlow = this.createRef(this.getArg("src", ""));
        this.refErrorFlag = this.createRef(this.refCurFlow.getRefModuleName(), "SYSTEM.ErrorFlag");
        this.refPercent = this.createRef(MODULE_RD, "prm.L" + this.getId());
        this.refFatRun = this.createRef(MODULE_FAT, this.getId() + "_run");
        this.refFatSet = this.createRef(MODULE_FAT, this.getId() + "_set");
        this.refFatCur = this.createRef(MODULE_FAT, this.getId() + "_cur");
        this.tagStart = this.createTag("Start", 0);
        this.tagEnable = this.createTag("Enable", 0);
        this.tagZero = this.createTag("Zero", 0);
        this.tagDvUp = this.createTag("DvUp", 0);
        this.tagDvDown = this.createTag("DvDown", 0);
        this.tagTimeout = this.createTag("Timeout", 0);
        this.tagAlarm = this.createTag("Alarm", 0);
        this.cnt = 0;
        return true;
    }

    @Override
    public void execute() {
        if (this.refErrorFlag.getBool() || this.tagEnable.getInt() == 0) {
            this.tagAlarm.setInt(0);
            this.cnt = 0;
            return;
        }
        if (this.refCurFlow.getDouble() <= Math.max(this.tagZero.getDouble(), 0.0)) {
            this.refFatSet.setInt(0);
        } else {
            this.refFatSet.setInt((int)Math.round(this.refCurFlow.getDouble() / 100.0 * this.refPercent.getDouble()));
        }
        if (this.refFatCur.getInt() < this.refFatSet.getInt() - this.tagDvDown.getInt() || this.refFatCur.getInt() > this.refFatSet.getInt() + this.tagDvUp.getInt()) {
            if (this.cnt < this.tagTimeout.getInt()) {
                this.tagAlarm.setInt(0);
                ++this.cnt;
            } else {
                this.tagAlarm.setInt(1);
            }
        } else {
            this.tagAlarm.setInt(0);
            this.cnt = 0;
        }
    }
}

