/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.util.regex.Pattern;
import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.plugin.serial.SerialManagerModule;

public class CmdDisable
extends AbstractCommand {
    protected boolean modeDisable = true;

    @Override
    public String getName() {
        return "disable";
    }

    @Override
    public String getUsage() {
        return "all|port";
    }

    @Override
    public String getDescription() {
        return (this.modeDisable ? "dis" : "en") + "ables for all ports or for one port if specified";
    }

    @Override
    public String execute(Console console, Module module, String args) {
        String res;
        SerialManagerModule smm = (SerialManagerModule)module;
        if (!Pattern.matches("^all$|^\\d+$", args)) {
            return "";
        }
        if (args.equals("all")) {
            smm.ports.keySet().stream().forEach(port_id -> smm.enables.put((Integer)port_id, !this.modeDisable));
            res = (this.modeDisable ? "Dis" : "En") + "abled all ports";
        } else {
            int port_id2 = Integer.parseInt(args);
            smm.enables.put(port_id2, !this.modeDisable);
            res = (this.modeDisable ? "Dis" : "En") + "abled port " + port_id2;
        }
        smm.saveEnables();
        return res + " (use reload to apply)";
    }
}

