/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.func;

import java.util.LinkedList;
import java.util.Queue;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.func.FuncTag;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.core.tags.TagRW;

public class FuncTagAvg
extends FuncTag {
    private final TagRW tag;
    private final Ref refInput;
    private final long period;
    private final Queue<Rec> recs = new LinkedList<Rec>();

    public FuncTagAvg(Module module, String tagname, Object conf) {
        super(conf);
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.tag = TagRW.create(Tag.Type.INT, tagname, 0);
        this.refInput = EnvironmentInst.get().getRefFactory().createRef();
        this.refInput.init(conf, "input", module);
        this.period = Math.max(0, cm.get(conf, "period", 0));
    }

    @Override
    public boolean prepare() {
        return this.refInput.prepare();
    }

    @Override
    public void execute() {
        if (!this.refInput.linkIfNotValid()) {
            return;
        }
        long time = System.currentTimeMillis();
        this.recs.offer(new Rec(time, this.refInput.getDouble()));
        time -= this.period;
        while (this.recs.size() > 0 && this.recs.peek().time < time) {
            this.recs.poll();
        }
        double sum = this.recs.stream().mapToDouble(rec -> rec.value).sum();
        this.tag.setReadValDouble(sum / (double)this.recs.size());
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    private static class Rec {
        long time;
        double value;

        public Rec(long time, double value) {
            this.time = time;
            this.value = value;
        }
    }
}

