/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.jrbustcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagPlain;
import promauto.jroboplc.plugin.jrbustcp.JrbustcpProtocol;
import promauto.jroboplc.plugin.jrbustcp.JrbustcpServerModule;
import promauto.jroboplc.plugin.jrbustcp.Message;
import promauto.jroboplc.plugin.jrbustcp.TrafficHandler;
import promauto.utils.CRC;

public class ServerSession
implements Signal.Listener {
    private final Logger logger = LoggerFactory.getLogger(ServerSession.class);
    private static final Charset charset = Charset.forName("UTF-8");
    private Environment env;
    private JrbustcpServerModule module;
    private TrafficHandler trafficHandler;
    protected JrbustcpProtocol prot = new JrbustcpProtocol();
    private ByteBuf outbuf = null;
    protected String clientFilter;
    protected String clientDescr;
    private volatile boolean hasReloadSignal = false;
    private ListState cltagsListState;
    protected List<ClientTag> cltags = new ArrayList<ClientTag>();
    boolean useTagDescr = false;
    private boolean excludeExternal;
    private boolean includeHidden;
    private String authNonce;
    private boolean authAccepted = false;

    public ServerSession(JrbustcpServerModule module) {
        this.env = EnvironmentInst.get();
        this.module = module;
    }

    protected String getAuthNonce() {
        return this.authNonce;
    }

    private void subscribeSignals() {
        for (Module m : this.env.getModuleManager().getModules()) {
            m.addSignalListener(this);
        }
    }

    private void unsubscribeSignals() {
        for (Module m : this.env.getModuleManager().getModules()) {
            m.removeSignalListener(this);
        }
    }

    @Override
    public void onSignal(Module sender, Signal signal) {
        if (signal.type == Signal.SignalType.RELOADED) {
            this.hasReloadSignal = true;
        }
    }

    public String getInfo() {
        return String.format("%s filter=%s tags=%d", this.clientDescr, this.clientFilter, this.cltags.size());
    }

    public TrafficHandler getTrafficHandler() {
        return this.trafficHandler;
    }

    public void onConnected(Channel channel) {
        this.trafficHandler = (TrafficHandler)channel.pipeline().get("traffic");
        this.subscribeSignals();
    }

    public void onDisconnected(Channel channel) {
        this.unsubscribeSignals();
        if (this.outbuf != null && this.outbuf.refCnt() > 0) {
            this.outbuf.release();
            this.outbuf = null;
        }
    }

    public void onMessageReceived(Channel channel, ByteBuf inbuf) {
        try {
            Message msg;
            if (this.module.isLogging()) {
                this.env.logInfo(this.logger, "Server got request:\r\n" + ByteBufUtil.prettyHexDump((ByteBuf)inbuf) + "\r\n");
            }
            if (this.hasReloadSignal) {
                this.checkListStatus();
            }
            if ((msg = this.prot.getMessage(inbuf)) == null) {
                this.env.logError(this.logger, this.module.getName(), this.clientDescr, "Bad message:\r\n" + ByteBufUtil.hexDump((ByteBuf)inbuf) + "\r\n");
                return;
            }
            this.outbuf = channel.alloc().buffer();
            this.prot.writeHeader(this.outbuf, msg.reqId, msg.cmd | 0x80);
            if (this.module.isAuth() && !this.authAccepted && msg.cmd != 7 && msg.cmd != 8) {
                this.replyError(254);
            } else {
                switch (msg.cmd) {
                    case 1: {
                        this.onCommandInit(msg.body);
                        break;
                    }
                    case 2: {
                        this.onCommandList(msg.body);
                        break;
                    }
                    case 3: {
                        this.onCommandUpdate(msg.body);
                        break;
                    }
                    case 4: {
                        this.onCommandRead(msg.body);
                        break;
                    }
                    case 5: {
                        this.onCommandWrite(msg.body);
                        break;
                    }
                    case 6: {
                        this.onCommandCrc(msg.body);
                        break;
                    }
                    case 7: {
                        this.onCommandAuthInit(msg.body);
                        break;
                    }
                    case 8: {
                        this.onCommandAuthSubmit(msg.body);
                        break;
                    }
                    default: {
                        this.replyError(255);
                    }
                }
            }
            this.prot.writeFooter(this.outbuf);
            if (this.module.isLogging()) {
                this.env.logInfo(this.logger, "Server send answer:\r\n" + ByteBufUtil.prettyHexDump((ByteBuf)this.outbuf) + "\r\n");
            }
            channel.writeAndFlush((Object)this.outbuf);
            this.outbuf = null;
        }
        catch (Exception e) {
            this.env.logError(this.logger, e, this.module.getName(), channel.localAddress().toString());
            channel.close();
        }
    }

    private void replyError(int errorCode) {
        this.outbuf.setByte(this.outbuf.writerIndex() - 1, errorCode);
    }

    private void onCommandInit(ByteBuf msgbody) {
        this.clientFilter = this.prot.readShortString(msgbody);
        this.clientDescr = this.prot.readShortString(msgbody);
        this.setInitPrms(msgbody.readUnsignedShort());
        this.cltags = this.collectClientTags();
        this.cltagsListState = ListState.ACTUAL;
        this.outbuf.writeMedium(this.cltags.size());
    }

    private void setInitPrms(int initPrms) {
        this.useTagDescr = (initPrms & 1) > 0;
        this.prot.setUseTagStatus((initPrms & 2) > 0);
        this.excludeExternal = (initPrms & 4) > 0;
        this.includeHidden = (initPrms & 8) > 0;
    }

    private void onCommandList(ByteBuf msgbody) {
        int indexStart = msgbody.readUnsignedMedium();
        this.outbuf.writeMedium(indexStart);
        int qntPos = this.outbuf.writerIndex();
        this.outbuf.writeMedium(0);
        int nextPos = this.outbuf.writerIndex();
        this.outbuf.writeMedium(0);
        int n = 0;
        for (int i = indexStart; i < this.cltags.size(); ++i) {
            if (!this.prot.canWrite(this.outbuf)) {
                this.outbuf.setMedium(nextPos, i);
                break;
            }
            ClientTag cltag = this.cltags.get(i);
            String tagname = cltag.getTagname();
            if (tagname.length() > 255) {
                tagname = tagname.substring(0, 256);
            }
            String descr = "";
            this.outbuf.writeByte(this.prot.convertTagTypeToByte(cltag.tag));
            this.prot.writeShortString(this.outbuf, tagname);
            this.prot.writeShortString(this.outbuf, descr);
            ++n;
        }
        this.outbuf.setMedium(qntPos, n);
    }

    private void onCommandUpdate(ByteBuf msgbody) {
        int qnt = 0;
        int next = 0;
        boolean neednext = true;
        int n = this.cltags.size();
        for (int i = 0; i < n; ++i) {
            ClientTag cltag = this.cltags.get(i);
            if (!(cltag.tag.getType() == Tag.Type.DOUBLE && Double.isNaN(cltag.tag.getDouble()) && Double.isNaN(cltag.fixval.getDouble()) || cltag.tag.equalsValue(cltag.fixval) && (!this.prot.isUseTagStatus() || cltag.tag.getStatus() == cltag.fixval.getStatus()))) {
                cltag.tag.copyValueTo(cltag.fixval);
                cltag.fixval.setStatus(cltag.tag.getStatus());
                cltag.state = ClientTagState.NEED_SEND;
            }
            if (cltag.state == ClientTagState.NEED_SEND) {
                ++qnt;
                if (!neednext) continue;
                neednext = false;
                next = i;
                continue;
            }
            cltag.state = ClientTagState.OK;
        }
        this.outbuf.writeMedium(qnt);
        this.outbuf.writeMedium(next);
        this.outbuf.writeByte(this.cltagsListState == ListState.HAS_CHANGES ? 255 : 0);
    }

    private void onCommandRead(ByteBuf msgbody) {
        int indexStart = msgbody.readUnsignedMedium();
        int indexPos = this.outbuf.writerIndex();
        this.outbuf.writeMedium(0);
        int qntPos = this.outbuf.writerIndex();
        this.outbuf.writeMedium(0);
        int nextPos = this.outbuf.writerIndex();
        this.outbuf.writeMedium(0);
        int n = 0;
        boolean gap = false;
        for (int i = indexStart; i < this.cltags.size(); ++i) {
            if (!this.prot.canWrite(this.outbuf)) {
                this.outbuf.setMedium(nextPos, i);
                break;
            }
            ClientTag cltag = this.cltags.get(i);
            if (cltag.state == ClientTagState.OK) {
                gap = true;
                continue;
            }
            if (n == 0) {
                this.outbuf.setMedium(indexPos, i);
            } else if (gap) {
                this.prot.writeIndex(this.outbuf, i);
            }
            this.prot.writeValueAndStatus(this.outbuf, cltag.fixval);
            cltag.state = ClientTagState.SENT;
            gap = false;
            ++n;
        }
        this.outbuf.setMedium(qntPos, n);
    }

    private void onCommandWrite(ByteBuf msgbody) {
        int index = msgbody.readUnsignedMedium();
        int qnt = msgbody.readUnsignedMedium();
        int cltagsSize = this.cltags.size();
        int i = 0;
        while (i < qnt) {
            if ((index = this.prot.readIndex(msgbody, index)) < 0 || index >= cltagsSize) {
                throw new IndexOutOfBoundsException();
            }
            this.prot.readValue(msgbody, this.cltags.get((int)index).tag);
            ++i;
            ++index;
        }
    }

    private void onCommandCrc(ByteBuf msgbody) {
        long crc = CRC.getCompactCrc32FromTagStream(this.cltags.stream().map(cltag -> cltag.fixval));
        if (this.module.isLogging()) {
            this.env.logInfo(this.logger, "Calc crc for: " + CRC.getHexStringFromTagStream(this.cltags.stream().map(cltag -> cltag.fixval)) + " = " + crc + "\r\n");
        }
        this.outbuf.writeInt((int)crc);
    }

    private void onCommandAuthInit(ByteBuf msgbody) {
        String authKeyName = this.prot.readString(msgbody);
        if (!this.module.isAuth()) {
            this.outbuf.writeByte(2);
            return;
        }
        this.authNonce = RandomStringUtils.randomAlphanumeric((int)64);
        try {
            String authNonceEncrypted = this.env.getKeyManager().encryptPublic(authKeyName, this.authNonce);
            this.outbuf.writeByte(0);
            this.prot.writeString(this.outbuf, authNonceEncrypted);
        }
        catch (Exception e) {
            this.outbuf.writeByte(1);
            this.prot.writeString(this.outbuf, e.getLocalizedMessage());
        }
    }

    private void onCommandAuthSubmit(ByteBuf msgbody) {
        String authNonceReceived = this.prot.readString(msgbody);
        this.authAccepted = this.authNonce != null && authNonceReceived.equals(this.authNonce);
        this.outbuf.writeByte(this.authAccepted ? 0 : 255);
    }

    private List<ClientTag> collectClientTags() {
        Pattern pfilter;
        this.clientFilter = this.clientFilter.trim().isEmpty() ? ".*" : this.clientFilter;
        try {
            pfilter = Pattern.compile(this.clientFilter);
        }
        catch (PatternSyntaxException e) {
            this.clientFilter = ".*";
            pfilter = Pattern.compile(".*");
        }
        boolean tooMany = false;
        HashSet<String> tagnames = new HashSet<String>();
        LinkedList<ClientTag> list = new LinkedList<ClientTag>();
        for (Module m : this.env.getModuleManager().getModules()) {
            for (Tag tag : m.getTagTable().values()) {
                boolean skipModuleName;
                String tagname;
                if (!this.includeHidden && tag.hasFlags(2) || this.excludeExternal && tag.hasFlags(4) || !pfilter.matcher(tagname = ServerSession.makeTagname(m, tag, skipModuleName = tag.hasFlags(4))).matches() || tagnames.contains(tagname)) continue;
                list.add(new ClientTag(m, tag, tagname));
                tagnames.add(tagname);
                tooMany = list.size() == 0xFFFFFF;
                if (!tooMany) continue;
                break;
            }
            if (!tooMany) continue;
            break;
        }
        if (tooMany) {
            this.env.printInfo(this.logger, this.module.getName(), this.clientDescr, "Client requested too many tags");
        }
        ArrayList<ClientTag> result = new ArrayList<ClientTag>(list);
        result.sort(Comparator.comparing(ClientTag::getTagname));
        return result;
    }

    private void checkListStatus() {
        this.hasReloadSignal = false;
        List<ClientTag> list = this.collectClientTags();
        if (this.cltags.size() != list.size()) {
            this.cltagsListState = ListState.HAS_CHANGES;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get((int)i).tag == this.cltags.get((int)i).tag) continue;
                this.cltagsListState = ListState.HAS_CHANGES;
                break;
            }
        }
    }

    private static String makeTagname(Module m, Tag tag, boolean skipModuleName) {
        if (skipModuleName) {
            return tag.getName();
        }
        return m.getName() + "." + tag.getName();
    }

    public static class ClientTag {
        Module module;
        Tag tag;
        Tag fixval;
        ClientTagState state;
        String tagname;

        ClientTag(Module module, Tag tag, String tagname) {
            this.module = module;
            this.tag = tag;
            this.fixval = TagPlain.create(tag);
            this.fixval.setStatus(tag.getStatus());
            this.state = ClientTagState.NEED_SEND;
            this.tagname = tagname;
        }

        public String getTagname() {
            return this.tagname;
        }
    }

    public static enum ClientTagState {
        OK,
        NEED_SEND,
        SENT;

    }

    public static enum ListState {
        ACTUAL,
        HAS_CHANGES;

    }
}

